package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.entity.task.ComTaskSchedul;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.ShiftConflictResultDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.Result;

import java.util.List;

/**
 * <p>
 * 人员排班
 * </p>
 *
 * @author 罗鹏
 * @date 2018/3/5
 */
public interface ComTaskPerShiftService {

    Result pagePerShift(ParamDTO paramDTO) throws BusinessException;

    //重载pagePerShift方法，去掉分页
    Result pagePerShiftExport(ParamDTO paramDTO) throws BusinessException;



    Result getShiftByTask(ParamDTO paramDTO) throws BusinessException;


    /**
     * 校验周期制排班
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    Result validateSchedulCycle(ParamDTO paramDTO) throws BusinessException;

    Result validateSinglePerShift(ParamDTO paramDTO) throws BusinessException;

    //Result setSinglePerShift(ParamDTO paramDTO) throws BusinessException;
    //
    //Result resetSinglePerShift(ParamDTO paramDTO) throws BusinessException;

    /*公共的，校验班次是否有重复*/
    ShiftConflictResultDTO validateShiftConflict(String shiftIds, String date, Long perId, Long comTaskId) throws BusinessException;

    /**
     * 校验人员当日排班和历史已排班是否有时间冲突（当天的冲突，不需要校验时间段）
     */
    List<String> validateShiftDateConflict(String shiftId, String date, List<String> idList, Long comTaskId,Long comId);

    ShiftConflictResultDTO checkTaskFixed(String date, Long perId, Long comTaskId) throws BusinessException;

    ComTaskImplement packComTaskImplement(IdWorker idWorker, Long comId, Long comTaskId, Long perId,
                                          String date, String shiftId, Long shiftRuleId, String attendType, String isRest, Long createBy);

    ComTaskSchedul packComTaskSchedule(IdWorker idWorker, Long comId, Long comTaskId, Long perId, String date,
                                       String shiftId, String isRest);
}