package com.bcxin.oa.old.service.system;

import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.PublicConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.AESUtil;
import com.bcxin.oa.old.common.utils.BBDService;
import com.bcxin.oa.old.mapper.system.CacheMapper;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author: 陈堂君
 * @Date: 2018/1/2
 * @Description:
 * @Modified By:
 */
@Service
public class CacheServiceImpl implements CacheService {

	/**
	 * 日志对象
	 */
	protected Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private StringRedisTemplate stringRedisTemplate;

	@Autowired
	private CacheMapper cacheMapper;

	/**
	 * 得到库表的配置信息
	 *
	 * @param key
	 * @return value
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 15:46
	 */
	@Override
	public String getSystemConfig(String key) { // hash
		// api地址
		// https://docs.spring.io/spring-data/redis/docs/current/api/org/springframework/data/redis/core/RedisTemplate.html
		String redisKey = PublicConst.REDIS_HEAD + "SystemConfig";
		Map<String, Object> cacheMap = Maps.newHashMap();
		Object value = null;
		if (!stringRedisTemplate.hasKey(redisKey)) {
			// 查询数据库配置表，存为一个map，放入缓存，设置超时30分钟
			List<Map<String, Object>> list = cacheMapper.getSystemConfig();
			for (Map<String, Object> m : list) {
				cacheMap.put(String.valueOf(m.get("sysKey")), String.valueOf(m.get("sysValue")));
			}
			stringRedisTemplate.opsForHash().putAll(redisKey, cacheMap);
            stringRedisTemplate.expire(redisKey,PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS,TimeUnit.MILLISECONDS);
			value = cacheMap.get(key);
		} else {
			value = stringRedisTemplate.opsForHash().get(redisKey, key);
		}
		return String.valueOf(value);
	}

	/**
	 * 设置手机验证码缓存
	 *
	 * @param key
	 * @param value
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 16:16
	 */
	@Override
	public void setPhoneAuthCode(String key, String value) {
		// 使用冒号分隔，客户端工具可以形成命名空间折叠方便阅读。
		stringRedisTemplate.opsForValue().set(PublicConst.REDIS_HEAD + "PhoneAuthCode:" + key + value, value,
				PublicConst.PHONE_AUTH_CODE_TIMEOUT, TimeUnit.MILLISECONDS);
	}

	/**
	 * 获取手机验证码
	 *
	 * @param key
	 * @return
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 16:17
	 */
	@Override
	public String getPhoneAuthCode(String key, String value) {
		String result = stringRedisTemplate.opsForValue().get(PublicConst.REDIS_HEAD + "PhoneAuthCode:" + key + value);;
		return result;
	}

	@Override
	public void setLoginBBD(String key, String value) {
		key = PublicConst.REDIS_HEAD + "BBDLogInCode:" + key;
		if (!stringRedisTemplate.hasKey(key)) {
			stringRedisTemplate.opsForValue().set(key, value, PublicConst.BBD_LOGIN_TIMEOUT, TimeUnit.MILLISECONDS);
		}
	}

	@Override
	public String getLoginBBD(String key) {
		String result = stringRedisTemplate.opsForValue().get(PublicConst.REDIS_HEAD + "BBDLogInCode:" + key);
		return result;
	}


	/**
	 * 设置支付平台手机验证码校验码
	 * @param key
	 * @param value
	 * @auth llc
	 * @date 2019-06-21
	 */
	@Override
	public void setActiveCodeSerial(String key, String value) {
		// 使用冒号分隔，客户端工具可以形成命名空间折叠方便阅读。
		stringRedisTemplate.opsForValue().set(PublicConst.REDIS_HEAD + "ActiveCodeSerial:" + key, value,
				PublicConst.PHONE_AUTH_CODE_TIMEOUT, TimeUnit.MILLISECONDS);
	}

	/**
	 * 获取支付平台手机验证码校验码
	 * @param key
	 * @auth llc
	 * @date 2019-06-21
	 */
	@Override
	public String getActiveCodeSerial(String key) {
		String result = stringRedisTemplate.opsForValue().get(PublicConst.REDIS_HEAD + "ActiveCodeSerial:" + key);
		return result;
	}


	/**
	 * 获取百保盾acessToken
	 *
	 * @param comId
	 * @param platUrl
	 * @return accessToken
	 * @auth llc
	 * @date 2020-06-02
	 */
	@Override
	public String getBbdAccessToken(Long comId, String platUrl) {
		String redisKey = PublicConst.REDIS_HEAD + "bbdToken" + comId;
		String accessToken = "";
		if (!stringRedisTemplate.hasKey(redisKey)) {
			String comIdEncode = "";
			try {
				comIdEncode = AESUtil.encode(comId.toString());
			} catch (Exception e) {
				logger.error(e.getMessage());
			}
			Result result = BBDService.bbdLogin(comIdEncode, platUrl);
			if (result.getRetType().equals(Result.SUCCESS)) {
				Map<String, Object> resultMap = JSON.parseObject(result.getData().toString(), Map.class);
				if (resultMap != null) {
					accessToken = resultMap.get("sid").toString();
					/*** 百保盾token失效时间- 1小时 ***/
					Long expiresTime = PublicConst.ONE_MONTH_TIMEOUT_SECONDS - 3600L;
					stringRedisTemplate.opsForValue().set(redisKey, accessToken, expiresTime, TimeUnit.SECONDS);
				}
			} else {
				throw new BusinessException(Result.BUSINESS_ERROR, "登录公安子站失败");
			}
		} else {
			accessToken = stringRedisTemplate.opsForValue().get(redisKey);
		}
		return accessToken;
	}


	/**
	 * 区域代码缓存
	 *
	 * @param regionId
	 * @author llc
	 * @date 2019-04-11
	 */
	@Override
	public String getSysRegion(String regionId) {
		String redisKey = PublicConst.REDIS_HEAD + "region";
		String key = regionId;
		Map<String, String> cacheMap = Maps.newHashMap();
		Object regionInfo = null;
		if (!stringRedisTemplate.hasKey(redisKey)) {
			List<Map<String, String>> list = cacheMapper.getSysRegion();
			for (Map<String, String> m : list) {
				cacheMap.put(m.get("regionId"), JSON.toJSON(m).toString());
			}
			stringRedisTemplate.opsForHash().putAll(redisKey, cacheMap);
			stringRedisTemplate.expire(redisKey, PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS, TimeUnit.MILLISECONDS);
			regionInfo = cacheMap.get(key);
		} else {
			regionInfo = stringRedisTemplate.opsForHash().get(redisKey, key);
		}
		return String.valueOf(regionInfo);
	}

	/**
	 * 分发服务配置表缓存
	 * @param key
	 * @author llc
	 * @date 2021-03-13
	 */
	@Override
	public String getConfigBdp(String key) {
		String redisKey = PublicConst.REDIS_HEAD + "ConfigBdp";
		Map<String, Object> cacheMap = Maps.newHashMap();
		Object value = null;
		if (!stringRedisTemplate.hasKey(redisKey)) {
			// 查询数据库配置表，存为一个map，放入缓存，设置超时30分钟
			List<Map<String, Object>> list = cacheMapper.getConfigBdp();
			for (Map<String, Object> m : list) {
				cacheMap.put(String.valueOf(m.get("code")), JSON.toJSONString(m));
			}
			stringRedisTemplate.opsForHash().putAll(redisKey, cacheMap);
			stringRedisTemplate.expire(redisKey,PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS,TimeUnit.MILLISECONDS);
			value = cacheMap.get(key);
		} else {
			value = stringRedisTemplate.opsForHash().get(redisKey, key);
		}
		return String.valueOf(value);
	}
}
