package com.bcxin.oa.old.service.common;


import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.entity.task.ConfigIndustryDict;

/**
 * 企业班次
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
public interface CommonService {
    /**
     * @param shiftId（班次id）,
     * @param containShiftName（需要加入班次名称？）
     *    containShiftName == true    返回的字符串：  班次A:  09:00-18:00
     *    containShiftName == false   返回的字符串：   09:00-18:00
     * @param redNextDay（是否需要标记 次日 为红色）
     * @Author: zhongjianhui
     * @Description:班次时间列转行
     * @Date: 2018/02/26 14:05
     */
    String listChangeToString(Long shiftId, boolean containShiftName,boolean redNextDay);
    /**
     *  发送消息（调用罗总发送消息方法）
     *
     * @param tilte 标题
     * @param content 内容
     * @param messageType 消息类型
     * @param ids 接收人id，多个用,隔开
     * @apiNote 作者 zhongjianhui
     * @since 创建于 2018年4月23日 10:00:36
     */
    void sendMessageToApp(String tilte,String content,String messageType,String ids,Long comId,Long taskId);

    /**
     * 得到库表的配置信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/2 15:46
     * @param key
     * @return value
     */
    String getSystemConfig(String key);


    /**
     * 字典查询，通过字典ID
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2017/12/21 21:18
     */
    Result getConfigDictById(String codeTypes);

    /**
     * 行业字典查询，通过企业ID
     *
     * @param cid
     * @apiNote 作者 zxf
     * @since 创建于 2018/09/20 15:18
     */
    Result getConfigIndustryDictByComId(ConfigIndustryDict cid);

    /**
     * 机构字典查询，通过行业值
     * @param industryType 行业
     * @apiNote 作者 zxf
     * @since 创建于 2018/09/20 15:18
     */
    Result getInstitutionTypeByIndustryType(String industryType);

    /**
     * 返回银行编码表
     * 由于redisKey对应的value存在变动手动删除不方便
     * @author llc
     * @date 2019-06-24
     */

    Result getConfigBankList();

    /**
     * 返回银行编码表（key）
     * 由于redisKey对应的value存在变动手动删除不方便
     * @author lp
     * @date 2019-09-06
     */
    String getConfigBank(String key);

    /**
     * 通过接口删除redisKey方便下次加载
     * 由于redisKey对应的value存在变动手动删除不方便
     * @author llc
     * @date 2019-05-10
     */
    Result deleteRedisByKey(String key);

    /**
     * 通过接口批量删除redisKey方便下次加载
     *
     * @author zxf
     * @date 2020-05-13
     */
    Result batchDeleteRedisByKey(String key);


    /**
     * 获取系统时间
     *
     * @auth llc
     * @date 2020-08-21
     * @return
     * @throws Exception
     */

    Result getSystemTime();
}