package com.bcxin.oa.old.scheduling;


import com.bcxin.oa.old.service.task.ComTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


@Component
@Slf4j
public class TaskStatusJobHandler {

	@Resource
	private ComTaskService taskService;

	/**
	 * 定时修改任务状态(每小时执行一次)
	 */
	@Scheduled(cron = "0 0 0/1 * * ?")
	public void execute() {
		log.info("定时修改任务状态TaskStatusJobHandler启动！");
		taskService.changeTaskStatus();
		log.info("TaskStatusJobHandler执行结束");
	}

}
