package com.bcxin.oa.old.scheduling;


import com.bcxin.oa.old.service.task.ComTaskImplementService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


@Component
@Slf4j
public class TaskDayJobHandler {

	@Resource
	private ComTaskImplementService comTaskImplementService;

	/**
	 * 定时生成任务执行情况（每天23时执行）
	 */
	@Scheduled(cron = "0 0 23 * * ?")
	public void execute() {
		log.info("生成任务执行情况TaskDayJobHandler定时启动！");
		comTaskImplementService.runTaskImplement();
		log.info("TaskDayJobHandler执行结束");
	}
}
