package com.bcxin.oa.old.scheduling;

import com.bcxin.oa.old.service.task.ComTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
@Slf4j
public class TaskCardRemindJobHandler {

	@Resource
	private ComTaskService taskService;

	/**
	 * 外勤打卡提醒定时（每分钟轮询）
	 */
	@Scheduled(cron = "0 */1 * * * ?")
	public void execute() {
		log.info("外勤打卡提醒定时器TaskCardRemindJobHandler启动！");
		taskService.taskCardRemindJob();
		log.info("TaskCardRemindJobHandler执行结束");
	}

}
