package com.bcxin.oa.old.mapper.salary;


import com.bcxin.oa.old.entity.salary.ComSalaryTemp;
import com.bcxin.oa.old.entity.salary.ConfigSalaryType;
import com.bcxin.oa.old.dto.salary.ComSalaryTempDTO;
import com.bcxin.oa.old.dto.salary.ConfigSalaryCategoryDTO;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 企业薪酬模板
 *
 * @author llc
 * @date 2018-12-28
 */
public interface ComSalaryTempMapper{

    /**
     * 获取薪酬范畴配置
     * @author llc
     * @date 2019-01-02
     * @return
     */
    List<ConfigSalaryCategoryDTO> getConfigSalaryCategory();


    /**
     * 获取薪酬项目配置
     * @author llc
     * @date 2018-12-28
     * @return
     */
    List<ConfigSalaryType> getConfigSalaryType();


    /**
     * 校验是否存在同名的薪酬模板
     * @author llc
     * @date 2019-01-17
     * @return
     */
    int  checkSameNameSalaryTemp(ComSalaryTemp comSalaryTemp);

    /**
     * 插入企业薪酬模板
     * @author llc
     * @date 2018-12-28
     * @param comSalaryTemp
     * @return
     */
    int insertComSalaryTemp(ComSalaryTemp comSalaryTemp);

    /**
     * 更新企业薪酬模板
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTemp
     * @return
     */
    int updateComSalaryTemp(ComSalaryTemp comSalaryTemp);


    /**
     * 获取企业薪酬模板
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTempId
     * @return
     */
    ComSalaryTemp getComSalaryTempById(@Param("comSalaryTempId") Long comSalaryTempId);


    /**
     * 查询企业薪酬模板列表
     * @author llc
     * @date 2018-12-29
     * @param dto
     * @return
     */
    List<Map<String,Object>> getComSalaryTempList(ComSalaryTempDTO dto);


    /**
     * 删除企业薪酬模板
     * @author llc
     * @date 2018-12-29
     * @param comSalaryTempId
     * @return
     */
    int delComSalaryTempById(@Param("comSalaryTempId") Long comSalaryTempId);


    /**
     * 复制企业薪酬模板
     * @author llc
     * @date 2018-12-29
     * @param oldComSalaryTempId  旧的薪酬模板ID
     * @param newComSalaryTempId  新的薪酬模板ID
     * @param createBy  创建者
     * @param createTime  创建时间
     * @return
     */
    int copySalaryTemp(@Param("oldComSalaryTempId") Long oldComSalaryTempId,
                       @Param("newComSalaryTempId") Long newComSalaryTempId,
                       @Param("createBy") Long createBy,
                       @Param("createTime") Date createTime);

}