package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.TaskCardRemind;
import com.bcxin.oa.old.dto.TaskCardRemindDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 外勤打卡提醒定时器
 *
 * @author llc
 * @date 2019-01-12
 */
public interface TaskCardRemindMapper extends CrudDao<TaskCardRemind>{

    /**
     * 批量插入
     * @param list
     * @return
     */
    int batchInsert(@Param("list")List<TaskCardRemind> list);

    /**
     * 删除任务id
     * @param comTaskId
     * @return
     */
    int deleteByTask(@Param("comTaskId")Long comTaskId);

    /**
     * 查询需要提醒的外勤班次规则列表
     *
     * @param currentDate
     * @param currentTime
     * @return
     */
    List<TaskCardRemindDTO> getTaskCardRemindList(@Param("currentDate") String currentDate, @Param("currentTime") String currentTime );


    /**
     * 查询需要提醒的外勤人员列表
     *
     * @param currentDate
     * @param currentTime
     * @param taskCardRemindlist
     * @return
     */
    List<Map<String,String>> getTaskCardRemindPerList(@Param("currentDate") String currentDate,@Param("currentTime") String currentTime, @Param("list") List<TaskCardRemindDTO> taskCardRemindlist );


}