package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskChargeRecord;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 任务
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskMapper extends CrudDao<ComTask> {

    /**
     * 删除任务
     * @author llc
     * @date 2020-04-08
     * @param comTask
     * @return
     */
    int deleteTask(ComTask comTask);


    List<Map> listForTaskType(ComTaskDto comTaskDto);

    /**
     * 定时器跑，更新任务状态
     *
     *
     * @return
     */
    Integer updateAllTaskByTaskStatus();


    List<Map<String, String>> getIndustriesList(@Param("institutionType") String institutionType, @Param("industryType") String industryType, @Param("type") String type);
    /**
     * 查询任务负责人名称
     *
     * @param comTaskId
     * @return
     */
    String getChargePerName(@Param("comTaskId") Long comTaskId);



    /**
     * 获取任务负责人信息
     *
     * @param comTaskId
     * @date 2019-11-28
     * @author llc
     * @return
     */
    Map<String,String> getChargePerInfo(@Param("comTaskId") Long comTaskId);


    /**
     * 修改任务负责人
     *
     * @param comTask
     * @author llc
     * @date 2019-11-29
     * @return
     */
    Integer updateTaskChargePer(ComTask comTask);

    /**
     * <b> 根据任务id和企业id查询未投保人员名称列 </b>
     * @author ZXF
     * @create 2018/11/09 0009 14:27
     * @version
     * @注意事项 </b>
     */
    List<String> getTaskUnInsPerInfoList(@Param("comTaskId") Long comTaskId, @Param("comId") Long comId);


    /**
     * 查询任务考勤类型
     *
     * @param comTaskId
     * @return
     */
    String selectAttendType(Long comTaskId);

    /**
     * 查询任务信息
     *
     * @param comTaskId
     * @return
     */
    ComTask getComTaskByPrimaryKey(Long comTaskId);

    /**
     * 外勤列表（我发布的）
     * @return
     */
    List<Map> listTaskCreatePage(ComTaskDto dto);


    /**
     * 外勤列表（我负责的）
     * @return
     */
    List<Map> listTaskChargePage(ComTaskDto dto);

    /**
     * 新增任务负责人记录
     *
     * @param comTaskChargeRecord
     * @return
     */
    int addRecord(ComTaskChargeRecord comTaskChargeRecord);

    /**
     * 更新任务负责人记录信息
     *
     * @param comTaskChargeRecord
     * @return
     */
    int updateRecord(ComTaskChargeRecord comTaskChargeRecord);

    /**
     * 负责人名单
     * @return
     */
    List<Map> listTaskChargePerDetail(@Param("comTaskId")Long comTaskId);

    /**
     * 查询任务列表
     *
     * @param comTaskDto
     * @return
     */
    List<Map<String,Object>> getTaskList(ComTaskDto comTaskDto);



    /**
     * 查询导出任务列表
     * @param comTaskDto
     * @author llc
     * @date 2020-04-07
     * @return
     */
    List<Map<String,String>> getExportTaskList(ComTaskDto comTaskDto);


    /**
     * 查询任务类型名称（大任务/小任务）
     * @param taskType
     * by llc 2018-09-25
     */
    Map<String,String> getTaskTypeName(@Param("comId")Long comId , @Param("taskType")String taskType);


    /**
     * 获取地区全称
     * @param regionId
     * @return
     * by llc 2018-09-28
     */
    String getRegionFullName(@Param("regionId") Integer regionId);


    /**
     * 检测合同是否关联了任务
     * @param dto
     * @author llc
     * @date 2019-05-15
     */
    List<String> checkRelateTaskByContractId(ComTaskDto dto);


    /**
     * 获取公司任务驻勤点类型
     * @author llc
     * @date 2019-11-01
     * @param comTask
     * @return
     */
    List<Map<String,Object>> getComtaskStationType(ComTask comTask);

    /**
     * 查询任务列表
     * @author llc
     * @date 2019-11-01
     * @param comTask
     * @return
     */
    List<Map<String,Object>> getComTaskList(ComTask comTask);


    /**
     * 防控指挥获取任务人员位置
     * @author llc
     * @date 2019-11-01
     * @param comTask
     * @return
     */
    List<Map<String,Object>> getComTaskPerLocation(ComTask comTask);


    /**
     * 获取关联合同列表
     * @author llc
     * @date 2020-02-26
     * @param comTask
     * @return
     */
    List<Map<String,Object>> getRelationContractList(ComTask comTask);


    /**
     * 查询个人未生效任务
     * @author llc
     * @date 2020-04-10
     * @param dto
     * @return
     */
    List<Map<String,String>> getPerNoEffectTaskList(ComTaskDto dto);


    /**
     * 查询个人已生效任务
     * @author llc
     * @date 2020-04-10
     * @param dto
     * @return
     */
    List<Map<String,String>> getPerEffectTaskList(ComTaskDto dto);



    /**
     * 获取即将到期的任务
     * @author llc
     * @date 2020-04-24
     * @param
     * @return
     */
    List<Map<String,String>> getSoonExpireTask();


    /**
     * 校验驻勤点名称唯一性
     * @author llc
     * @date 2020-05-06
     * @param comId
     * @param comTaskId
     * @param taskName
     * @return
     */
    int checkTaskNameUnique(@Param("comId")Long comId ,@Param("comTaskId")Long comTaskId , @Param("taskName")String taskName);

    /**
     * 通过合同ID查找驻勤点
     *
     * @return
     * @author llc
     * @date 2020-06-10
     */
    List<Map<String,Object>> getTaskListByContractId(ComTask comTask);


    /**
     * 公安获取任务驻勤点类型
     * @author llc
     * @date 2020-07-02
     * @param comTask
     * @return
     */
    List<Map<String,Object>> policeGetTaskStationType(ComTask comTask);

    /**
     * 公安防控指挥获取任务列表
     * @author llc
     * @date 2020-07-02
     * @param dto
     * @return
     */
    List<Map<String,Object>> policeGetTaskList(ComTaskDto dto);


    /**
     * 公安防控指挥获取任务位置列表
     * @author llc
     * @date 2020-07-09
     * @param dto
     * @return
     */
    List<Map<String,Object>> policeGetTaskLocationList(ComTaskDto dto);

    /**
     * 公安防控指挥获取任务信息
     * @author llc
     * @date 2020-07-09
     * @param dto
     * @return
     */
    Map<String,Object> policeGetTaskById(ComTaskDto dto);

    /**
     * 获取区域和监管信息
     *
     * @param comTaskId
     * @date 2021-03-13
     * @author llc
     * @return
     */
    Map<String,String> getRegionAndPoliceInfo(@Param("comTaskId") Long comTaskId);



}