package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.dto.ComTaskImplementDto;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 任务执行情况表
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskImplementMapper extends CrudDao<ComTaskImplement> {


	void deleteImplementByTask(@Param("date") String cdate, @Param("perId") Long perId,
							   @Param("comTaskId") Long comTaskId);

	void deleteImplementByTaskInRange(@Param("startDate") String startDate,@Param("endDate") String endDate, @Param("perId") Long perId,
									  @Param("comTaskId") Long comTaskId);


	List<MultiDataDTO> listAttendanceRecord(ComTaskImplementDto comTaskImplementDto);


	/**
	 * 获得指定日期白天的排班记录
	 * @param perId
	 * @param date
	 * @return
	 */
	List<MultiDataDTO> getAppointedImplementDataIdByDate(@Param("perId")Long perId,@Param("date")String date);


	/**
	 * 统计任务当月每天的班次数量
	 * @param comTaskId
	 * @param beginDate
	 * @param endDate
	 * @return
	 */
	List<MultiDataDTO> groupMonthPerTask(@Param("comTaskId") Long comTaskId,
					  @Param("beginDate") Date beginDate,
					  @Param("endDate") Date endDate);


	/**
	 * 统计任务当月每天的排班情况
	 * @param comTaskId
	 * @param beginDate
	 * @param endDate
	 * @return
	 */
	List<MultiDataDTO> listMonthPerTask(@Param("comTaskId") Long comTaskId,
										 @Param("perId") Long perId,
										 @Param("beginDate") Date beginDate,
										 @Param("endDate") Date endDate);


	/**
	 * 指定日期当天排班班次人员
	 * @param comTaskId
	 * @param dates
	 * @param dates
	 * @return
	 */
	List<MultiDataDTO> listDatesTaskShift(@Param("comTaskId") Long comTaskId,
										 @Param("dates") String dates);

	/**
	 * 批量插入任务执行情况表
	 *
	 * @param list
	 * @return
	 */
	int insertComTaskImplementList(List<ComTaskImplement> list);

	/**
	 * 批量插入任务执行情况表
	 *
	 * @param list
	 * @return
	 */
	int insertBatch(List<ComTaskImplement> list);



	/**
	 * 删除未到的班次（人员）
	 *
	 * @param comTaskId
	 * @return
	 */
	int deleteTaskImplementByDateAndPerList(@Param("comTaskId") Long comTaskId,
											@Param("perIdList") List<String> perIdList);

	/**
	 * 删除未到的班次（人员）
	 *
	 * @param comTaskId
	 * @return
	 */
	int deleteTaskImplementByDateAndPer(@Param("comTaskId") Long comTaskId,
											@Param("perId")Long perId);

	/**
	 * 删除未到的班次（人员）
	 *
	 * @param comTaskId
	 * @return
	 */
	int deleteRestTaskImplementByDateAndPerList(@Param("comTaskId") Long comTaskId,
											@Param("perIdList") List<String> perIdList,
											@Param("today") String today);


	/**
	 * 删除未到的班次（人员）
	 *
	 * @param comTaskId
	 * @return
	 */
	int deleteRestTaskImplementByDateAndPer(@Param("comTaskId") Long comTaskId,
												@Param("perId") Long perId,
												@Param("today") String today);


	/**
	 * 查询需要进行排班的的数据
	 *
	 * @return
	 */
	List<ComTaskImplement> listComTaskImplement();

	/**
	 * 根据任务Id查询需要进行排班的人员
	 *
	 * @param comTaskId
	 * @param comId
	 * @return
	 */
	List<ComTaskImplement> listComTaskImplementById(@Param("comTaskId") Long comTaskId, @Param("comId") Long comId);




	/**
	 * 任务执行情况Id列表
	 *
	 * @param comTaskImplement
	 * @return
	 */
	List<Long> listTaskImplementId(ComTaskImplement comTaskImplement);


	/**
	 * 任务执行情况信息
	 *
	 * @param multiDataDTO
	 * @return
	 */
	List<MultiDataDTO> listTaskImplement(MultiDataDTO multiDataDTO);

	/**
	 * 出勤情况列表
	 *
	 * @param multiDataDTO
	 * @return
	 */
	List<MultiDataDTO> listImplement(MultiDataDTO multiDataDTO);

	/**
	 * 根据日期分类
	 *
	 * @param comTaskId
	 * @return
	 */
	List<MultiDataDTO> listDate(@Param(value = "comTaskId") Long comTaskId);

	/**
	 * 根据人员分类
	 *
	 * @param comTaskId
	 * @return
	 */
	List<MultiDataDTO> listPer(@Param(value = "comTaskId") Long comTaskId);

	/**
	 * 查询任务轨迹最近出勤月份
	 *
	 * @param comTaskId
	 * @return
	 */
	String selectImplementMonth(@Param(value = "comTaskId") Long comTaskId);


	/**
	 * 上班打卡更新执行情况状态
	 *
	 * @param comTaskImplement
	 * @return
	 * @author zhangye
	 * @date 2018/11/10
	 */
	int saveTaskSign(ComTaskImplement comTaskImplement);

	/**
	 * 下班打卡更新执行情况状态
	 *
	 * @param comTaskImplement
	 * @return
	 * @author zhangye
	 * @date 2018/11/10
	 */
	int saveTaskOut(ComTaskImplement comTaskImplement);


	/**
	 * 按人员列表删除未到的班次但是已经提前打卡
	 *
	 * @param comTaskId
	 * @param perIdList
	 * @return
	 */
	int deletePerTaskCardRecordByPerson(@Param("comTaskId") Long comTaskId, @Param("perIdList") List<String> perIdList);


	/**
	 * 删除李四2019-02-22不在A任务的任务执行情况(休息的不处理) 或者在A任务的任务执行情况
	 *
	 * @param acceptPerIds
	 * @param comId
	 * @param dates
	 * @param comTaskId
	 * @return
	 * @author llc
	 * @date 2019-02-22
	 */
	int deleteImplementByBehalf(@Param("list") List<String> acceptPerIds,@Param("comId") Long comId,@Param("dates") String dates,@Param("comTaskId") Long comTaskId);


	/**
	 * 删除任务人员明天之后的排班记录
	 *
	 * @param perIdList
	 * @param comId
	 * @param comTaskId
	 * @param date
	 * @return
	 * @author llc
	 * @date 2019-11-29
	 */
	int deleteImplementByPerIdList(@Param("list") List<String> perIdList,@Param("comId") Long comId,@Param("comTaskId") Long comTaskId,@Param("date") String date);



	/**
	 * 删除任务之后的排班记录
	 * @param comTaskId
	 * @param comId
	 * @param date
	 * @return
	 * @author llc
	 * @date 2020-04-10
	 */
	int deleteImplementFromDate(@Param("comTaskId") Long comTaskId,@Param("comId") Long comId,@Param("date") String date);


	/**
	 * 删除当日的任务执行情况
	 *
	 * @param comTaskId
	 * @param comId
	 * @param date
	 * @param perIdList
	 * @return
	 * @author llc
	 * @date 2020-04-15
	 */
	int deleteByPerListAndDate(@Param("date") String date, @Param("perIdList") List<String> perIdList, @Param("comTaskId") Long comTaskId, @Param("comId") Long comId);
}