package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskCycleShift;
import com.bcxin.oa.old.entity.task.ComTaskSchedulCycle;
import com.bcxin.oa.old.dto.ComTaskCycleShiftDTO;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 任务排班周期所选班次
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskCycleShiftMapper extends CrudDao<ComTaskCycleShift> {

    List<MultiDataDTO> getTaskCycleShift(@Param("cycleId") Long cycleId);

    /**
     * 周期班次
     * @param cycleList
     * @return
     */
    List<MultiDataDTO> getTaskCycleShiftByList(@Param("cycleList") List<ComTaskSchedulCycle> cycleList);

    /**
     * 查询任务排班周期所选班次
     *
     * @param taskSchedulCycleId
     * @return
     */
    List<ComTaskCycleShiftDTO> getTaskCycleShiftById(Long taskSchedulCycleId);

    /**
     * 批量删除排班周期所选班次信息
     *
     * @param list
     * @return
     */
    int batchDeleteTaskSchedulCycle(List<Long> list);

    /**
     * 批量插入任务排班周期所选班次
     *
     * @param listComTaskCycleShift
     * @return
     */
    int batchInsertComTaskCycleShift(List<ComTaskCycleShift> listComTaskCycleShift);
}
