package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComAttendGroupFixed;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 企业考勤组固定班制明细
 *
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
public interface ComAttendGroupFixedMapper extends CrudDao<ComAttendGroupFixed> {
    /**
     * 根据考勤组ID删除固定班制明细
     *
     * @author zhangye
     * @since 2018-02-21 15:05:27
     */
    int deleteByAttendGroupId(Long attendGroupId);

    /**
     * 根据班次ID获取考勤组
     *
     * @author wangjianchi
     * @since 2018-03-06 10:18:27
     */
    ComAttendGroupFixed getAttendGroupByShiftId(@Param("shiftId") Long shiftId);

    /**
     * 批量插入固定排班
     *
     * @param attendGroupFixedList
     * @return
     */
    int insertComAttendGroupFixed(List<ComAttendGroupFixed> attendGroupFixedList);


    /**
     * 获取考勤设置的第一个页面的工作安排
     *
     * @param comAttendGroupFixed
     * @return
     */
    List<Map<String,String>> getFixedDetailList (ComAttendGroupFixed comAttendGroupFixed);


    /**
     * 查询考勤组固定班制明细
     *
     * @param attendGroupId
     * @return
     * by llc 2018-11-19
     */
    List<ComAttendGroupFixed> getComAttendGroupFixedList (@Param("attendGroupId") Long attendGroupId,@Param("createTime") Date createTime);


    /**
     * 批量更新旧的固定班次为失效
     *
     * @param attendGroupFixedList
     * @return
     * by llc 2018-11-19
     */
    int invalidComAttendGroupFixed(@Param("list") List<ComAttendGroupFixed> attendGroupFixedList,
                                   @Param("updateBy") Long updateTime,
                                   @Param("effectStartTime") Date effectStartTime);
}
