package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.AttendCardRemind;
import com.bcxin.oa.old.dto.AttendCardRemindDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 内勤打卡提醒定时器
 *
 * @author llc
 * @date 2019-01-10
 */
public interface AttendCardRemindMapper{



    /**
     * 查询需要提醒的考勤组列表
     *
     * @param currentDate
     * @param currentTime
     * @return
     */
    List<AttendCardRemindDTO> getAttendCardRemindList(@Param("currentDate") String currentDate, @Param("currentTime") String currentTime );


    /**
     * 查询需要提醒的考勤人员列表
     *
     * @param currentDate
     * @param currentTime
     * @param attendCardRemindlist
     * @return
     */
    List<Map<String,String>> getAttendCardRemindPerList(@Param("currentDate") String currentDate,@Param("currentTime") String currentTime, @Param("list") List<AttendCardRemindDTO> attendCardRemindlist );


    /**
     * 查询需要提醒的考勤人员列表
     *
     * @param attendGroupId
     * @return
     */
    int delAttendCardRemind(@Param("attendGroupId") Long attendGroupId);


    /**
     * 批量插入内勤打卡提醒
     *
     * @param attendCardRemindList
     * @return
     */
    int batchInsertAttendCardRemind(@Param("list") List<AttendCardRemind> attendCardRemindList);

}