package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业考勤组固定班制明细
 * 
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
@TableName("com_attend_group_fixed")
@Data
public class ComAttendGroupFixed extends BaseEntity<ComAttendGroupFixed> {
	private static final long serialVersionUID = 878096224L;

	/** 考勤组固定班制ID */
	@ApiModelProperty(value = "考勤组固定班制ID")
	private Long attendGroupFixedId;

	/** 星期几 */
	@ApiModelProperty(value = "星期几")
	private int weekDay;

	/** 是否休息 */
	@ApiModelProperty(value = "是否休息")
	private String isRest;

	/** 考勤组ID */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	/** 班次ID */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupFixedId() {
		return attendGroupFixedId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}


}