package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业考勤地址
 * 
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
@TableName("com_attend_address")
@Data
public class ComAttendAddress extends BaseEntity<ComAttendAddress> {
	private static final long serialVersionUID = 984814082L;

	/** 考勤地址ID */
	@ApiModelProperty(value = "考勤地址ID")
	private Long attendAddressId;

	/** 考勤地址 */
	@ApiModelProperty(value = "考勤地址")
	private String address;

	/** 考勤地址经度 */
	@ApiModelProperty(value = "考勤地址经度")
	private String addressLongitude;

	/** 考勤地址纬度 */
	@ApiModelProperty(value = "考勤地址纬度")
	private String addressLatitude;

	/** 考勤范围（米为单位） */
	@ApiModelProperty(value = "考勤范围（米为单位）")
	private Long addressRange;

	/** 考勤组ID */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendAddressId() {
		return attendAddressId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}

}