package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Date;

/**
 * 人员每日考勤详情dto
 *
 * @author llc
 * @date 2018-12-06
 */
@Data
public class PerAttendDateDTO extends BaseEntity<PerAttendDateDTO> {

    /** 人员Id */
    private Long perId;

    /** 考勤组Id */
    private Long attendGroupId;

    /** 考勤日期 */
    private String attendDate;

    /** 第几轮 */
    private int commutRound;

    /** 打卡类型 */
    private String clockInType;

    /** 考勤状态 */
    private String attendStatus;

    /** 修改的时间 */
    private int minute;

    /** 打卡记录ID */
    private Long attendCardRecordId;


    /** 考勤时间 */
    private Date attendTime;

    /** 打卡时间 */
    private Date clockInTime;

    /** 备注 */
    private String remark;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getAttendGroupId() {
        return attendGroupId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getAttendCardRecordId() {
        return attendCardRecordId;
    }

}
