package com.bcxin.oa.old.service.task.app;

import cn.hutool.core.date.DateUtil;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.dto.app.AppPerTaskCardRecordDTO;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.mapper.app.PerTaskCardRecordMapper;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 任务打卡记录
 *
 * @author wangjianchi
 * @since 2018-03-08 11:29:13
 */
@Service
@Transactional
public class PerTaskCardRecordServiceImpl implements PerTaskCardRecordService {
	@Resource
	private ComShiftRuleMapper comShiftRuleMapper;

	@Resource
	private ComTaskImplementMapper comTaskImplementMapper;

	@Resource
	private ComShiftMapper comShiftMapper;

	@Resource
	private PerTaskCardRecordMapper perTaskCardRecordMapper;

	@Resource
	private ComTaskFeedbackMapper comTaskFeedbackMapper;

	@Resource
	private ComTaskMapper comTaskMapper;

	@Resource
	private PerBaseInfoMapper perBaseInfoMapper;

	@Resource
	private CommonService commonService;

	@Resource
	private IdWorker idWorker;

	@Resource
	private BbdTestService bbdTestService;

	/**
	 * APP-任务考勤上班打卡记录
	 *
	 * @param appPerTaskCardRecordDTO
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/16
	 */
	@Override
	public Result saveTaskSign(AppPerTaskCardRecordDTO appPerTaskCardRecordDTO) throws BusinessException {

		Date date = new Date();

		// 查询任务执行情况信息
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(appPerTaskCardRecordDTO.getTaskImplementId());

		// 实际上班时间
		comTaskImplement.setOnClockInTime(date);
		comTaskImplement.setUpdateBy(appPerTaskCardRecordDTO.getUpdateBy());
		comTaskImplement.setUpdateTime(new Date());

		// 查询班次信息
		ComShift comShift = comShiftMapper.getByPrimaryKey(comTaskImplement.getShiftId());

		// 查询班次规则信息
		ComShiftRule comShiftRule = comShiftRuleMapper.getByPrimaryKey(comTaskImplement.getShiftRuleId());
		// 设置的打卡时间
		// 规定的上班打卡时间
		Date workTimeStart = DateUtils.parseDate(DateUtils.formatDate(comTaskImplement.getDates()) + " "
				+ DateUtils.formatDate(comShiftRule.getStartWorkTime(), "HH:mm:ss"));

		appPerTaskCardRecordDTO.setClockInDate(comTaskImplement.getDates());
		appPerTaskCardRecordDTO.setClockInTime(date);
		appPerTaskCardRecordDTO.setComId(comTaskImplement.getComId());
		appPerTaskCardRecordDTO.setClockInRound(comShiftRule.getCommutRound());
		appPerTaskCardRecordDTO.setShiftId(comTaskImplement.getShiftId());
		appPerTaskCardRecordDTO.setShiftRuleId(comTaskImplement.getShiftRuleId());
		appPerTaskCardRecordDTO.setPerId(comTaskImplement.getPerId());
		appPerTaskCardRecordDTO.setComTaskId(comTaskImplement.getComTaskId());
		appPerTaskCardRecordDTO.setSetClockInTime(workTimeStart);

		// 校验规则开关关闭，则按系统默认规则进行校验是否迟到早退
		if (!CommonConst.Y.equals(comShift.getPermitLateSwitch()) && !CommonConst.Y.equals(comShift.getAbsentSwitch())
				&& !CommonConst.Y.equals(comShift.getClockLimitSwitch())) {
			// 规定的上班打卡时间
			if (date.getTime() > workTimeStart.getTime()) {
				// 迟到
				appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_CD);
				comTaskImplement.setAttendStatus(DictConst.ATTENDSTATUS_CD);

			} else {
				// 正常
				appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
				comTaskImplement.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
			}
		} else {
			if (CommonConst.Y.equals(comShift.getPermitLateSwitch())) {
				// 允许迟到校验开关（打开）
				// 可以打卡的时间
				Date permitLateUp = DateUtils.getDayAfterSomeMinute(workTimeStart, comShift.getPermitLateUp());

				if (date.getTime() > permitLateUp.getTime()) {// 当前时间>（上班时间+迟到时间）=迟到业务
					// 迟到
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_CD);
					comTaskImplement.setAttendStatus(DictConst.ATTENDSTATUS_CD);
				} else {
					// 正常，上面已经校验打卡时限，无需再校验
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
					comTaskImplement.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
				}
			}
		}
		// 判断是否已经存在上班打卡记录
		List<PerTaskCardRecord> list = perTaskCardRecordMapper.getExitPerTaskCardRecord(appPerTaskCardRecordDTO);
		PerTaskCardRecord perTaskCardRecordDB = null;
		if (list != null && list.size() > 0) {
			if (list.size() == 1) {
				perTaskCardRecordDB = list.get(0);
			} else {
				throw new BusinessException(Result.ERROR, "打卡失败,存在多条上班打卡记录");
			}
		}
		if (perTaskCardRecordDB == null) {
			Long taskCardRecordId = idWorker.nextId();
			appPerTaskCardRecordDTO.setTaskCardRecordId(taskCardRecordId);
			int status = perTaskCardRecordMapper.insert(appPerTaskCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "任务打卡失败，请稍后重试");
			}
		} else {
			// 如果任务状态是请假，则不更新任务状态，只更新打卡时间
			if (perTaskCardRecordDB.getAttendStatus().equals(DictConst.ATTENDSTATUS_QJ)) {
				appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_QJ);
			}
			appPerTaskCardRecordDTO.setTaskCardRecordId(perTaskCardRecordDB.getTaskCardRecordId());
			int status = perTaskCardRecordMapper.update(appPerTaskCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "任务打卡失败，请稍后重试");
			}
		}
		int status1 = comTaskImplementMapper.saveTaskSign(comTaskImplement);
		if (status1 <= 0) {
			throw new BusinessException(Result.ERROR, "任务打卡失败，请稍后重试");
		}

		/*** 同步百保盾 ***/

//		ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
//		threadPool.execute(new Runnable() {
//			@Override
//			public void run() {
				bbdTestService.bbdSyncPerTaskCardRecord(appPerTaskCardRecordDTO);
//			}
//		});

		/* 迟到通知 */
		if (DictConst.ATTENDSTATUS_CD.equals(comTaskImplement.getAttendStatus())) {
			notifyExceptionSign(comTaskImplement, DictConst.ATTENDSTATUS_CD);
		}

		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * APP-任务考勤下班打卡
	 *
	 * @param appPerTaskCardRecordDTO
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/16
	 */
	@Override
	public Result saveTaskOut(AppPerTaskCardRecordDTO appPerTaskCardRecordDTO) throws BusinessException {
		if (StringUtils.isEmpty(appPerTaskCardRecordDTO.getFeedbackContent())) {
			throw new BusinessException(Result.BUSINESS_ERROR, "添加任务日志记录失败:反馈日志不能为空");
		}
		Date date = new Date();
		// 查询任务执行情况信息
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(appPerTaskCardRecordDTO.getTaskImplementId());

		// 实际下班时间
		comTaskImplement.setOffClockInTime(date);
		comTaskImplement.setUpdateBy(appPerTaskCardRecordDTO.getUpdateBy());
		comTaskImplement.setUpdateTime(new Date());
		// 查询班次信息
		ComShift comShift = comShiftMapper.getByPrimaryKey(comTaskImplement.getShiftId());

		// 查询班次规则信息
		ComShiftRule comShiftRule = comShiftRuleMapper.getByPrimaryKey(comTaskImplement.getShiftRuleId());

		// 对象赋值
		appPerTaskCardRecordDTO.setClockInDate(comTaskImplement.getDates());
		appPerTaskCardRecordDTO.setClockInTime(date);
		appPerTaskCardRecordDTO.setComId(comTaskImplement.getComId());
		appPerTaskCardRecordDTO.setClockInRound(comShiftRule.getCommutRound());
		appPerTaskCardRecordDTO.setShiftId(comTaskImplement.getShiftId());
		appPerTaskCardRecordDTO.setShiftRuleId(comTaskImplement.getShiftRuleId());
		appPerTaskCardRecordDTO.setPerId(comTaskImplement.getPerId());
		appPerTaskCardRecordDTO.setComTaskId(comTaskImplement.getComTaskId());

		// 下班打卡
		// 次日打卡
		if (CommonConst.Y.equals(comShiftRule.getIsEndNextDay())) {
			// 规定的明天下班打卡时间
			Date workEndTimeTomorrow = DateUtils.parseDate(DateUtils.getDayAfterSomeDay(comTaskImplement.getDates(), 1)
					+ " " + DateUtils.formatDate(comShiftRule.getEndWorkTime(), "HH:mm:ss"));
			appPerTaskCardRecordDTO.setSetClockInTime(workEndTimeTomorrow);
			// 打卡时限开关
			if (CommonConst.Y.equals(comShift.getClockLimitSwitch())) {

				// 下班打卡时间上限
				Date clockWorkLimit = DateUtils.getDayAfterSomeMinute(workEndTimeTomorrow,
						comShift.getClockWorkLimit());
				if (date.getTime() > clockWorkLimit.getTime()) {
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_QK);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_QK);
					throw new BusinessException(Result.ERROR, "超过规定下班打卡时间，打卡失败");
				} else if (date.getTime() > workEndTimeTomorrow.getTime()
						&& date.getTime() < clockWorkLimit.getTime()) {
					// 正常下班
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZC);
				} else {
					// 早退
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZT);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZT);
				}
			} else {
				if (date.getTime() < workEndTimeTomorrow.getTime()) {
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZT);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZT);
				} else {
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZC);
				}
			}
		} else {
			// 规定的下班打卡时间
			Date workTimeEnd = DateUtils.parseDate(DateUtils.formatDate(comTaskImplement.getDates()) + " "
					+ DateUtils.formatDate(comShiftRule.getEndWorkTime(), "HH:mm:ss"));
			appPerTaskCardRecordDTO.setSetClockInTime(workTimeEnd);
			// 今日下班打卡
			// 打卡时限开关(打开)
			if (CommonConst.Y.equals(comShift.getClockLimitSwitch())) {
				// 下班打卡时间上限
				Date clockWorkLimit = DateUtils.getDayAfterSomeMinute(workTimeEnd, comShift.getClockWorkLimit());
				if (date.getTime() > clockWorkLimit.getTime()) {
					throw new BusinessException(Result.ERROR, "超过规定下班打卡时间，打卡失败");
				} else if (date.getTime() > workTimeEnd.getTime() && date.getTime() < clockWorkLimit.getTime()) {
					// 正常下班
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZC);
				} else {
					// 早退
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZT);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZT);
				}
			} else {
				// 打卡时限开关(关闭)
				if (date.getTime() < workTimeEnd.getTime()) {
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZT);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZT);
				} else {
					appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_ZC);
					comTaskImplement.setOffAttendStatus(DictConst.ATTENDSTATUS_ZC);
				}
			}
		}
		// 判断是否已经存在上班打卡记录
		List<PerTaskCardRecord> list = perTaskCardRecordMapper.getExitPerTaskCardRecord(appPerTaskCardRecordDTO);
		PerTaskCardRecord perTaskCardRecordDB = null;
		if (list != null && list.size() > 0) {
			if (list.size() == 1) {
				perTaskCardRecordDB = list.get(0);
			} else {
				throw new BusinessException(Result.ERROR, "打卡失败,存在多条上班打卡记录");
			}
		}
		if (perTaskCardRecordDB == null) {
			Long taskCardRecordId = idWorker.nextId();
			appPerTaskCardRecordDTO.setTaskCardRecordId(taskCardRecordId);
			int status = perTaskCardRecordMapper.insert(appPerTaskCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "任务打卡失败，请稍后重试");
			}
		} else {
			// 如果任务状态是请假，则不更新任务状态，只更新打卡时间
			if (perTaskCardRecordDB.getAttendStatus().equals(DictConst.ATTENDSTATUS_QJ)) {
				appPerTaskCardRecordDTO.setAttendStatus(DictConst.ATTENDSTATUS_QJ);
			}
			appPerTaskCardRecordDTO.setTaskCardRecordId(perTaskCardRecordDB.getTaskCardRecordId());
			int status = perTaskCardRecordMapper.update(appPerTaskCardRecordDTO);
			if (status <= 0) {
				throw new BusinessException(Result.ERROR, "任务打卡失败，请稍后重试");
			}
		}


//		// 记录任务日志
//		ComTaskFeedback comTaskFeedback = new ComTaskFeedback();
//		ObjectUtils.copyProperties(comTaskFeedback, appPerTaskCardRecordDTO);
//		comTaskFeedback.setTaskFeedbackId(idWorker.nextId());
//		comTaskFeedback.setFeedbackPerId(appPerTaskCardRecordDTO.getPerId());
//		comTaskFeedback.setFeedbackDates(new Date());
//		comTaskFeedback.setDutyState(DictConst.DUTYSTATE_LG);
//		int status1 = comTaskFeedbackMapper.insert(comTaskFeedback);
//		if (status1 <= 0) {
//			throw new BusinessException(Result.ERROR, "任务考勤下班打卡失败，请稍后重试");
//		}
		// 修改任务执勤下班打卡状态
		int status2 = comTaskImplementMapper.saveTaskOut(comTaskImplement);
		if (status2 <= 0) {
			throw new BusinessException(Result.ERROR, "任务考勤下班打卡失败，请稍后重试");
		}
		/*** 同步百保盾 ***/

//		ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
//		threadPool.execute(new Runnable() {
//			@Override
//			public void run() {
		bbdTestService.bbdSyncPerTaskCardRecord(appPerTaskCardRecordDTO);
//			}
//		});
		/* 早退通知 */
		if (DictConst.ATTENDSTATUS_ZT.equals(comTaskImplement.getOffAttendStatus())) {
			notifyExceptionSign(comTaskImplement, DictConst.ATTENDSTATUS_ZT);
		}

		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * APP-任务考勤打卡记录-下班（查询状态）
	 *
	 * @param appPerTaskCardRecordDTO
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/23
	 */
	@Override
	public Result selectTaskSignOut(AppPerTaskCardRecordDTO appPerTaskCardRecordDTO) throws BusinessException {

		Date date = new Date();

		// 查询任务执行情况信息
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(appPerTaskCardRecordDTO.getTaskImplementId());

		if(comTaskImplement == null){
			throw new BusinessException(Result.ERROR, "打卡失败，请重试");
		}

		// 查询班次信息
		ComShift comShift = comShiftMapper.getByPrimaryKey(comTaskImplement.getShiftId());

		// 查询班次规则信息
		ComShiftRule comShiftRule = comShiftRuleMapper.getByPrimaryKey(comTaskImplement.getShiftRuleId());

		// 规定的下班打卡时间
		Date workTimeEnd = DateUtils.parseDate(DateUtils.formatDate(comTaskImplement.getDates()) + " "
				+ DateUtils.formatDate(comShiftRule.getEndWorkTime(), "HH:mm:ss"));
		// 对象赋值
		appPerTaskCardRecordDTO.setComId(comTaskImplement.getComId());
		appPerTaskCardRecordDTO.setClockInRound(comShiftRule.getCommutRound());
		appPerTaskCardRecordDTO.setShiftId(comTaskImplement.getShiftId());
		appPerTaskCardRecordDTO.setShiftRuleId(comTaskImplement.getShiftRuleId());
		appPerTaskCardRecordDTO.setPerId(comTaskImplement.getPerId());
		appPerTaskCardRecordDTO.setComTaskId(comTaskImplement.getComTaskId());
		// 次日打卡
		if (CommonConst.Y.equals(comShiftRule.getIsEndNextDay())) {
			// 规定的明天下班打卡时间
			Date workEndTimeTomorrow = DateUtils.parseDate(DateUtils.getDayAfterSomeDay(comTaskImplement.getDates(), 1)
					+ " " + DateUtils.formatDate(comShiftRule.getEndWorkTime(), "HH:mm:ss"));
			// 打卡时限开关
			if (CommonConst.Y.equals(comShift.getClockLimitSwitch())) {
				// 下班打卡时间上限
				Date clockWorkLimit = DateUtils.getDayAfterSomeMinute(workEndTimeTomorrow,
						comShift.getClockWorkLimit());
				if (date.getTime() > clockWorkLimit.getTime()) {
					throw new BusinessException(Result.ERROR, "超过规定下班打卡时间，打卡失败");
				} else if (date.getTime() > workEndTimeTomorrow.getTime()
						&& date.getTime() < clockWorkLimit.getTime()) {
					// 正常下班
					return Result.success("正常", DictConst.ATTENDSTATUS_ZC);
				} else {
					// 早退
					return Result.success("早退", DictConst.ATTENDSTATUS_ZT);
				}
			} else {
				if (date.getTime() < workEndTimeTomorrow.getTime()) {
					return Result.success("早退", DictConst.ATTENDSTATUS_ZT);
				} else {
					return Result.success("正常", DictConst.ATTENDSTATUS_ZC);
				}
			}
		} else {
			// 今日下班打卡
			// 打卡时限开关(打开)
			if (CommonConst.Y.equals(comShift.getClockLimitSwitch())) {
				// 下班打卡时间上限
				Date clockWorkLimit = DateUtils.getDayAfterSomeMinute(workTimeEnd, comShift.getClockWorkLimit());
				if (date.getTime() > clockWorkLimit.getTime()) {
					throw new BusinessException(Result.ERROR, "超过规定下班打卡时间，打卡失败");
				} else if (date.getTime() > workTimeEnd.getTime() && date.getTime() < clockWorkLimit.getTime()) {
					// 正常下班
					return Result.success("正常", DictConst.ATTENDSTATUS_ZC);
				} else {
					// 早退
					return Result.success("早退", DictConst.ATTENDSTATUS_ZT);
				}
			} else {
				// 打卡时限开关(关闭)
				if (date.getTime() < workTimeEnd.getTime()) {
					return Result.success("早退", DictConst.ATTENDSTATUS_ZT);
				} else {
					return Result.success("正常", DictConst.ATTENDSTATUS_ZC);
				}
			}
		}
	}

	/**
	 * 通知负责人异常打卡
	 */
	private void notifyExceptionSign(ComTaskImplement comTaskImplement, String attendStatus) {
		/* 迟到 */
		if (DictConst.ATTENDSTATUS_CD.equals(attendStatus)) {
			ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskImplement.getComTaskId());
			/* 通知管理员，负责人 */
			List<Map> chargeList = comTaskMapper.listTaskChargePerDetail(comTaskImplement.getComTaskId());
			StringBuilder taskPers = new StringBuilder();
			for (Map map : chargeList) {
				taskPers.append(map.get("perId").toString()).append(CommonConst.COMMA);
			}
			String content2 = MsgConst.TYPE_020115_TASK_SIGN_LATER_CONTENT;
			String perName = perBaseInfoMapper.getNameById(comTaskImplement.getPerId());
			content2 = content2.replace("{taskName}", comTask.getTaskName()).replace("{operate}", perName)
					.replace("{time}", DateUtil.now());
			commonService.sendMessageToApp(MsgConst.TYPE_020115_TASK_SIGN_LATER_TITLE, content2,
					DictMessageTypeConst.MESSAGETYPE_020115, taskPers.toString(), comTask.getComId(),
					comTask.getComTaskId());
		}
		/* 早退 */
		else if (DictConst.ATTENDSTATUS_ZT.equals(attendStatus)) {
			ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskImplement.getComTaskId());
			/* 通知管理员，负责人 */
			List<Map> chargeList = comTaskMapper.listTaskChargePerDetail(comTask.getComTaskId());
			StringBuilder taskPers = new StringBuilder();
			for (Map map : chargeList) {
				taskPers.append(map.get("perId").toString()).append(CommonConst.COMMA);
			}
			String content2 = MsgConst.TYPE_020116_TASK_SIGN_EARLY_CONTENT;
			String perName = perBaseInfoMapper.getNameById(comTaskImplement.getPerId());
			content2 = content2.replace("{taskName}", comTask.getTaskName()).replace("{operate}", perName)
					.replace("{time}", DateUtil.now());
			commonService.sendMessageToApp(MsgConst.TYPE_020116_TASK_SIGN_EARLY_TITLE, content2,
					DictMessageTypeConst.MESSAGETYPE_020116, taskPers.toString(), comTask.getComId(),
					comTask.getComTaskId());
		}
	}
}