package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.entity.task.ComTaskShift;
import com.bcxin.oa.old.dto.ComTaskShiftDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

/**
 * 任务班次范围（排班）
 *
 * @author zhangye
 * @since 2018-02-26 10:04:47
 */
public interface ComTaskShiftService {


    /**
     * 获取未排班班次列表
     *
     * @param comTaskShift
     * @author llc
     * @date 2020-05-06
     */
    Result getNoSchedulShiftList(ComTaskShift comTaskShift) throws BusinessException;


    /**
     * 删除驻勤班次关联
     *
     * @param dto
     * @author llc
     * @date 2020-05-06
     */
    Result deleteTaskShift(ComTaskShiftDto dto) throws BusinessException;


    /**
     * 获取未设置班次列表
     *
     * @param comTaskShift
     * @author llc
     * @date 2020-05-09
     */
    Result getNoSetShiftList(ComTaskShift comTaskShift) throws BusinessException;


    /**
     * 新增驻勤班次关联
     * @param dto
     * @author llc
     * @date 2020-05-09
     * @return
     * @throws BusinessException
     */
    Result addTaskShift(ComTaskShiftDto dto) throws BusinessException;

}