package com.bcxin.oa.old.service.system;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.ExcelUtil;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.entity.system.PerBaseInfo;
import com.bcxin.oa.old.entity.system.PerCurrentLocation;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.mapper.system.ConfigDictMapper;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 人员基础信息
 *
 * @author zhangye
 * @since 2017-12-25 17:11:16
 */
@Service
@Transactional
public class PerBaseInfoServiceImpl implements PerBaseInfoService {
    private static Logger logger = LoggerFactory.getLogger(PerBaseInfoServiceImpl.class);
    @Resource
    public CacheService cacheService;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private ComDepartMapper comDepartMapper;
    @Resource
    private ConfigDictMapper configDictMapper;
    @Resource
    private BbdTestService bbdTestService;
    @Resource
    private CommonService commonService;
    @Resource
    private PerCurrentLocationMapper perCurrentLocationMapper;
    @Resource
    private PerOrgRelationService perOrgRelationService;
    @Resource
    private IdWorker idWorker;

    /**
     * @Author: wangcy
     * @Description:查看用户基础信息
     * @Date: 2017/12/27 0027 19:10
     */
    @Override
    public Result getSimplePerBaseInfo(Long perId) {
        if (perId == null) {
            return Result.fail("perId不能为空！");
        }
        PerBaseInfoDto perBaseInfoDto = perBaseInfoMapper.getSimplePerBaseInfoById(perId);
        return Result.success(Result.SUCCESS_QUERY_MSG, perBaseInfoDto);
    }

    /**
     *获取用户定位信息
     * @param perId
     * @return
     */
    @Override
    public Result getPerLocation(Long perId) {
        if (perId == null) {
            return Result.fail("perId不能为空！");
        }
        PerCurrentLocation location = perCurrentLocationMapper.getLocationByPerId(perId);
        return Result.success(Result.SUCCESS_QUERY_MSG, location);
    }

    /**
     *获取用户入职信息
     * @param perId
     * @return
     */
    @Override
    public Result getPerWork(Long perId) {
        if (perId == null) {
            return Result.fail("perId不能为空！");
        }
        PerBaseInfo perBaseInfo = new PerBaseInfo();
        perBaseInfo.setPerId(perId);
        List<PerOrgRelationInfoDto> workList = perOrgRelationMapper.findAllJob(perBaseInfo);
        return Result.success(Result.SUCCESS_QUERY_MSG, workList);
    }

    /**
     * @Description:查看用户基础信息
     */
    @Override
    public Result getSimplePerBaseInfo(String idCardNo) {
        if (StringUtil.isEmpty(idCardNo)) {
            return Result.fail("idCardNo不能为空！");
        }
        PerBaseInfoDto perBaseInfoDto = perBaseInfoMapper.getSimplePerBaseInfoByIdCardNo(idCardNo);
        return Result.success(Result.SUCCESS_QUERY_MSG, perBaseInfoDto);
    }

    /**
     * 获取部门信息
     *
     * @param paranMap
     * @return
     */
    @Override
    public Result getPerDepartInfoByIdList(Map<String, Object> paranMap) {
        List<?> perIdList = Convert.toList(paranMap.get("perIdList"));
        if (CollectionUtil.isEmpty(perIdList)) {
            return Result.fail("perId不能为空！");
        }
        List<Map> perDepartInfoList = perBaseInfoMapper.getPerDepartInfoByIdList(paranMap);
        return Result.success(Result.SUCCESS_QUERY_MSG, perDepartInfoList);
    }

    /**
     * @Author: wangcy
     * @Description:查看用户基础信息
     * @Date: 2017/12/27 0027 19:10
     */
    @Override
    public Result getPerBaseInfo(Long perId) {
        if (perId == null) {
            return Result.fail("perId不能为空！");
        }
        PerBaseInfoDto perBaseInfoDto = perBaseInfoMapper.getPerBaseInfoById(perId);
        if (perBaseInfoDto.getComId() != null && perBaseInfoDto.getComId().toString() != "") {
            if (perBaseInfoDto.getComId().equals(perBaseInfoDto.getOrgId())) {
                perBaseInfoDto.setOrgId(-1L);
            }
        }
        List<Map> list = perBaseInfoMapper.getRoleById(perId);
        String roleName = "";
        String roleId = "";
        String roleType = "";
        String roleGroupId = "";

        if (list != null && list.size() > 0) {
            for (Map item : list) {
                roleName += item.get("roleName") + ",";
                roleId += item.get("roleId") + ",";
                roleType += item.get("roleType") + ",";
                roleGroupId += item.get("roleGroupId") + ",";
            }
            roleName = roleName.substring(0, roleName.length() - 1);
            roleId = roleId.substring(0, roleId.length() - 1);
            roleType = roleType.substring(0, roleType.length() - 1);
            roleGroupId = roleGroupId.substring(0, roleGroupId.length() - 1);
            perBaseInfoDto.setRoleName(roleName);
            perBaseInfoDto.setRoleId(roleId);
            perBaseInfoDto.setRoleType(roleType);
            perBaseInfoDto.setRoleGroupId(roleGroupId);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, perBaseInfoDto);
    }

    /**
     * 查看人员入职信息
     *
     * @author luopeng
     * @date 2021-07-30
     */
    @Override
    public Result getPerWorkInfo(PerBaseInfo perBaseInfo) {
        if (perBaseInfo.getPerId() == null) {
            return Result.fail("人员ID不能为空！");
        }
        PageHelper.startPage(perBaseInfo.getPageNumber(), perBaseInfo.getPageSize());
        List<PerOrgRelationInfoDto> perList = perOrgRelationMapper.findAllJob(perBaseInfo);
        PageInfoUtils pageInfo = new PageInfoUtils(perList);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 通过人员ID列表查询人员基础信息
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-04-15
     */
    @Override
    public Result getPerBaseInfoListByPerIds(PerBaseInfoDto dto) {
        if (StringUtil.isEmpty(dto.getPerIds())) {
            return Result.fail("人员ID不能为空！");
        }
        List<String> perIdList = StrSplitter.split(dto.getPerIds(), CommonConst.COMMA, true, true);
        List<Map<String, String>> perList = perOrgRelationMapper.getPerBaseInfoListByPerIds(dto.getComId(), perIdList);
        return Result.success(Result.SUCCESS_QUERY_MSG, perList);
    }


    /**
     * 通过人员ID查询人员基础信息
     *
     * @param perId
     * @return
     * @author llc
     * @date 2020-05-21
     */
    @Override
    public Result getPerBaseInfoByPerId(Long perId) {
        PerBaseInfo perBaseInfo = new PerBaseInfo();
        perBaseInfo.setPerId(perId);
        perBaseInfo = perBaseInfoMapper.getById(perBaseInfo);
        return Result.success(Result.SUCCESS_QUERY_MSG, perBaseInfo);
    }


    @Override
    public Result getPerAllInfo(Long perId) {
        if (perId == null) {
            return Result.fail("perId不能为空！");
        }
        PerBaseInfoDto perBaseInfoDto = perBaseInfoMapper.getPerBaseInfoById(perId);
        if (perBaseInfoDto.getComId() != null && perBaseInfoDto.getComId().toString() != "") {
            if (perBaseInfoDto.getComId().equals(perBaseInfoDto.getOrgId())) {
                perBaseInfoDto.setOrgId(-1L);
            }
        }

        /*** 户口地址 ***/
        Integer regionId = perBaseInfoDto.getResidentArea() == null ? (perBaseInfoDto.getResidentCity() == null ? perBaseInfoDto.getResidentProvince() : perBaseInfoDto.getResidentCity()) : perBaseInfoDto.getResidentArea();

        if (regionId != null) {
            String regionInfo = cacheService.getSysRegion(String.valueOf(regionId)); // redis获取区域信息
            Map<String, Object> m = JSON.parseObject(regionInfo);
            perBaseInfoDto.setResidenceAreaName(m != null ? m.get("regionFullName").toString() : null);
        }

        /*** 居住地址 ***/
        regionId = perBaseInfoDto.getDomicileArea() == null ? (perBaseInfoDto.getDomicileCity() == null ? perBaseInfoDto.getDomicileProvince() : perBaseInfoDto.getDomicileCity()) : perBaseInfoDto.getDomicileArea();
        if (regionId != null) {
            String regionInfo = cacheService.getSysRegion(String.valueOf(regionId)); // redis获取区域信息
            Map<String, Object> m = JSON.parseObject(regionInfo);
            perBaseInfoDto.setDomicileAreaName(m != null ? m.get("regionFullName").toString() : null);
        }

        return Result.success(Result.SUCCESS_QUERY_MSG, perBaseInfoDto);
    }

    @Override
    public Result pageForLeavePer(PerOrgRelationDto perOrgRelationDto) {
        PageHelper.startPage(perOrgRelationDto.getPageNumber(), perOrgRelationDto.getPageSize());
        List<Map> list = perOrgRelationMapper.pageLeavePer(perOrgRelationDto);

        // 查询公司名
        String comName = comBaseInfoMapper.findComName(perOrgRelationDto.getComId());

        // 对直接隶属于公司的员工进行赋值公司名
        list.stream()
                .filter((Map map) -> ((map.get("departName")) == "" || (map.get("departName")) == null)
                        && (map.get("departId") == "" || map.get("departId") == null))
                .forEach((Map m) -> m.put("departName", comName));
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 人员信息分页查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-05-17
     */

    @Override
    public Result pageForPerInfo(PerInfoQueryDto dto) {
        if (dto.getPageNumber() == null) {
            throw new BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            throw new BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        /*** 获取人员的通讯录数据权限涉及部门 ***/
        Map<String, Object> map = perOrgRelationService.getDataAuthOrgList(dto.getComId(), dto.getPerId());
        String dataAuthType = map.get("dataAuthType").toString();
        ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");

        /*** 如果人员的权限不是全公司且数据权限涉及部门为空 ***/
        if (!ObjectUtil.equal(dataAuthType, DictConst.DATAAUTHTYPE_QGS) && orgIdList.size() == 0) {
            return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(new ArrayList()));
        }
        dto.setDataAuthType(dataAuthType);
        dto.setOrgIdList(orgIdList);

        /*** 多部门选择 ***/
        if (StringUtils.isNotEmpty(dto.getDepartIds())) {
            /*** 因为选择企业传的是-1，需要替换成企业ID ***/
            dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
            List<String> departIdStrList = StrSplitter.split(dto.getDepartIds(), CommonConst.COMMA, true, true);
            List<Long> departIdList = new ArrayList<>();
            for (String departIdStr : departIdStrList) {
                departIdList.add(Long.parseLong(departIdStr));
            }
            dto.setDepartIdList(departIdList);
        }
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<LinkedHashMap<String, Object>> list = perBaseInfoMapper.pageForPerInfo(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 导出保安人员信息
     *
     * @param dto
     * @author llc
     * @date 2019-06-03
     */
    @Override
    public Result exportSecurityStaffInfo(PerInfoQueryDto dto, HttpServletResponse response)
            throws BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "_" + "保安人员" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("保安人员");


            List<LinkedHashMap<String, Object>> list = new ArrayList<>();
            /*** 获取人员的通讯录数据权限涉及部门 ***/
            Map<String, Object> map = perOrgRelationService.getDataAuthOrgList(dto.getComId(), dto.getPerId());
            String dataAuthType = map.get("dataAuthType").toString();
            ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");

            /*** 如果人员的权限不是全公司且数据权限涉及部门为空 ***/
            if (!ObjectUtil.equal(dataAuthType, DictConst.DATAAUTHTYPE_QGS) && orgIdList.size() == 0) {

                /*** 直接不处理返回空表格 ***/
            } else {
                dto.setDataAuthType(dataAuthType);
                dto.setOrgIdList(orgIdList);

                /*** 多部门选择 ***/
                if (StringUtils.isNotEmpty(dto.getDepartIds())) {
                    /*** 因为选择企业传的是-1，需要替换成企业ID ***/
                    dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
                    List<String> departIdStrList = StrSplitter.split(dto.getDepartIds(), CommonConst.COMMA, true, true);
                    List<Long> departIdList = new ArrayList<>();
                    for (String departIdStr : departIdStrList) {
                        departIdList.add(Long.parseLong(departIdStr));
                    }
                    dto.setDepartIdList(departIdList);
                }
                list = perBaseInfoMapper.pageForPerInfo(dto);
            }

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);// 水平居中
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /*** 填充第一行数据 ***/
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = {"序号", "姓名", "身份证号", "手机号", "部门", "人员类别", "入职日期", "APP激活状态", "认证状态", "认证失败原因", "申诉状态", "出生日期", "年龄", "性别", "国籍", "学历", "民族", "政治面貌", "户籍地址", "居住详细地址",
                    "是否退伍军人", "投保状态", "保单号", "保安员资格证", "保安等级", "保安等级证编号", "企业录入时间", "联系人信息", "驾照等级"};
            int column;
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 2) {
                    column = 5000;
                } else if (i == 4 || i == 9 || i == 18 || i == 19 || i == 27) {
                    column = 10000;
                } else {
                    column = 4000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            /*** 填充第一行数据 ***/
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第一行的每个单元格
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(titleStyle);
            }

            /*** 字体颜色样式 ***/
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
            HSSFRow row = null;
            int rowIndex = 1;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(rowIndex);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("name") != null ? result.get("name").toString() : null); // 姓名
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("idCardNo") != null ? result.get("idCardNo").toString() : null); // 身份证
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("mobilePhone") != null ? result.get("mobilePhone").toString() : null); // 手机号
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("departName") != null ? result.get("departName").toString() : null); // 部门名称
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("perType") != null ? result.get("perType").toString() : null); // 人员类型
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("entryDate") != null ? result.get("entryDate").toString() : null); // 	入职日期
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("isAppActive") != null ? result.get("isAppActive").toString() : null); // app激活状态
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("authStatus") != null ? result.get("authStatus").toString() : null); // 认证状态
                if (ObjectUtil.equal(result.get("authStatus"), "已认证")) {
                    cell8.setCellStyle(greenStyle);
                } else {
                    cell8.setCellStyle(redStyle);
                }
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("authResult") != null ? result.get("authResult").toString() : null); // 认证结果
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("sszt") != null ? result.get("sszt").toString() : null); // 申诉状态
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("birthday") != null ? result.get("birthday").toString() : null); // 出生日期
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("age") != null ? result.get("age").toString() : null);// 年龄
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("sex") != null ? result.get("sex").toString() : null);// 性别
                HSSFCell cell14 = row.createCell(14);
                cell14.setCellValue(result.get("nationality") != null ? result.get("nationality").toString() : null);// 国籍
                HSSFCell cell15 = row.createCell(15);
                cell15.setCellValue(result.get("education") != null ? result.get("education").toString() : null);// 学历
                HSSFCell cell16 = row.createCell(16);
                cell16.setCellValue(result.get("nation") != null ? result.get("nation").toString() : null);// 民族
                HSSFCell cell17 = row.createCell(17);
                cell17.setCellValue(result.get("politicalStatus") != null ? result.get("politicalStatus").toString() : null);// 政治面貌
                HSSFCell cell18 = row.createCell(18);
                cell18.setCellValue(result.get("residenceAddress") != null ? result.get("residenceAddress").toString() : null);// 户口详细地址
                HSSFCell cell19 = row.createCell(19);
                cell19.setCellValue(result.get("domicileAddress") != null ? result.get("domicileAddress").toString() : null);// 居住详细地址
                HSSFCell cell20 = row.createCell(20);
                cell20.setCellValue(result.get("isVeteran") != null ? result.get("isVeteran").toString() : null);// 是否退伍军人
                HSSFCell cell21 = row.createCell(21);
                cell21.setCellValue(result.get("tbzt") != null ? result.get("tbzt").toString() : null);// 投保状态
                HSSFCell cell22 = row.createCell(22);
                cell22.setCellValue(result.get("policyNos") != null ? result.get("policyNos").toString() : null);// 保单号
                HSSFCell cell23 = row.createCell(23);
                cell23.setCellValue(result.get("bayzgzh") != null ? result.get("bayzgzh").toString() : null);// 保安员资格证
                HSSFCell cell24 = row.createCell(24);
                cell24.setCellValue(result.get("badj") != null ? result.get("badj").toString() : null);// 保安等级
                HSSFCell cell25 = row.createCell(25);
                cell25.setCellValue(result.get("badjzbh") != null ? result.get("badjzbh").toString() : null);// 保安等级证编号
                HSSFCell cell26 = row.createCell(26);
                cell26.setCellValue(result.get("comCreateTime") != null ? result.get("comCreateTime").toString() : null);// 企业录入时间
                HSSFCell cell27 = row.createCell(27);
                if (result.get("contactper") != null && result.get("contactPhone") != null) {
                    cell27.setCellValue(result.get("contactper").toString() + "(" + result.get("contactPhone").toString() + ")");// 联系人信息
                } else if (result.get("contactper") != null && result.get("contactPhone") == null) {
                    cell27.setCellValue(result.get("contactper").toString());// 联系人信息
                } else if (result.get("contactper") == null && result.get("contactPhone") != null) {
                    cell27.setCellValue("(" + result.get("contactPhone").toString() + ")");// 联系人信息
                }
                HSSFCell cell28 = row.createCell(28);
                cell28.setCellValue(result.get("drivingLicenseLevel") != null ? result.get("drivingLicenseLevel").toString() : null);// 驾照等级
                rowIndex++;
            }
            wb.write(os);
            os.close();
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, e.getMessage());
        } finally {
            try {
                os.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出保安人员文件失败");
    }

    /**
     * 保安人员驻勤点信息分页查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-04-22
     */

    @Override
    public Result pagePerTaskInfo(PerTaskInfoDto dto) {
        if (dto.getPageNumber() == null) {
            throw new BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            throw new BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        /*** 多部门选择 ***/
        if (StringUtils.isNotEmpty(dto.getDepartIds())) {
            /*** 因为选择企业传的是-1，需要替换成企业ID ***/
            dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
            List<String> departIdStrList = StrSplitter.split(dto.getDepartIds(), CommonConst.COMMA, true, true);
            List<Long> departIdList = new ArrayList<>();
            for (String departIdStr : departIdStrList) {
                departIdList.add(Long.parseLong(departIdStr));
            }
            dto.setDepartIdList(departIdList);
        }
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<LinkedHashMap<String, String>> list = perBaseInfoMapper.pagePerTaskInfo(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(list));
    }

    /**
     * 导出人员驻勤点信息
     *
     * @param dto
     * @author llc
     * @date 2020-04-23
     */
    @Override
    public Result exportPerTaskInfo(PerTaskInfoDto dto, HttpServletResponse response)
            throws BusinessException {
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "_" + "保安人员" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("保安人员");

            /*** 多部门选择 ***/
            if (StringUtils.isNotEmpty(dto.getDepartIds())) {
                /*** 因为选择企业传的是-1，需要替换成企业ID ***/
                dto.getDepartIds().replaceAll("-1", dto.getComId().toString());
                List<String> departIdStrList = StrSplitter.split(dto.getDepartIds(), CommonConst.COMMA, true, true);
                List<Long> departIdList = new ArrayList<>();
                for (String departIdStr : departIdStrList) {
                    departIdList.add(Long.parseLong(departIdStr));
                }
                dto.setDepartIdList(departIdList);
            }
            List<LinkedHashMap<String, String>> list = perBaseInfoMapper.pagePerTaskInfo(dto);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);// 水平居中
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /*** 填充第一行数据 ***/
            HSSFRow rowFirst = sheet1.createRow(0);
            String[] firstArr = {"序号", "姓名", "身份证号", "手机号", "部门", "人员类别", "驻勤点", "驻勤点状态", "是否排班", "驻勤点类型", "服务企业名称"};
            int column;
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 2) {
                    column = 5000;
                } else if (i == 4 || i == 6 || i == 10) {
                    column = 10000;
                } else {
                    column = 4000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            /*** 填充第一行数据 ***/
            for (int i = 0; i < firstArr.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第一行的每个单元格
                cell.setCellValue(firstArr[i]);
                cell.setCellStyle(titleStyle);
            }

            /*** 字体颜色样式 ***/
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
            HSSFRow row = null;
            int rowIndex = 1;
            for (Map<String, String> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(rowIndex);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("name") != null ? result.get("name") : null); // 姓名
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("idCardNo") != null ? result.get("idCardNo") : null); // 身份证
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("mobilePhone") != null ? result.get("mobilePhone") : null); // 手机号
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("departName") != null ? result.get("departName") : null); // 部门名称
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("perType") != null ? result.get("perType") : null); // 人员类型
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("taskName") != null ? result.get("taskName") : null); // 驻勤点
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("taskEffect") != null ? result.get("taskEffect") : null); // 驻勤点状态
                if (ObjectUtil.equal(result.get("taskEffect"), "生效")) {
                    cell7.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal(result.get("taskEffect"), "终止")) {
                    cell7.setCellStyle(redStyle);
                }
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("isSchedul") != null ? result.get("isSchedul") : null); // 是否排班
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("taskStationType") != null ? result.get("taskStationType") : null); // 驻勤点类型
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("serviceObject") != null ? result.get("serviceObject") : null);// 服务状态
                rowIndex++;
            }
            wb.write(os);
            os.close();
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, e.getMessage());
        } finally {
            try {
                os.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出保安人员文件失败");
    }


    @Override
    public Result batchCheckPerson(List<String> list) {
        List<PerLearnTimeDto> peramList = Lists.newArrayList();
        for (String item : list) {
            PerLearnTimeDto person = new PerLearnTimeDto();
            person.setIdCardNo(item);
            peramList.add(person);
        }
        List<Map<String, String>> idCardNoList = perBaseInfoMapper.getPerInfoByIdCardNoList(peramList);
        return Result.success("", idCardNoList);
    }
}