package com.bcxin.oa.old.service.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.PublicConst;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.utils.HttpUtils;
import com.bcxin.oa.old.entity.system.ConfigDict;
import com.bcxin.oa.old.entity.task.ConfigIndustryDict;
import com.bcxin.oa.old.mapper.ComShiftMapper;
import com.bcxin.oa.old.mapper.ComShiftRuleMapper;
import com.bcxin.oa.old.mapper.system.CacheMapper;
import com.bcxin.oa.old.mapper.system.ConfigDictMapper;
import com.bcxin.oa.old.entity.task.ComShift;
import com.bcxin.oa.old.entity.task.ComShiftRule;

import com.bcxin.oa.old.mapper.system.ConfigIndustryDictMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 公用查询方法
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
@Service
@Transactional
public class CommonServiceImpl implements CommonService {
	private static Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
	@Resource
	private ComShiftRuleMapper comShiftRuleMapper;

	@Resource
	private ComShiftMapper comShiftMapper;

	@Resource
	private CacheMapper cacheMapper;

	@Autowired
	private StringRedisTemplate stringRedisTemplate;

	@Resource
	private ConfigDictMapper configDictMapper;

	@Resource
	private ConfigIndustryDictMapper configIndustryDictMapper;




	/**
	 * 得到库表的配置信息
	 *
	 * @param key
	 * @return value
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 15:46
	 */
	@Override
	public String getSystemConfig(String key) { // hash
		// api地址
		// https://docs.spring.io/spring-data/redis/docs/current/api/org/springframework/data/redis/core/RedisTemplate.html
		String redisKey = PublicConst.REDIS_HEAD + "SystemConfig";
		Map<String, Object> cacheMap = Maps.newHashMap();
		Object value = null;
		if (!stringRedisTemplate.hasKey(redisKey)) {
			// 查询数据库配置表，存为一个map，放入缓存，设置超时30分钟
			List<Map<String, Object>> list = cacheMapper.getSystemConfig();
			for (Map<String, Object> m : list) {
				cacheMap.put(String.valueOf(m.get("sysKey")), String.valueOf(m.get("sysValue")));
			}
			stringRedisTemplate.opsForHash().putAll(redisKey, cacheMap);
            stringRedisTemplate.expire(redisKey,PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS,TimeUnit.MILLISECONDS);
			value = cacheMap.get(key);
		} else {
			value = stringRedisTemplate.opsForHash().get(redisKey, key);
		}
		return String.valueOf(value);
	}

	/**
	 * 返回银行编码表（key）
	 * 由于redisKey对应的value存在变动手动删除不方便
	 *
	 * @author lp
	 * @date 2019-09-06
	 */
	@Override
	public String getConfigBank(String key) {
		String redisKey = PublicConst.REDIS_HEAD + "BankConfigMap";
		//未查找到缓存
		if (!stringRedisTemplate.hasKey(redisKey)) {
			List<Map> list = configDictMapper.getConfigBankList();
			Map<String,String> bankMap = Maps.newHashMap();
			for (Map map : list) {
				bankMap.put(map.get("bankCode").toString(),map.get("bankName").toString());
			}
			stringRedisTemplate.opsForHash().putAll(redisKey, bankMap);
			stringRedisTemplate.expire(redisKey,PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS,TimeUnit.MILLISECONDS);
			return bankMap.get(key);
		} else {
			Object value = stringRedisTemplate.opsForHash().get(redisKey, key);
			return value == null?"":value.toString();
		}
	}


	/**
	 * 发送消息（调用罗总发送消息方法）
	 *
	 * @param tilte
	 *            标题
	 * @param content
	 *            内容
	 * @param messageType
	 *            消息类型
	 * @param ids
	 *            接收人id，多个用,隔开
	 * @apiNote 作者 zhongjianhui
	 * @since 创建于 2018年4月23日 10:00:36
	 */
	@Override
	public void sendMessageToApp(String tilte, String content, String messageType, String ids, Long comId, Long id) {
		new Thread(() -> {
			try {
				Map params = Maps.newHashMap();
				params.put("title", tilte);
				params.put("content", content);
				params.put("messageType", messageType);
				params.put("comId", comId);
				params.put("comTaskId", id);
				params.put("objectId", id);
				// 接收人id，多个用,隔开
				params.put("ids", ids);
				// SAAS平台标识
				params.put("platId", "10");
				// 发送方式（1：sms ，2：email ， 3：app）
				params.put("way", "3");
				String result = HttpUtils
						.doPost(this.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/public/message/send-message", params);
				System.out.println(result);
			} catch (Exception e) {
				logger.error(e.getMessage());
			}
		}).start();
	}


	@Override
	public String listChangeToString(Long shiftId, boolean containShiftName, boolean redNextDay) {
		// containShiftName == true 返回的字符串： 班次A: 09:00-18:00
		// containShiftName == false 返回的字符串： 09:00-18:00
		if (shiftId == null) {
			return "";
		}
		String shiftRuleTime = "";// 用来最后返回班次时间
		if (containShiftName) {
			ComShift comShift = comShiftMapper.getByPrimaryKey(shiftId);

			if (comShift != null) {
				shiftRuleTime = comShift.getShiftName() + ":";
			}
		}
		// 查询班次规则
		List<ComShiftRule> shiftRuleDtoList = comShiftRuleMapper.getShiftRuleByShiftId(shiftId);
		if (shiftRuleDtoList != null && shiftRuleDtoList.size() > 0) {
			for (ComShiftRule comShiftRule : shiftRuleDtoList) {
				SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
				// 将时间转化成字符串
				String startWorkTime = sdf.format(comShiftRule.getStartWorkTime());
				String endWorkTime = sdf.format(comShiftRule.getEndWorkTime());
				if (startWorkTime != null || endWorkTime != null) {
					if (comShiftRule.getIsStartNextDay().equals(CommonConst.Y)) {
						if (redNextDay) {
							startWorkTime = "<span style=\"color:#F5222E\">次日<span>" + startWorkTime;
						} else {
							startWorkTime = "次日" + startWorkTime;
						}
					}
					if (comShiftRule.getIsEndNextDay().equals(CommonConst.Y)) {
						if (redNextDay) {
							endWorkTime = "<span style=\"color:#F5222E\">次日<span>" + endWorkTime;
						} else {
							endWorkTime = "次日" + endWorkTime;
						}
					}
					if (shiftRuleTime != null) {
						shiftRuleTime = shiftRuleTime + startWorkTime + "-" + endWorkTime + " | ";
					} else {
						shiftRuleTime = startWorkTime + "-" + endWorkTime + " | ";
					}
				}
			}
			shiftRuleTime = shiftRuleTime.substring(0, shiftRuleTime.length() - 2);
		}
		return shiftRuleTime;
	}


	/**
	 * 字典查询，从缓存里面拿
	 *
	 * @param codeTypes
	 * @auth llc
	 * @update by llc 2019-06-26
	 */
	@Override
	public Result getConfigDictById(String codeTypes) {
		List<String> strs = StrSplitter.split(codeTypes, CommonConst.COMMA, 0, true, true);
		Map retrunMap = Maps.newHashMap();
		if(strs.size()>0) {
			String redisKey = PublicConst.REDIS_HEAD + "ConfigDictTree";
			Map<String, Object> cacheMap = Maps.newHashMap();
			Object value = null;
			/*** 字典字段都从缓存取 ***/
			if (!stringRedisTemplate.hasKey(redisKey)) {
				/*** 获取代码列表 ***/
				List<Map<String, String>> list = configDictMapper.getConfigDictList();
				// 拼接数组
				Multimap<String, String> multimap = ArrayListMultimap.create();
				for(Map<String, String> map : list){
					multimap.put(map.get("codeType").toString().toUpperCase(),map.get("codeValue").toString()+"||"+map.get("label").toString()) ;
				}
				for(String codeType : multimap.keySet()){
					Collection<String> dictList = multimap.get(codeType.toUpperCase());
					cacheMap.put(codeType.toUpperCase(), JSON.toJSONString(dictList));
				}
				stringRedisTemplate.opsForHash().putAll(redisKey, cacheMap);
				stringRedisTemplate.expire(redisKey,PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS,TimeUnit.MILLISECONDS);
				for (String codeType : strs) {
					value = cacheMap.get(codeType.toUpperCase());
					if(value == null){
						continue;
					}
					List<ConfigDict> configDictList = new ArrayList<>();
					List<String> dictList = JSON.parseArray(value.toString(),String.class);
					for (String str : dictList) {
						ConfigDict configDict = new ConfigDict();
						configDict.setCodeType(codeType);
						configDict.setCodeValue(StrSplitter.split(str, "||", 0, true, true).get(0));
						configDict.setLabel(StrSplitter.split(str, "||", 0, true, true).get(1));
						configDictList.add(configDict);
					}
					retrunMap.put(codeType, configDictList);
				}
			} else {
				for (String codeType : strs) {
					value = stringRedisTemplate.opsForHash().get(redisKey, codeType.toUpperCase());
					if(value == null){
						continue;
					}
					List<ConfigDict> configDictList = new ArrayList<>();
					List<String> dictList = JSON.parseArray(value.toString(),String.class);
					for (String str : dictList) {
						ConfigDict configDict = new ConfigDict();
						configDict.setCodeType(codeType);
						configDict.setCodeValue(StrSplitter.split(str, "||", 0, true, true).get(0));
						configDict.setLabel(StrSplitter.split(str, "||", 0, true, true).get(1));
						configDictList.add(configDict);
					}
					retrunMap.put(codeType, configDictList);
				}
			}
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, retrunMap);
	}

	/**
	 * 行业字典查询，通过企业ID 1.如果账号有关联企业，根据企业信息中行业、机构类别获取 2.如果账号未关联企业，根据页面传的行业、机构值获取
	 *
	 * @param cid
	 * @apiNote 作者 zxf
	 * @since 创建于 2018/09/20 15:18
	 */
	@Override
	public Result getConfigIndustryDictByComId(ConfigIndustryDict cid) {
		if (StringUtils.isNotEmpty(cid.getCodeType())) {
			List<Map> listMap = null;
			if (cid.getComId() != null) {
				listMap = configIndustryDictMapper.getConfigIndustryDictByType(cid.getCodeType(), cid.getComId());
			} else {
				if (StringUtils.isNotEmpty(cid.getIndustryType()) && StringUtils.isNotEmpty(cid.getInstitutionType())) {
					listMap = configIndustryDictMapper.getConfigIndustryDictByThisType(cid.getCodeType(),
							cid.getIndustryType(), cid.getInstitutionType());
				} else {
					return Result.fail("行业、机构不能为空");
				}
			}
			return Result.success(Result.SUCCESS_QUERY_MSG, listMap);
		}
		return Result.fail("从业key不能为空");
	}

	/**
	 * 机构字典查询，通过行业值
	 *
	 * @param industryType 行业
	 * @apiNote 作者 zxf
	 * @since 创建于 2018/09/20 15:18
	 */
	@Override
	public Result getInstitutionTypeByIndustryType(String industryType) {
		if (StringUtils.isNotEmpty(industryType)) {
			List<Map> listMap = configIndustryDictMapper.getInstitutionTypeByIndustryType(industryType);
			return Result.success(Result.SUCCESS_QUERY_MSG, listMap);
		}
		return Result.fail("行业不能为空");
	}

	/**
	 * 返回银行编码表
	 * 由于redisKey对应的value存在变动手动删除不方便
	 *
	 * @author llc
	 * @date 2019-06-24
	 */
	@Override
	public Result getConfigBankList() {
		String redisKey = PublicConst.REDIS_HEAD + "BankConfig";
		List<Map> list;
		if (!stringRedisTemplate.hasKey(redisKey)) { // 第一次加载
			list = configDictMapper.getConfigBankList();
			stringRedisTemplate.opsForValue().set(redisKey, JSON.toJSONString(list), PublicConst.ONE_WEEK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
		} else { // 从缓存读取
			list = JSON.parseArray(stringRedisTemplate.opsForValue().get(redisKey), Map.class);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, list);
	}


	/**
	 * 通过接口删除redisKey方便下次加载
	 * 由于redisKey对应的value存在变动手动删除不方便
	 *
	 * @author llc
	 * @date 2019-05-10
	 */
	@Override
	public Result deleteRedisByKey(String key) {
		String redisKey = PublicConst.REDIS_HEAD + key;
		/*** 如果存在key就删除 ***/
		if (stringRedisTemplate.hasKey(redisKey)) {
			stringRedisTemplate.delete(redisKey);
		}

		return Result.success(Result.SUCCESS_QUERY_MSG);
	}

	/**
	 * 通过接口批量删除redisKey方便下次加载
	 *
	 * @author zxf
	 * @date 2020-05-13
	 */
	@Override
	public Result batchDeleteRedisByKey(String key) {
		String redisKey = PublicConst.REDIS_HEAD + key;
		Set<String> keys = stringRedisTemplate.keys(redisKey+"*");
		stringRedisTemplate.delete(keys);
		return Result.success(Result.SUCCESS_QUERY_MSG);
	}


	/**
	 * 获取系统时间
	 *
	 * @auth llc
	 * @date 2020-08-21
	 * @return
	 * @throws Exception
	 */
	@Override
	public Result getSystemTime() {
		Date date = new Date();
		return Result.success(Result.SUCCESS_QUERY_MSG,date);
	}
}