package com.bcxin.oa.old.mapper.salary;


import com.bcxin.oa.old.entity.salary.PerSalaryGrantDetail;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* 人员薪资发放明细
* @author zhangye
* @since 2019-01-02 16:39:45
*/
public interface PerSalaryGrantDetailMapper extends CrudDao<PerSalaryGrantDetail>{

    List<Map> getAllBySalaryId(@Param("perSalaryGrantId")Long perSalaryGrantId);

    List<Map> getDynamicBySalaryId(@Param("perSalaryGrantId")Long perSalaryGrantId);

    List<Map> getFixBySalaryId(@Param("perSalaryGrantId")Long perSalaryGrantId);

    int updateLine(@Param("perSalaryGrantId")Long perSalaryGrantId,
                   @Param("salaryType")String salaryType,
                   @Param("amount")String amount);

    int updateLineList(@Param("perSalaryGrantId")Long perSalaryGrantId,
                       @Param("list")List<PerSalaryGrantDetail> list);


    /**
     * 删除工资条明细
     * @param perSalaryGrantId
     * @return
     * @author lp
     * @date 2019-04-08
     */
    int deleteByGrantId(@Param("perSalaryGrantId") Long perSalaryGrantId);


    /**
     * 清除员工未确认的工资明细
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-08
     */
    int deletePerNoSureGrantDetail(@Param("comId") Long comId, @Param("grantYears") String grantYears);

    /**
     * 根据人员集合清除员工工资条明细
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-08
     */
    int deleteGrantDetailByPerIdList(@Param("comId") Long comId, @Param("grantYears") String grantYears, @Param("grantIdList")List<Long> grantIdList);


    /**
     * 通过企业薪酬模板选择的项目批量插入到人员薪资发放明细表
     * @param comId
     * @param grantYears
     * @param createBy
     * @return
     * @author llc
     * @date 2019-01-02
     */
    int batchInsertPerSalaryGrantDetail(@Param("comId") Long comId, @Param("grantYears") String grantYears, @Param("createBy") Long createBy);

    /**
     * 通过excel导入的数据批量插入到人员薪资发放明细表
     * @return
     */
    int batchInsertPerSalaryGrantDetailByList(@Param("list") List<PerSalaryGrantDetail> detailList);


    /**
     * 通过医社保记录批量更新医社保、公积金记录
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-02
     */
    int batchUpdatePerSocialIns(@Param("comId") Long comId,@Param("grantYears") String grantYears);


    /**
     * 通过考勤报表批量更新考勤薪资记录
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-03
     */
    int batchUpdatePerAttendSalary(@Param("comId") Long comId,@Param("grantYears") String grantYears);


    /**
     * 更新没有安排考勤的考勤薪资为0
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-03
     */
    int batchUpdateNoAttendPerAttendSalary(@Param("comId") Long comId,@Param("grantYears") String grantYears);


    /**
     * 通过外勤报表批量更新外勤薪资记录
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-25
     */
    int batchUpdatePerTaskSalary(@Param("comId") Long comId,@Param("grantYears") String grantYears);


    /**
     * 更新没有安排外勤的外勤薪资为0
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-25
     */
    int batchUpdateNoTaskPerTaskSalary(@Param("comId") Long comId,@Param("grantYears") String grantYears);


    /**
     * 批量计算个人所得税
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-03
     */
    int batchCalPerTax(@Param("comId") Long comId,@Param("grantYears") String grantYears);


}