package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.dto.PreventCommandDto;
import com.bcxin.oa.old.entity.system.PerCurrentLocation;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface PerCurrentLocationMapper {

    /***
     * 更新人员当前位置
     * @param perCurrentLocation
     * @auth llc
     * @date 2019-09-26
     * @return
     */
    Integer saveOrUpdatePerLocation(PerCurrentLocation perCurrentLocation);


    /***
     * 获取企业人员位置分页列表
     * @param comId
     * @auth llc
     * @date 2019-09-26
     * @return
     */
    List<Map<String,Object>> getComPerLocationPageList(@Param("comId") Long comId);


    /**
     * 通过条件查询企业人员位置列表
     * @date 2019-09-26
     * @auth llc
     * @return
     */
    List<Map<String,Object>> getComPerLocationByKeyWord(PreventCommandDto dto);


    /***
     * 公安获取人员位置分页列表
     * @param dto
     * @auth llc
     * @date 2020-07-03
     * @return
     */
    List<Map<String,Object>> policeGetPerLocationPageList(PreventCommandDto dto);

    /**
     * 公安通过条件查询人员位置列表
     * @param dto
     * @auth llc
     * @date 2020-07-02
     * @return
     */
    List<Map<String,Object>> policeGetPerLocationByKeyword(PreventCommandDto dto);

    /**
     * 获取用户定位信息
     * @param perId
     * @return
     */
    PerCurrentLocation getLocationByPerId(Long perId);
}
