package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.common.CrudDao;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.entity.system.PerBaseInfo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface PerBaseInfoMapper extends CrudDao<PerBaseInfo> {

    String getNameById(@Param("perId") Long perId);

    List<String> selectNameByPrimaryList(@Param("perIdList") Collection<Long> perIdList);

    /**
     * 获取公司用户，包括离职的也算
     * @param comId
     * @return
     */
    List<Map<String,String>> selectNameKeyByComId(@Param("comId")long comId);

    Map selectPerDetail(@Param("perId")long perId, @Param("comId")long comId);

    int insert(PerBaseInfo perBaseInfo);

    PerBaseInfo getById(PerBaseInfo perBaseInfo);

    PerBaseInfo getByTlkUserId(@Param("tlkUserId") String tlkUserId);

    String getMobilePhoneById(Long perId);

    Integer isInsuranceByPerIdAndComId(@Param("perId") Long perId, @Param("comId") Long comId);

    List<Long> isInsuranceByPerIdsAndComId(@Param("list") List<Long> list, @Param("comId") Long comId);

    String getMobilePhoneByUserName(@Param("userName") String userName);

    /**
     * <b> 获取头像 </b>
     * @author ZXF
     * @create 2020/01/09 0009 16:51
     * @version
     * @注意事项 </b>
     */
    String getPhotoUrlById(Long perId);

    List<Map> selectPerBaseInfoByKeword(@Param(value = "keyword") String keyword, @Param(value = "comId") Long comId);

    Integer updateByMapAndSign(Map<String, Object> updateMap);


    /**
     * 获取角色信息
     *
     * @param perId
     * @return
     */
    List<Map> getRoleById(Long perId);


    /**
     * 获取基础信息和入职部门信息
     *
     * @param perId
     * @return
     */
    PerBaseInfoDto getPerBaseInfoById(Long perId);

    PerBaseInfoDto getSimplePerBaseInfoById(@Param("perId") Long perId);

    PerBaseInfoDto getSimplePerBaseInfoByIdCardNo(@Param("idCardNo") String idCardNo);

    List<Map> getPerDepartInfoByIdList(Map<String , Object> paranMap);

    /**
     * 校验用户手机号是否存在
     *
     * @param mobilePhone
     * @return
     */
    Long checkPerExits(String mobilePhone);

    /**
     * 根据身份证查询用户是否在职
     *
     * @param idCardNo
     * @return
     */
    List<Map> isIncumbencyByIdCardNo(String idCardNo);

    /**
     * 更新离职人员状态
     *
     * @param perBaseInfo
     * @return by llc 2018-09-27
     */
    int updateLeaveJobPer(PerBaseInfo perBaseInfo);

    /**
     * 获取人员基础信息
     *
     * @param perId
     * @return by llc 2019-02-26
     */
    PerBaseInfo getPerBaseInfoByPerId(Long perId);


    /**
     * 获取人员的基础信息（目前使用场景:保安员资格证申报）
     *
     * @param perId
     * @return
     * @author llc
     * @date 2019-03-06
     */
    Map<String,Object> getBayBaseInfo(Long perId);



    /**
     * 获取人员的等级证报名信息（目前使用场景:保安员等级申报）
     *
     * @param perId
     * @return
     * @author llc
     * @date 2019-03-06
     */
    Map<String,Object> getBayDjzBaseInfo(Long perId);


    /**
     * 通过手机号查询人员所在组织信息（目前使用场景:陕西关系迁移初始化绑定管理员校验）
     *
     * @param mobilePhone
     * @return
     * @author llc
     * @date 2019-03-06
     */
    Map<String,String> getPerOrgInfoByPhone(String mobilePhone);


    /**
     * 删除人员基础信息（目前使用场景:陕西关系迁移初始化绑定管理员校验）
     *
     * @param perId
     * @return
     * @author llc
     * @date 2019-03-06
     */
    int deleteByPerId(@Param("perId") Long perId);


    /**
     * 校验身份证是否存在 by llc 2019-04-02
     *
     * @param idCardNo
     * @return
     */
    Long checkPerExitsByIdcardNo(String idCardNo);


    /**
     * 校验人员ID是否存在
     *
     * @param perId
     * @author llc
     * @date 2019-04-23
     * @return
     */
    int checkPerExitsById(Long perId);


    /**
     * 返回存在的人员ID列表
     *
     * @param list
     * @author llc
     * @date 2019-11-20
     * @return
     */
    List<Long> checkPerExitsByPerIdList(@Param("list") List<PerBAYDJZDto> list);

    /**
     * <b> 检索未添加管理层的企业和管理员 </b>
     * @author ZXF
     * @create 2019/06/28 0028 14:29
     * @version
     * @注意事项 </b>
     */
    List<Map> unSetManagement();



    /**
     * 人员信息分页查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-05-17
     */
    List<LinkedHashMap<String,Object>> pageForPerInfo(PerInfoQueryDto dto);


    /**
     * 保安人员驻勤点信息分页查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-04-22
     */
    List<LinkedHashMap<String,String>> pagePerTaskInfo(PerTaskInfoDto dto);

    /**
     * <b> 批量认证结果导入临时表 </b>
     * @author ZXF
     * @create 2019/07/26 0026 15:00
     * @version
     * @注意事项 </b>
     */
    int insertTempBatchAuthImport(@Param("list")List<Map<String,String>> list,@Param("importBatchId")Long importBatchId);

    /**
     * <b> 删除重复perId的数据保留sortTime最大那条 </b>
     * @author ZXF
     * @create 2019/07/26 0026 15:42
     * @version
     * @注意事项 </b>
     */
    int deleteRepetitionTempBatchAuthImport(Long importBatchId);

    /**
     * <b> 删除临时表数据 </b>
     * @author ZXF
     * @create 2019/07/26 0026 16:11
     * @version
     * @注意事项 </b>
     */
    int deleteTempBatchAuthImport(Long importBatchId);

    /**
     * <b> 检索校验失败的条目 </b>
     * @author ZXF
     * @create 2019/07/26 0026 16:09
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> findFailTempBatchAuthImport(Long importBatchId);

    /**
     * <b> 检索校验成功的条目 </b>
     * @author ZXF
     * @create 2019/07/26 0026 16:09
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> findSuccessTempBatchAuthImport(Long importBatchId);

    /**
     * <b> 根据每条数据的perId设置对应comId </b>
     * @author ZXF
     * @create 2019/07/26 0026 15:44
     * @version
     * @注意事项 </b>
     */
    int updateComIdTempBatchAuthImport(Long importBatchId);

    /**
     * <b> 校验perId有效性 </b>
     * @author ZXF
     * @create 2019/07/26 0026 15:55
     * @version
     * @注意事项 </b>
     */
    int checkPerIdTempBatchAuthImport(Long importBatchId);


    /**
     * <b> 修改perAccountInfo表认证状态 </b>
     * @author ZXF
     * @create 2019/07/26 0026 17:13
     * @version
     * @注意事项 </b>
     */
    int batchUpdateAppAuthToPerAccountInfo(Long importBatchId);

    /**
     * <b> 修改perBaseInfo表认证状态 </b>
     * @author ZXF
     * @create 2019/07/26 0026 17:13
     * @version
     * @注意事项 </b>
     */
    int batchUpdateAppAuthStatusForConvert(Long importBatchId);
    /**
     * <b> 修改PerAuthRecord表认证状态 </b>
     * @author ZXF
     * @create 2019/07/26 0026 17:13
     * @version
     * @注意事项 </b>
     */
    int batchUpdateAuthStatusToPerAuthRecord(Long importBatchId);


    /**
     * 通过身份证列表获取人员信息
     *
     * @param list
     * @author llc
     * @date 2019-12-05
     * @return
     */
    List<Map<String,String>> getPerInfoByIdCardNoList(@Param("list") List<PerLearnTimeDto> list);


    /**
     * 华为云会议人员信息查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-12-11
     */
    List<LinkedHashMap<String,Object>> pageForhuaweiMeetPerInfo(PerInfoQueryDto dto);


    /**
     * 华为云会议人员信息查询(百保盾)
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-12-19
     */
    List<LinkedHashMap<String,Object>> bbdPageForhuaweiMeetPerInfo(PerInfoQueryDto dto);


    /**
     * 华为云会议人员信息分页(百保盾)
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-12-21
     */
    List<LinkedHashMap<String,Object>> bbdPageHuaweiMeetPerInfo(PerInfoQueryDto dto);


    /**
     * <b> 人员批量认证申诉保存临时表 </b>
     * @author ZXF
     * @create 2020/01/09 0009 14:47
     * @version
     * @注意事项 </b>
     */
    int insertTempBatchAppealImport(@Param("list")List<Map<String,String>> list,@Param("importBatchId")Long importBatchId);

    /**
     * <b> 批量修改人员信息表状态 </b>
     * @author ZXF
     * @create 2020/01/09 0009 15:28
     * @version
     * @注意事项 </b>
     */
    int updateBatchAuthStatus(Long importBatchId);

    /**
     * <b> 批量修改认证结果表信息 </b>
     * @author ZXF
     * @create 2020/01/09 0009 15:47
     * @version
     * @注意事项 </b>
     */
    int updateBatchAuthRecord(Long importBatchId);

    /**
     * <b> 批量修改认证申诉状态 </b>
     * @author ZXF
     * @create 2020/01/09 0009 15:55
     * @version
     * @注意事项 </b>
     */
    int updateBatchApproveStatus(Long importBatchId);

    /**
     * 删除临时表数据
     * @param importBatchId
     * @return
     */
    int deleteTempBatchAppealImport(Long importBatchId);

    /**
     * 清除人员证件照
     *
     * @param perId
     * @author llc
     * @date 2020-07-01
     * @return
     */
    int deletePerColorPhotoUrl(@Param("perId") Long perId);

    /**
     * 通过天翎Ids获取perIds
     * @author wangjianjun
     * @date 2021/4/6
     */
    List<String> getPerIdsByTlkUserIds(@Param("tlkUserIdList") Collection<String> tlkUserIdList);

}
