package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.system.ComSocialInsSchemeDetail;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

/**
 * <p>陈堂君
 * <p>类描述: 企业医社保缴费方案明细
 * <p>
 * @apiNote  作者 陈堂君
 * @since 创建于 2017/12/22 13:12
 */
@Component
public interface ComSocialInsSchemeDetailMapper {
    int insert(ComSocialInsSchemeDetail record);
    int update(ComSocialInsSchemeDetail record);

    /**
     * 根据方案ID，更新多个方案明细
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:55
     * @param record
     * @return
     */
    int updateByIds(ComSocialInsSchemeDetail record);

    /**
     * 根据明细ID，获得医社保明细详情
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:55
     * @param paySchemeDetailId
     * @return
     */
    ComSocialInsSchemeDetail selectById(@Param("paySchemeDetailId") Long paySchemeDetailId);

    /**
     * 根据ID软删除医社保明细
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:57
     * @param paySchemeDetailId
     * @return
     */
    int deleteById(@Param("paySchemeDetailId") Long paySchemeDetailId);

}