package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComAttendResponsPer;
import com.bcxin.oa.old.dto.ComAttendResponsPerDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业考勤组负责人员
 *
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
public interface ComAttendResponsPerMapper extends CrudDao<ComAttendResponsPer> {

    /**
     * 删除之前设置的负责人
     *
     * @param attendGroupId
     * @param
     * @return
     */
    int deleteByAttendGroupId(@Param(value = "attendGroupId") Long attendGroupId);

    /**
     * 设置新的负责人
     *
     * @param comAttendResponsPer
     * @return
     */
    int saveComAttendResponsPer(ComAttendResponsPer comAttendResponsPer);

    /**
     * 考勤组负责人信息
     *
     * @param attendGroupId
     * @return
     */
    List<ComAttendResponsPerDTO> findComAttendResponsPer(Long attendGroupId);

    /**
     * 批量插入考勤组负责人员
     *
     * @param comAttendResponsPerList
     * @return
     */

    int insertComAttendResponsPer(List<ComAttendResponsPer> comAttendResponsPerList);


    /**
     * 查询考勤组负责人员
     *
     * @param attendGroupId
     * @return
     */
    List<Map<String,Object>> getAttendResponsPerList(@Param(value = "attendGroupId") Long attendGroupId);
}