package com.bcxin.oa.old.entity.salary;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 人员薪资发放明细
 * 
 * @author llc
 * @date 2019-01-01
 */
@Data
@TableName("per_salary_grant_detail")
public class PerSalaryGrantDetail{

	/** 人员薪资发放ID */
	@ApiModelProperty(value = "人员薪资发放ID")
	private Long perSalaryGrantId;

	/** 薪资类型 */
	@ApiModelProperty(value = "薪资类型")
	private String salaryType;

	/** 创建时间 */
	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	/** 创建人ID */
	@ApiModelProperty(value = "创建人ID")
	private Long createBy;

	/** 金额 */
	@ApiModelProperty(value = "金额")
	private BigDecimal amount;

	/** 备注(工资条提醒项目) */
	@ApiModelProperty(value = "备注")
	private String remark;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerSalaryGrantId() {
		return perSalaryGrantId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getCreateBy() {
		return createBy;
	}

}