package com.bcxin.oa.old.entity.salary;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业薪资模板对应项目
 * 
 * @author llc
 * @date 2018-12-28
 */
@Data
@TableName("com_salary_temp_project")
public class ComSalaryTempProject{

	/** 企业薪资模板ID */
	@ApiModelProperty(value = "企业薪资模板ID")
	private Long comSalaryTempId;

	/** 薪资类型 */
	@ApiModelProperty(value = "薪资类型")
	private String salaryType;

	/** 创建者 */
	@ApiModelProperty(value = "创建者")
	private Long createBy;

	/** 创建日期 */
	@ApiModelProperty(value = "创建日期")
	private Date createTime;

	/** 设置的金额 */
	@ApiModelProperty(value = "设置的金额")
	private Long setAmount;


	/** 备注(工资条提醒项目) */
	@ApiModelProperty(value = "备注")
	private String remark;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComSalaryTempId() {
		return comSalaryTempId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getCreateBy() {
		return createBy;
	}

}