package com.bcxin.oa.old.entity.salary;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业薪资模板
 * 
 * @author llc
 * @date 2018-12-28
 */
@Data
@TableName("com_salary_temp")
public class ComSalaryTemp extends BaseEntity<ComSalaryTemp> {

	/** 企业薪资模板ID */
	@ApiModelProperty(value = "企业薪资模板ID")
	private Long comSalaryTempId;

	/** 模板名称 */
	@ApiModelProperty(value = "模板名称")
	private String name;

	/** 开始年月 */
	@ApiModelProperty(value = "开始年月")
	private String startYears;

	/** 结束年月 */
	@ApiModelProperty(value = "结束年月")
	private String endYears;

	/** 是否启用 */
	@ApiModelProperty(value = "是否启用")
	private String isActive;

	/** 备注 */
	@ApiModelProperty(value = "备注")
	private String remark;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComSalaryTempId() {
		return comSalaryTempId;
	}
}