package com.bcxin.oa.old.entity.enterprise.company;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 企业基础信息
 *
 * @author zhangye
 * @since 2017-12-22 11:20:53
 */
@TableName("com_base_info")
@Data
public class ComBaseInfo extends BaseEntity<ComBaseInfo> {
	private static final long serialVersionUID = 1050645601L;

	/**
	 * 企业ID
	 */
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	/**
	 * 认证类型
	 */
	@ApiModelProperty(value = "认证类型")
	private String authType;

	/**
	 * 认证状态
	 */
	@ApiModelProperty(value = "认证状态")
	private String authStatus;

	/**
	 * 认证说明
	 */
	@ApiModelProperty(value = "认证说明")
	private String authRemark;
	/**
	 * 首次认证通过时间
	 */
	@ApiModelProperty(value = "首次认证通过时间")
	protected Date firstAuthTime = new Date(); // 更新日期

	/**
	 * 公司名称
	 */
	@ApiModelProperty(value = "公司名称")
	private String comName;

	/**
	 * 企业LOGOurl
	 */
	// @NotEmpty(message = "企业LOGOurl")
	@ApiModelProperty(value = "企业LOGOurl")
	private String logoUrl;

	/**
	 * 联系电话
	 */
	@ApiModelProperty(value = "联系电话")
	private String telePhone;

	/**
	 * 传真
	 */
	@ApiModelProperty(value = "传真")
	private String fax;

	/**
	 * 注册地所在省份
	 */
	@NotNull(message = "注册地所在省份不能为空")
	@ApiModelProperty(value = "注册地所在省份")
	private Integer regProvince;

	/**
	 * 注册地所在城市
	 */
	@NotNull(message = "注册地所在城市不能为空")
	@ApiModelProperty(value = "注册地所在城市")
	private Integer regCity;

	/**
	 * 注册地所在区/县
	 */
	@NotNull(message = "注册地所在区/县不能为空")
	@ApiModelProperty(value = "注册地所在区/县")
	private Integer regArea;

	/**
	 * 注册具体地址
	 */
	@ApiModelProperty(value = "注册具体地址")
	private String regAddress;

	/**
	 * 注册完整地址到门牌号
	 */
	@ApiModelProperty(value = "注册完整地址到门牌号")
	private String regDetailAddress;
	/**
	 * 注册完整地址所在地邮编
	 */
	@ApiModelProperty(value = "注册完整地址所在地邮编")
	private String zipCode;

	/**
	 * 办公地所在省份
	 */
	@ApiModelProperty(value = "办公地所在省份")
	private Integer workProvince;

	/**
	 * 办公地所在城市
	 */
	@ApiModelProperty(value = "办公地所在城市")
	private Integer workCity;

	/**
	 * 办公地所在区/县
	 */
	@ApiModelProperty(value = "办公地所在区/县")
	private Integer workArea;

	/**
	 * 办公地址
	 */
	@ApiModelProperty(value = "办公地址")
	private String workAddress;

	/**
	 * 经济类型
	 */
	@ApiModelProperty(value = "经济类型")
	private String economicType;

	/**
	 * 行业类型
	 */
	@ApiModelProperty(value = "行业类型")
	private String industryType;

	/**
	 * 公司类型
	 */
	@ApiModelProperty(value = "公司类型")
	private String comType;

	/**
	 * 机构类型
	 */
	@ApiModelProperty(value = "机构类型")
	private String institutionType;

	/**
	 * 是否分公司
	 */
	@ApiModelProperty(value = "是否分公司")
	private String isBranchCom;

	/**
	 * 总公司名称
	 */
	@ApiModelProperty(value = "总公司名称")
	private String parentComName;

	/**
	 * 总公司营业执照号
	 */
	@ApiModelProperty(value = "总公司营业执照号")
	private String parentComCerNo;

	/**
	 * 总公司法人
	 */
	@ApiModelProperty(value = "总公司法人")
	private String parentComRep;

	/**
	 * 总公司联系电话
	 */
	@ApiModelProperty(value = "总公司联系电话")
	private String parentComTel;

	/**
	 * 法定代表人姓名
	 */
	@ApiModelProperty(value = "法定代表人姓名")
	private String legalRepName;

	/**
	 * 法定代表人国籍/地区
	 */
	@ApiModelProperty(value = "法定代表人国籍/地区")
	private String nationality;

	/**
	 * 法定代表人手机号
	 */
	@Pattern(regexp = "^1[0-9]{10}$", message = "手机格式不正确")
	@ApiModelProperty(value = "法定代表人手机号")
	private String legalRepPhone;

	/**
	 * 法定代表人证件类型
	 */
	@ApiModelProperty(value = "法定代表人证件类型")
	private String idCardType;

	/**
	 * 法定代表人证件号码
	 */
	@ApiModelProperty(value = "法定代表人证件号码")
	private String idCardNo;

	/**
	 * 注册资金（万元）
	 */
	@ApiModelProperty(value = "注册资金（万元）")
	private BigDecimal regAmount;

	/**
	 * 固定资产（万元）
	 */
	@ApiModelProperty(value = "固定资产（万元）")
	private BigDecimal fixedAssets;

	/**
	 * 年营业额（万元）
	 */
	@ApiModelProperty(value = "年营业额（万元）")
	private BigDecimal annualTurnover;

	/**
	 * 年利税（万元）
	 */
	@ApiModelProperty(value = "年利税（万元）")
	private BigDecimal annualProfitTax;

	/**
	 * 企业证件类型
	 */
	@ApiModelProperty(value = "企业证件类型")
	private String comCerType;

	/**
	 * 企业证件类型
	 */
	@ApiModelProperty(value = "企业证件号")
	private String comCerNo;

	/**
	 * 企业证件url
	 */
	@ApiModelProperty(value = "企业证件url")
	private String comCerUrl;

	/**
	 * 企业树代码
	 */
	@ApiModelProperty(value = "企业树代码")
	private String comTreeCode;

	/**
	 * 企业来源
	 */
	@ApiModelProperty(value = "企业来源")
	private String comSource;

	/**
	 * 上级企业ID
	 */
	@ApiModelProperty(value = "上级企业ID")
	private Long parentComId;

	/**
	 * 企业注册ID
	 */
	@ApiModelProperty(value = "企业注册ID")
	private Long comRegId;

	/**
	 * 组织新增事件ID
	 */
	@ApiModelProperty(value = "组织新增事件ID")
	private Long orgAddEventId;

	/**
	 * 是否初始化完成(0：未完成，1：已完成)
	 */
	@ApiModelProperty(value = "是否初始化完成")
	private String isInit = "0";

	@ApiModelProperty(value = "v5平台企业映射ID")
	private String tlkDomainId;

	public String getComCerNo() {
		return comCerNo;
	}

	public void setComCerNo(String comCerNo) {
		this.comCerNo = comCerNo;
	}

	public String getAuthType() {
		return authType;
	}

	public void setAuthType(String authType) {
		this.authType = authType;
	}

	public String getAuthStatus() {
		return authStatus;
	}

	public void setAuthStatus(String authStatus) {
		this.authStatus = authStatus;
	}

	public String getComName() {
		return comName;
	}

	public void setComName(String comName) {
		this.comName = comName;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public void setLogoUrl(String logoUrl) {
		this.logoUrl = logoUrl;
	}

	public String getTelePhone() {
		return telePhone;
	}

	public void setTelePhone(String telePhone) {
		this.telePhone = telePhone;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	public Integer getRegProvince() {
		return regProvince;
	}

	public void setRegProvince(Integer regProvince) {
		this.regProvince = regProvince;
	}

	public Integer getRegCity() {
		return regCity;
	}

	public void setRegCity(Integer regCity) {
		this.regCity = regCity;
	}

	public Integer getRegArea() {
		return regArea;
	}

	public void setRegArea(Integer regArea) {
		this.regArea = regArea;
	}

	public String getRegAddress() {
		return regAddress;
	}

	public void setRegAddress(String regAddress) {
		this.regAddress = regAddress;
	}

	public String getEconomicType() {
		return economicType;
	}

	public void setEconomicType(String economicType) {
		this.economicType = economicType;
	}

	public String getIndustryType() {
		return industryType;
	}

	public void setIndustryType(String industryType) {
		this.industryType = industryType;
	}

	public String getComType() {
		return comType;
	}

	public void setComType(String comType) {
		this.comType = comType;
	}

	public String getInstitutionType() {
		return institutionType;
	}

	public void setInstitutionType(String institutionType) {
		this.institutionType = institutionType;
	}

	public String getIsBranchCom() {
		return isBranchCom;
	}

	public void setIsBranchCom(String isBranchCom) {
		this.isBranchCom = isBranchCom;
	}

	public String getParentComName() {
		return parentComName;
	}

	public void setParentComName(String parentComName) {
		this.parentComName = parentComName;
	}

	public String getParentComRep() {
		return parentComRep;
	}

	public void setParentComRep(String parentComRep) {
		this.parentComRep = parentComRep;
	}

	public String getParentComTel() {
		return parentComTel;
	}

	public void setParentComTel(String parentComTel) {
		this.parentComTel = parentComTel;
	}

	public String getLegalRepName() {
		return legalRepName;
	}

	public void setLegalRepName(String legalRepName) {
		this.legalRepName = legalRepName;
	}

	public String getNationality() {
		return nationality;
	}

	public void setNationality(String nationality) {
		this.nationality = nationality;
	}

	public String getLegalRepPhone() {
		return legalRepPhone;
	}

	public void setLegalRepPhone(String legalRepPhone) {
		this.legalRepPhone = legalRepPhone;
	}

	public String getIdCardType() {
		return idCardType;
	}

	public void setIdCardType(String idCardType) {
		this.idCardType = idCardType;
	}

	public String getIdCardNo() {
		return idCardNo;
	}

	public void setIdCardNo(String idCardNo) {
		this.idCardNo = idCardNo;
	}

	public BigDecimal getRegAmount() {
		return regAmount;
	}

	public void setRegAmount(BigDecimal regAmount) {
		this.regAmount = regAmount;
	}

	public BigDecimal getFixedAssets() {
		return fixedAssets;
	}

	public void setFixedAssets(BigDecimal fixedAssets) {
		this.fixedAssets = fixedAssets;
	}

	public BigDecimal getAnnualTurnover() {
		return annualTurnover;
	}

	public void setAnnualTurnover(BigDecimal annualTurnover) {
		this.annualTurnover = annualTurnover;
	}

	public BigDecimal getAnnualProfitTax() {
		return annualProfitTax;
	}

	public void setAnnualProfitTax(BigDecimal annualProfitTax) {
		this.annualProfitTax = annualProfitTax;
	}

	public String getComCerType() {
		return comCerType;
	}

	public void setComCerType(String comCerType) {
		this.comCerType = comCerType;
	}

	public String getComCerUrl() {
		return comCerUrl;
	}

	public void setComCerUrl(String comCerUrl) {
		this.comCerUrl = comCerUrl;
	}

	public String getComTreeCode() {
		return comTreeCode;
	}

	public void setComTreeCode(String comTreeCode) {
		this.comTreeCode = comTreeCode;
	}

	public String getComSource() {
		return comSource;
	}

	public void setComSource(String comSource) {
		this.comSource = comSource;
	}

	public String getTlkDomainId() {
		return tlkDomainId;
	}

	public void setTlkDomainId(String tlkDomainId) {
		this.tlkDomainId = tlkDomainId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getParentComId() {
		return parentComId;
	}

	public void setParentComId(Long parentComId) {
		this.parentComId = parentComId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComRegId() {
		return comRegId;
	}

	public void setComRegId(Long comRegId) {
		this.comRegId = comRegId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getOrgAddEventId() {
		return orgAddEventId;
	}

	public void setOrgAddEventId(Long orgAddEventId) {
		this.orgAddEventId = orgAddEventId;
	}

}