package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.system.PerBaseInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author：wangcy @date：2017/12/20 0020 10:06
 * @description：PerBaseInfo的实体类
 */
@Data
public class PerBaseInfoDto extends PerBaseInfo {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 入职日期
	 */
	private Date entryDate;

	/**
	 * 部门ID
	 */
	private Long orgId;

	/**
	 * 部门名称
	 */
	private Long departName;

	/**
	 * 角色名称
	 */
	private String roleName;

	/**
	 * 角色Id
	 */
	private String roleId;
	/**
	 * 角色类型
	 */
	private String roleType;

	/**
	 * 角色组ID
	 */
	private String roleGroupId;

	/**
	 * app是否激活
	 */
	private String isAppActive;

	/**
	 * app认证状态
	 */
	private String isAppAuth;

	/**
	 * 特殊字段
	 */
	@ApiModelProperty(value = "特殊字段")
	private String perIndustryInfoList;
	/**
	 * 多角色
	 */
	@ApiModelProperty(value = "多角色")
	private String roleIds;

	/**
	 * 行业类型名称
	 */
	@ApiModelProperty(value = "行业类型名称")
	private String industryTypeName;
	/**
	 * 机构类型名称
	 */
	@ApiModelProperty(value = "机构类型名称")
	private String institutionTypeName;

	/**
	 * 人员类型名称
	 */
	@ApiModelProperty(value = "人员类型名称")
	private String perTypeName;

	/**
	 * 修改的新手机号码
	 */
	@ApiModelProperty(value = "修改的新手机号码")
	private String newMobile;

	public Date getEntryDate() {
		return entryDate;
	}

	/**
	 * 用户名
	 */
	@ApiModelProperty(value = "用户名")
	private String userName;


	/**
	 * 户口区域全称
	 */
	@ApiModelProperty(value = "户口区域全称")
	private String residenceAreaName;

	/**
	 * 居住区域全称
	 */
	@ApiModelProperty(value = "居住区域全称")
	private String domicileAreaName;


	/**
	 * 人员ID集合
	 */
	@ApiModelProperty(value = "人员ID集合")
	private String perIds;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getOrgId() {
		return orgId;
	}

}
