package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.dto.ComTaskImplementDto;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskImplementService;
import com.bcxin.oa.old.service.task.ComTaskTrackService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhangjianhua
 * @date 2018/4/16
 */
@RestController
@Api(tags = {""}, description = "任务轨迹")
@RequestMapping("/task/track")
public class ComTrackController extends BaseController {

    @Autowired
    private ComTaskTrackService comTaskTrackService;

    @Autowired
    private ComTaskImplementService comTaskImplementService;

    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询任务轨迹", title = "查询任务轨迹", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "select-task-track")
    @ApiOperation(value = "查询任务轨迹", httpMethod = "GET", notes = "查询任务轨迹", response = ComTaskImplementDto.class)
    public Result selectTaskTrack(ComTaskImplementDto comTaskImplementDto) throws BusinessException {
        return comTaskTrackService.selectTaskTrack(comTaskImplementDto).setBack(getRequest());
    }


    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "保存任务轨迹", title = "保存任务轨迹", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "save-task-track")
    @ApiOperation(value = "保存任务轨迹", httpMethod = "POST", notes = "保存任务轨迹", response = ComTaskImplementDto.class)
    public Result saveTaskTrack(ComTaskImplementDto comTaskImplementDto) throws BusinessException {
        return comTaskTrackService.saveTaskTrack(comTaskImplementDto).setBack(getRequest());
    }

    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询任务轨迹", title = "根据日期查询单个人任务执行情况信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "list-task-implement")
    @ApiOperation(value = "根据日期查询单个人任务执行情况信息", httpMethod = "GET", notes = "根据日期查询单个人任务执行情况信息", response = MultiDataDTO.class)
    public Result listTaskImplement(MultiDataDTO multiDataDTO) throws BusinessException {
        return comTaskImplementService.listTaskImplement(multiDataDTO).setBack(getRequest());
    }


    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询任务轨迹", title = "出勤情况列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "list-implement")
    @ApiOperation(value = "出勤情况列表", httpMethod = "GET", notes = "出勤情况列表", response = MultiDataDTO.class)
    public Result listImplement(MultiDataDTO multiDataDTO) throws BusinessException {
        return comTaskImplementService.listImplement(multiDataDTO).setBack(getRequest());
    }


    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询任务轨迹最近出勤月份", title = "查询任务轨迹最近出勤月份", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "select-implement-month")
    @ApiOperation(value = "查询任务轨迹最近出勤月份", httpMethod = "GET", notes = "查询任务轨迹最近出勤月份", response = MultiDataDTO.class)
    public Result selectImplementMonth(MultiDataDTO multiDataDTO) throws BusinessException {
        return comTaskImplementService.selectImplementMonth(multiDataDTO).setBack(getRequest());
    }


}
