package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComTaskImplementServiceImpl;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


/**
 * <p>
 * 任务管理-任务详情-出勤及轨迹
 * </p>
 *
 * @author 李勇强
 * @since 2018-03-07 10:33:02
 */
@RestController
@RequestMapping("/task/com-task-impl")
@Api(value = "任务管理", description = "出勤及轨迹")
public class ComTaskImplementController extends BaseController {

    @Resource
    private ComTaskImplementServiceImpl comTaskImplementService;

    /**
     * 获取任务出勤记录
     * @param  comTaskImplementDto
     * @author liyongqiang
     *      必要参数：企业id、任务id
     *      可选参数：月份（paramMonth，格式2017-08）
     *              人员名字（perName）
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务出勤记录")
    @PostMapping(value = "attendance-record")
    @ApiOperation(value = "任务出勤记录", httpMethod = "POST", notes = "获取任务出勤记录", response = Result.class)
    public Result listAttendanceRecord(ComTaskImplementDto comTaskImplementDto) throws BusinessException {
        return comTaskImplementService.listAttendanceRecord(comTaskImplementDto);
    }


    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务出勤记录轨迹状态", title = "任务出勤记录轨迹状态")
    @PostMapping(value = "attendance-status")
    @ApiOperation(value = "任务出勤记录轨迹状态", httpMethod = "POST", notes = "任务出勤记录轨迹状态", response = Result.class)
    public Result attendanceStatus(ComTaskImplementDto comTaskImplementDto) throws BusinessException {
        return comTaskImplementService.attendanceStatus(comTaskImplementDto);
    }



    /**
     * 获取任务日志
     * 必要参数：任务id
     * 可选参数：人员id、某一天日期
     * @author liyongqiang
     * @param comTaskFeedbackParamDto 任务反馈参数dto
     * @return java.util.List
     *
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务出勤记录-任务日志")
    @PostMapping(value = "task-log")
    @ApiOperation(value = "任务日志", httpMethod = "POST", notes = "任务出勤记录-任务日志", response = Result.class)
    public Result listTaskLog(ComTaskFeedbackParamDto comTaskFeedbackParamDto) throws BusinessException {
        return comTaskImplementService.listTaskLog(comTaskFeedbackParamDto);
    }


    /**
     * 获取某个人员或某天的轨迹
     * @author liyongqiang
     * @param comTaskTrackPageParamDto 单独查询轨迹参数dto
     * @return 轨迹列表
     * @exception
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "任务出勤记录-获取轨迹-某人某天")
    @PostMapping(value = "query-track")
    @ApiOperation(value = "获取某任务某人某天的出勤轨迹",  notes = "任务出勤记录-查询轨迹", response = Result.class)
    public Result queryTrack(ComTaskTrackPageParamDto comTaskTrackPageParamDto) throws BusinessException {
        return  comTaskImplementService.showTrack(comTaskTrackPageParamDto);
    }



}