package com.bcxin.oa.old.controller.salary;

import com.bcxin.oa.old.entity.salary.PerSalaryGrant;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.salary.PerSalaryParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.salary.web.PerSalaryGrantService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 薪酬管理的controller层
 * by llc 2019-01-01
 */
@RestController
@RequestMapping("/task/com/salary")
@Api(tags = { "" }, description = "薪酬管理")
public class PerSalaryController extends BaseController {

	@Autowired
	private PerSalaryGrantService perSalaryGrantService;


	/**
	 * 核算薪资
	 * @return
	 * @author llc
	 * @date 2019-01-02
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "自动核算薪资", title = "自动核算薪资", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "自动核算薪资", httpMethod = "POST", notes = "自动核算薪资", response = PerSalaryGrant.class)
	@PostMapping(value = "cal-salary")
	public Result calSalary(PerSalaryGrant perSalaryGrant) {
		return perSalaryGrantService.calSalary(perSalaryGrant).setBack(getRequest());
	}


	/**
	 * 查看工资条详情
	 * @return
	 * @author llc
	 * @date 2019-01-02
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "查看工资条详情", title = "查看工资条详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "查看工资条详情", httpMethod = "POST", notes = "查看工资条详情", response = PerSalaryGrant.class)
	@PostMapping(value = "salary-detail")
	public Result salaryDetail(ParamDTO paramDTO) {
		return perSalaryGrantService.getPerSalaryDetail(paramDTO).setBack(getRequest());
	}

	/**
	 * 修改工资条
	 * @return
	 * @author llc
	 * @date 2019-01-02
	 */
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "修改工资条", title = "修改工资条", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "修改工资条", httpMethod = "POST", notes = "修改工资条", response = PerSalaryGrant.class)
	@PostMapping(value = "update-salary")
	public Result updateSalary(HttpServletRequest request) throws BusinessException {
		return perSalaryGrantService.updateSalaryDetail(getParams()).setBack(getRequest());
	}

	/**
	 * 管理员批量核算(确认)工资条
	 * @return
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "批量核算(确认)工资条", title = "批量核算(确认)工资条", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "批量核算(确认)工资条", httpMethod = "POST", notes = "批量核算(确认)工资条", response = PerSalaryGrant.class)
	@PostMapping(value = "batch-account-salary")
	public Result batchAccountSalary(ParamDTO paramDTO) throws BusinessException {
		return perSalaryGrantService.batchAccountSalary(paramDTO).setBack(getRequest());
	}


	/**
	 * 校验是否核算
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-01-02
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "校验是否核算", title = "校验是否核算", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "check-is-account")
	@ApiOperation(value = "校验是否核算", httpMethod = "GET", notes = "校验是否核算", response = Map.class)
	public Result checkIsAccount(PerSalaryParamDTO dto) {
		return perSalaryGrantService.checkIsAccount(dto).setBack(getRequest());
	}

	/**
	 * 人员月度工资分页查询
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-01-02
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "人员月度工资分页查询", title = "人员月度工资分页查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "page-for-per-salary")
	@ApiOperation(value = "人员月度工资分页查询", httpMethod = "GET", notes = "人员月度工资分页查询", response = Map.class)
	public Result pageForPerSalary(PerSalaryParamDTO dto) {
		return perSalaryGrantService.getPerSalaryList(dto).setBack(getRequest());
	}


	/**
	 * 人员月度工资导出
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2019-01-17
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员月度工资导出", title = "人员月度工资导出", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-per-month-salary")
	@ApiOperation(value = "人员月度工资导出", httpMethod = "GET", notes = "人员月度工资导出")
	public Result exportPerMonthSalary(PerSalaryParamDTO dto) throws BusinessException {
		return perSalaryGrantService.exportPerMonthSalary(dto,getResponse()).setBack(getRequest());
	}


	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员薪酬模板导出", title = "导出人员薪酬Excel模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-salary-template")
	public Result exportSalaryTemplate() throws BusinessException {
		return perSalaryGrantService.exportSalaryTemplate().setBack(getRequest());
	}


	/**
	 * 人员薪酬工资导入
	 * @author lp
	 * @date 2019-03-28
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "人员薪酬工资导入", title = "人员薪酬工资导入", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "import-per-month-salary")
	@ApiOperation(value = "人员薪酬工资导入", httpMethod = "POST", notes = "人员薪酬工资导入")
	public Result importPerMonthSalary(@RequestParam("xfile") MultipartFile file, ParamDTO paramDTO, HttpServletRequest request) throws BusinessException {
		return perSalaryGrantService.importSalaryReportInfo(file,paramDTO).setBack(request);
	}


	/**
	 * 删除工资条
	 * @author lp
	 * @date 2019-04-08
	 */
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "删除工资条", title = "删除工资条", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "delete-salary-grant")
	@ApiOperation(value = "删除工资条", httpMethod = "POST", notes = "删除工资条")
	public Result deleteSalaryGrant(ParamDTO paramDTO, HttpServletRequest request) throws BusinessException {
		return perSalaryGrantService.deleteSalaryGrant(paramDTO).setBack(request);
	}

}
