package com.bcxin.oa.current.dto.response.result;

import com.bcxin.oa.current.common.emus.StatusCode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 通用返回响应对象 所有的restful返回均需要以这个对象为准
 */
public abstract class AbstractRespResult {

    /**
     * 响应状态
     */
    @Getter
    private int code;
    /**
     * 响应时间
     */
    @Getter
    private long timestamp;

    /**
     * 响应消息
     */
    @Getter
    private String msg;

    protected AbstractRespResult() {
        this.code = StatusCode.succeed.getCode();
        this.msg = StatusCode.succeed.getDefaultMessage();
        this.timestamp = System.currentTimeMillis();
    }

    protected AbstractRespResult(int code, String message) {
        super();
        this.code = code;
        if (StringUtils.isBlank(message)) {
            this.msg = "";
        } else {
            this.msg = message;
        }
        this.timestamp = System.currentTimeMillis();
    }

    protected AbstractRespResult(StatusCode statusCode, String message) {
        super();
        if (statusCode == null) {
            statusCode = StatusCode.succeed;
        }
        this.code = statusCode.getCode();
        if (StringUtils.isBlank(message)) {
            this.msg = statusCode.getDefaultMessage();
        } else {
            this.msg = message;
        }
        this.timestamp = System.currentTimeMillis();
    }

    @JsonIgnore
    public boolean isSucceed() {
        return this.code == StatusCode.succeed.getCode();
    }
}
