import { SFCParseResult } from '@vue/compiler-sfc';
import { EmbeddedFileMappingData, TeleportMappingData, _VueCompilerOptions } from './types';
import { EmbeddedFileSourceMap, Teleport } from './utils/sourceMaps';
import { CodeGen } from '@volar/code-gen';
import { Mapping } from '@volar/source-map';
import * as CompilerDom from '@vue/compiler-dom';
import type * as ts from 'typescript/lib/tsserverlibrary';
export declare type VueLanguagePlugin = (ctx: {
    modules: {
        typescript: typeof import('typescript/lib/tsserverlibrary');
    };
    compilerOptions: ts.CompilerOptions;
    vueCompilerOptions: _VueCompilerOptions;
}) => {
    order?: number;
    parseSFC?(fileName: string, content: string): SFCParseResult | undefined;
    updateSFC?(oldResult: SFCParseResult, textChange: {
        start: number;
        end: number;
        newText: string;
    }): SFCParseResult | undefined;
    compileSFCTemplate?(lang: string, template: string, options?: CompilerDom.CompilerOptions): CompilerDom.CodegenResult | undefined;
    updateSFCTemplate?(oldResult: CompilerDom.CodegenResult, textChange: {
        start: number;
        end: number;
        newText: string;
    }): CompilerDom.CodegenResult | undefined;
    getEmbeddedFileNames?(fileName: string, sfc: Sfc): string[];
    resolveEmbeddedFile?(fileName: string, sfc: Sfc, embeddedFile: EmbeddedFile): void;
};
export interface SourceFile extends ReturnType<typeof createSourceFile> {
}
export interface EmbeddedStructure {
    self: Embedded | undefined;
    embeddeds: EmbeddedStructure[];
}
export interface Embedded {
    file: EmbeddedFile;
    sourceMap: EmbeddedFileSourceMap;
    teleport: Teleport | undefined;
}
export interface SfcBlock {
    tag: 'script' | 'scriptSetup' | 'template' | 'style' | 'customBlock';
    start: number;
    end: number;
    startTagEnd: number;
    endTagStart: number;
    lang: string;
    content: string;
}
export interface Sfc {
    template: SfcBlock | null;
    script: (SfcBlock & {
        src: string | undefined;
    }) | null;
    scriptSetup: SfcBlock | null;
    styles: (SfcBlock & {
        module: string | undefined;
        scoped: boolean;
    })[];
    customBlocks: (SfcBlock & {
        type: string;
    })[];
    templateAst: CompilerDom.RootNode | undefined;
    scriptAst: ts.SourceFile | undefined;
    scriptSetupAst: ts.SourceFile | undefined;
}
export interface EmbeddedFile {
    parentFileName?: string;
    fileName: string;
    isTsHostFile: boolean;
    capabilities: {
        diagnostics: boolean;
        foldingRanges: boolean;
        formatting: boolean | {
            initialIndentBracket?: [string, string];
        };
        documentSymbol: boolean;
        codeActions: boolean;
        inlayHints: boolean;
    };
    codeGen: CodeGen<EmbeddedFileMappingData>;
    teleportMappings: Mapping<TeleportMappingData>[];
}
export declare function createSourceFile(fileName: string, scriptSnapshot: ts.IScriptSnapshot, ts: typeof import('typescript/lib/tsserverlibrary'), plugins: ReturnType<VueLanguagePlugin>[]): {
    fileName: string;
    readonly text: string;
    update: (newScriptSnapshot: ts.IScriptSnapshot, init?: boolean) => void;
    readonly compiledSFCTemplate: {
        errors: CompilerDom.CompilerError[];
        warnings: CompilerDom.CompilerError[];
        ast: CompilerDom.RootNode | undefined;
    } | undefined;
    readonly tsFileName: string;
    readonly sfc: Sfc;
    readonly embeddeds: EmbeddedStructure[];
    readonly allEmbeddeds: Embedded[];
    readonly teleports: {
        file: EmbeddedFile;
        teleport: Teleport;
    }[];
};
