/**
 * @function 业务模块弹窗逻辑的抽离
 * @author Lyq（2020-05-21）
 *       
 */
import { Component } from "react";
import { Modal } from 'antd';
import {
  systemComVaseInfoGet,
  getCompanyShareHolder,
  comStockManageList,
  enterpriseCompanyComBaseInfoGetComBaseInfoById
} from '../../services/api';


export default function declare(WrapComponent) {
  return class DeclareComponent extends Component {
    constructor(props, context) {
      super(props, context);
      this.state = {
        showModal: false,
        isBeijing: false
      };
    }
    componentWillMount() {
      this.__checkCompany();
    }
    // 1、地区=北京
  // 2、判断是否有填写股东信息、管理层信息
  // 3、机构类型=保安服务公司
  // 4、企业类型=国有、集体所有、全民所有时，只校验管理层；其他企业类型校验股东、管理层
  async __checkCompany() {
    // 获取企业所在的区域
    systemComVaseInfoGet({}).then(res => {
      // 区域代码和分公司判断
      const { regProvince, isBranchCom } = res.data;
      // 新疆和北京地区的需要判断
      if (/(65)|(11)/.test(regProvince)) {
        this.setState({
          isBeijing: true
        });
        enterpriseCompanyComBaseInfoGetComBaseInfoById({}).then(enterpriseRes => {
          const { institutionType, comType } = enterpriseRes.data;
          // 保安服务公司
          if (institutionType == '0102') {
            // 企业类型=国有、集体所有、全民所有时或者是分公司，只校验管理层(通过列表的数据是否为0)
            if (comType == '3' || comType == '5' || comType == '6' || isBranchCom == '1') {
              // 只校验管理层
              comStockManageList({ pageSize: "10", pageNumber: "1" }).then(manageRes => {
                if (manageRes.data.total == 0) {
                  this.setState({
                    showModal: true
                  });
                  this._showModal();
                }
              });
              // 其他校验股东、管理层
            } else {
              //校验企业的股东信息、管理层信息是否有填写
              getCompanyShareHolder({ pageSize: "10", pageNumber: "1" }).then(result => {
                comStockManageList({ pageSize: "10", pageNumber: "1" }).then(manageRes => {
                  if (result.data.total == 0 || manageRes.data.total == 0) {
                    this.setState({
                      showModal: true
                    });
                    this._showModal();
                  }
                });
              });
            }
          }
        })
      }
    });
  }
    _showModal() {
      Modal.info({
        title: '公安监管限制',
        okText: '去完善',
        content: (
          <div>
            系统检测到您尚未完善企业股东信息或管理层信息，请访问【企业管理】-【企业报备】页面进行完善。（无股东的分公司，只完善管理层信息即可）<br />
            <span style={{ color: 'red' }}>根据北京市公安局治安管理总队要求：保安行业企业进行保安行业资质申报服务前，需完善企业股东信息、管理层信息，否则无法申报。</span>
          </div>
        ),
        onOk: () => {
          this.props.history.push('/enterprise/reported');
        },
      });
    }
    render() {
      return (
        <WrapComponent
          showModal={this.state.showModal}
          isBeijing={this.state.isBeijing}
          {...this.props}
        />
      );
    }
  }
};