import store from 'store';
/* 
*  域名环境的区分
*/
const defaultName = '百保盾企业管理平台';
const beijing = '北京保安服务综合管理信息系统';
const guangxi = '广西智慧保安监管信息系统';
const shanxi = '陕西保安服务监管信息系统';
const ningxia = '宁夏保安服务监管信息系统';
const yanan = '延安市保安员智慧考试系统';

// 根据域名获取系统名字
function getNameFromDomain () {
  let name = defaultName;
  const prefix = window.location.hostname.split('.')[0];  //localhost, 114
  switch (true) {
    case prefix == 'bjba':
      name = beijing;
      break;
    case prefix == 'gxba':
      name = guangxi;
      break;
    case prefix == 'snba':
      name = shanxi;
      break;
    case prefix == 'nxba':
      name = ningxia;
      break;
    case prefix == 'yaba':
      name = yanan;
    // break;
    //测试环境和开发环境
    // case prefix == 'localhost' || prefix == '114':
  }
  return name;
}
const domainConf = {
  name: defaultName,
  https: 'https://saasweb.test.baibaodun.cn:9029',
  // 通过省份id判断区域
  getName(regProvince,regCity='') {
    // let name = this.name;
    let name = defaultName;
    // 登录的情况
    if(store.get('saas') && store.get('saas')['access_token']) {
      switch (true) {
        case /^11/.test(regProvince):
          name = beijing;
          break;
        case /^45/.test(regProvince):
          name = guangxi;
          break;
        case /^61/.test(regProvince):
          //陕西省的精确到市级的名称
          if(/^6106/.test(regCity)){
            name = yanan;
          }else{
            name = shanxi;
          }
          break;
        case /^64/.test(regProvince):
          name = ningxia;
      }
    }else { //未登录的情况下使用域名判断
      name = getNameFromDomain();
    }
    return name;
  }
};
const prefix = window.location.hostname.split('.')[0];  //localhost, test
domainConf.prefix = prefix;
// 正式环境
if (prefix != 'localhost' && prefix != 'saasweb') {
  domainConf.https = 'https://qiye.baibaodun.cn:9029';
}
domainConf.name = getNameFromDomain();
export const domainConfig = domainConf;

/* 
* im环境
*/
export const imKey = {
  SDKAppID: /qiye\.baibaodun\.cn/.test(window.location.hostname) ? 1400176891 : 
  // 1400246643
  1400383558
  // SDKAppID:window.location.hostname==='qiye.baibaodun.cn'?1400176891:1400246643
};

/**
 * 华为云视频的守护进程插件下载地址
 */
// export const uploadCloudLinkMeetingDaemonUrl='https://bcxin-saas-prod.obs.cn-north-1.myhuaweicloud.com/saasweb/front/CloudLinkMeetingDaemon.exe'

/**
 * 百课堂的配置路径
 * 1、如果是二级菜单中，嵌入的百课堂页面需后端配置
 * 2、如果是不属于直系菜单中，嵌入的百课堂页面由前端自己拼接
 */
const bktUrl={
 url:'http://test.bktang.cn/'
}
if (prefix != 'localhost' && prefix != 'saasweb') {
  bktUrl.url = 'http://www.bktang.cn/';
}
export const bktUrlConfig= bktUrl