/* 等级证接口 */
import { bktRequest } from '../../utils/request';

// 学员列表-导入等级证
export const grade_importIdentityTemplate = (data = {}) => {
  return bktRequest(
    {
      url: '/train/grade/class/person/import/identity/template', 
      headers: {
        "Content-Type": "multipart/form-data",
        "Accept": '*/*'
      },
      data
    },
    {
      type: "upload",
      loading: false
    }
  );
}
// 保安员报名列表【等级证】
export const trainGradeApplyLearnPage = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/learn/page', data});
}

// 验证保安员是否已经等级证报名【等级证】
export const validateExistsPersonApply = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/validate/exists/person/apply', data});
}
// 等级证新增报名【等级证】
export const trainGradeApplyPersonApply = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/person/apply', data});
}

// 等级证-取消报名【等级证】
export const trainGradeApplyCancel = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/cancel', data}, {errMsg: false});
}
// 等级证-【等级证】
export const trainGradeApplyInfo = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/info', data});
}
// 个人的实习记录【等级证】
export const trainInternInternLinePage = (data = {}) => {
  return bktRequest({url: '/train/intern/internLineByUid', data});
}

// 新增开班【等级证】
export const trainGradeCreateClass = (data = {}) => {
  return bktRequest({url: '/train/grade/createClass', data});
}

// 抽查【等级证】
export const trainGradeApplyInfoCheck = (data = {}) => {
  return bktRequest({url: 'train/apply/check/gradeApplyInfoCheck', data});
}

// 开班列表
export const trainGradeClassTrainPage = (data = {}) => {
  return bktRequest({url: '/train/grade/class/train/page', data});
}

// 班级成员列表-新增列表
export const trainGradeClassPersonAddPage = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/add/page', data});
}

// 班级详情
export const trainGradeClassInfo = (data = {}) => {
  return bktRequest({url: '/train/grade/classInfo', data});
}
// 班级名称--等级证开班命名
export const trainGradeCreateClassRole = (data = {}) => {
  return bktRequest({url: '/train/grade/createClassRole', data});
}
// 班级名称--等级证下载模板
export const trainExportClassAddTemplate = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/export/classAddTemplate', data});
}
// 取消班级
export const trainGradeCancelClass = (data = {}) => {
  return bktRequest({url: '/train/grade/cancelClass', data});
}
// 班级成员列表-新增学员
export const trainGradeClassPersonAdd = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/add', data});
}

// 班级成员列表-学员列表
export const trainGradeClassPersonPage = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/page', data});
}
// 批量删除学员
export const trainGradeClassPersonBatchDelete = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/batch/delete', data});
}
// 班级成员列表-发布结业考试通知
export const trainGradeClassPersonNotifyGraduate = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/notify/graduate', data});
}
// 班级成员列表-发布鉴定考试通知
export const trainGradeClassPersonNotifyIdentify = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/notify/identify', data});
}
// 班级成员列表-发送实操培训通知
export const trainGradeClassPersonNotifyOpen = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/notify/open', data});
}
// 班级成员列表-确认成绩
export const trainGradeClassPersonConfirmScore = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/confirm/score', data});
}
// 班级成员列表-保存修改单个人员成绩
export const trainGradeClassPersonUpdateScore = (data = {}) => {
  return bktRequest({url: '/train/grade/class/person/update/score', data});
}
// 申报学员列表
export const trainGradeApplyTrainPage = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/train/page', data});
}
// 等级证-材料审核不通过(personApplyId,materialApproveFailReason)
export const trainGradeApplyMaterialApproveReject = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/materialApproveReject', data});
}
// 等级证-材料审核通过(personApplyId)
export const trainGradeApplyDealMaterialApprove = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/dealMaterialApprove', data});
}
// 等级证-申诉机构查询
export const trainGradeApplyAppealOrg = (data = {}) => {
  return bktRequest({url: 'train/grade/apply/appeal/org', data});
}
// 等级证-申诉
export const trainGradeApplyAppeal = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/appeal', data});
}
// 等级证-报名详情-修改记录
export const trainGradeApplyInfoModifyLog = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/info/modifyLog', data});
}
// 等级证-报名详情-材料信息修改记录
export const trainGradeApplyPersonApplyUpdate = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/person/apply/update', data});
}
// 等级证-报名详情-等级证修改比对信息
export const grade_ApplyPersonApplyCompareUpdate = (data = {}) => {
  return bktRequest({url: '/train/grade/apply/person/apply/compare/update', data});
}
// 等级证-上传实操培训材料
export const trainGradeClassUploadPracticeMaterial = (data = {}) => {
  return bktRequest({url: '/train/grade/class/upload/practiceMaterial', data});
}


// 等级证-培训机构等级证学员实习审核列表
export const grade_trainInternLineApprovePage = (data = {}) => {
  return bktRequest({url: '/train/intern/trainInternLineApprovePage', data});
}
// 等级证-实习-个人的实习记录
export const grade_trainInternInternLineInfo = (data = {}) => {
  return bktRequest({url: '/train/intern/internLineInfo', data});
}
// 等级证-实习-培训机构实习记录审核通过
export const grade_trainInternLineApprovePass = (data = {}) => {
  return bktRequest({url: '/train/intern/trainInternLineApprovePass', data});
}
// 等级证-实习-培训机构实习记录审核不通过
export const grade_trainInternLineApproveFail = (data = {}) => {
  return bktRequest({url: '/train/intern/trainInternLineApproveFail', data});
}

// 等级证-实习-培训机构实习审核记录
export const grade_learnInternLineApprovePage = (data = {}) => {
  return bktRequest({url: '/train/intern/learnInternLineApprovePage', data});
}
// 等级证-实习-培训机构实习审核记录
export const grade_learnTrackAuthQualifyOrganPage = (data = {}) => {
  return bktRequest({url: 'train/track/auth/qualify/organ/page', data});
}