/**
 * 临保任务
 */
import { request } from "../utils/request";
//saas临保任务选择共享企业
export function getComListByProvince(data) {
  return request("/enterprise/company/com-base-info/get-com-list-by-province", {
    method: "POST",
    data: data || {}
  });
}
//保存临保任务
export function saveTempTask(data) {
  return request("/task/tempTask/save-temp-task", {
    method: "POST",
    data: data || {}
  });
}
//获取发布临保任务列表（发布企业）
export function getReleaseTempTaskList(data) {
  return request("/task/tempTask/get-release-temp-task-list", {
    method: "POST",
    data: data || {}
  });
}
//获取共享临保任务列表
export function getShareTempTaskList(data) {
  return request("/task/tempTask/get-share-temp-task-list", {
    method: "POST",
    data: data || {}
  });
}
//获取临保任务详情
export function getTempTaskDetail(data) {
  return request("/task/tempTask/get-temp-task-detail", {
    method: "POST",
    data: data || {}
  });
}
//任务参与人员列表
export function getTaskPerList(data) {
  return request("/task/tempTask/per/get-task-per-list", {
    method: "POST",
    data: data || {}
  });
}
//查询任务负责人信息
export function getChargePerInfo(data) {
  return request("/task/tempTask/get-charge-per-info", {
    method: "POST",
    data: data || {}
  });
}
//保存任务负责人
export function saveChargePer(data) {
  return request("/task/tempTask/save-charge-per", {
    method: "POST",
    data: data || {}
  });
}
//新增任务人员
export function addTempTaskPer(data) {
  return request("/task/tempTask/per/add-task-per", {
    method: "POST",
    data: data || {}
  });
}
//移除任务人员
export function removeTempTaskPer(data) {
  return request("/task/tempTask/per/remove-task-per", {
    method: "POST",
    data: data || {}
  });
}
//获取临保任务企业列表
export function getTempTaskComList(data) {
  return request("/task/tempTask/get-temp-task-com-list", {
    method: "POST",
    data: data || {}
  });
}
//获取考勤地址列表
export function getAttendAddressList(data) {
  return request("/task/tempTask/attend-address/get-attend-address-list", {
    method: "POST",
    data: data || {}
  });
}
//获取考勤地址列表
export function deleteAttendAddress(data) {
  return request("/task/tempTask/attend-address/delete-attend-address", {
    method: "POST",
    data: data || {}
  });
}
//保存考勤地址
export function saveAttendAddress(data) {
  return request("/task/tempTask/attend-address/save-attend-address", {
    method: "POST",
    data: data || {}
  });
}
//获取活动列表
export function getActivityList(data) {
  return request("/task/tempTask/get-activity-list", {
    method: "POST",
    data: data || {}
  });
}
//取消临保任务（只有未开始的任务才能取消）
export function cancelTempTask(data) {
  return request("/task/tempTask/cancel-temp-task", {
    method: "POST",
    data: data || {}
  });
}
//结束临保任务（只有进行中的任务才可以结束）
export function endTempTask(data) {
  return request("/task/tempTask/end-temp-task", {
    method: "POST",
    data: data || {}
  });
}
//结束临保任务（只有进行中的任务才可以结束）
export function syncTempTask(data) {
  return request("/task/tempTask/sync-temp-task", {
    method: "POST",
    data: data || {}
  });
}