import { request } from '../utils/request';

/**********************************************驻勤管理******************************************/

/**
 * 任务-出勤设置/编辑-获取第二步详情
 * @author Xyz
 */
export function taskGetStepTwoDetail(data) {
  return request('/task/get-step-two-detail', {
    method: 'GET',
    data
  });
}

/**
 * 任务-出勤设置/编辑-第二步新增或修改
 * @author Xyz
 */
export function taskSaveStepTwoDetail(data) {
  return request('/task/save-step-two-detail', {
    method: 'POST',
    data
  });
}

/**
 * 任务-出勤设置-删除地址详情
 * @author Xyz
 */
export function taskDeleteAddress(data) {
  return request('/task/delete-address', {
    method: 'POST',
    data
  });
}

/**
 * 任务-删除周期排班制
 * @author Xyz
 */
export function taskDeleteSchedulCycle(data) {
  return request('/task/delete-schedul-cycle', {
    method: 'POST',
    data
  });
}

/**
 * 任务-校验周期班次是否冲突,周期性排版设置。（排班制）
 * @author Xyz
 */
export function taskComTaskPerShiftValidateScheduleCycle(data) {
  return request('/task/com-task-per-shift/validate-schedule-cycle', {
    method: 'POST',
    data
  });
}

/****************************************任务-基本信息******************************************************* */
/**
 * 任务-任务列表-分页查询
 * @author CXL
 */
export function taskManagementList(data, testUrl) {
  return request(
    '/task/page-task-list',
    {
      method: 'POST',
      data: data || {}
    },
    testUrl
  );
}
export function addComTaskAttendAddress(data, testUrl) {
  return request(
    '/task/add-com-task-attend-address',
    {
      method: 'POST',
      data: data || {}
    },
    testUrl
  );
}

/**
 * 任务-创建任务-所属类型
 * @author CXL
 */
export function taskGetIndustriesList(data) {
  return request('/task/get-industries-list', {
    method: 'POST',
    data: data || {}
  });
}

/**
 * 任务-任务列表-删除任务
 * @author CXL
 */
// export function taskDeleteTaskById(data) {
//   return request('/task/delete-task-by-id', {
//     method: 'POST',
//     data: data || {}
//   });
// }

/**
 * 任务管理-删除未生效任务
 */
export function taskDeleteTask(data) {
  return request('/task/delete-task', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 任务管理-删除任务（进行中-->结束）
 * @author XYZ
 */
// export function taskDoneTask(data) {
//   return request('/task/done-task', {
//     method: 'POST',
//     data: data || {}
//   });
// }
/**
 * 任务管理-删除任务（未开始-->取消）
 * @author XYZ
 */
// export function taskCancelTask(data) {
//   return request('/task/cancel-task', {
//     method: 'POST',
//     data: data || {}
//   });
// }

/**
 * 任务-创建任务-获取服务类型
 * @author CXL
 */
// export function taskGetServerTypeList(data) {
//   return request('/task/get-server-type-list', {
//     method: 'POST',
//     data: data || {}
//   });
// }

/**
 * 任务-创建任务-任务信息详情
 * @author CXL
 */
export function taskGetTaskById(data) {
  return request('/task/get-task-by-id', {
    method: 'POST',
    data: data || {}
  });
}

//新增
/**
 * 任务-创建任务-保存任务第一步
 * @author CXL
 */
export function taskSaveStepOneDetail(data) {
  return request('/task/save-step-one-detail', {
    method: 'POST',
    data: data || {}
  });
}

//新增
/**
 * 获取所有大小任务类型树形
 * @author XYZ
 */
// export function taskTreeTaskType(data) {
//   return request('/task/tree-tasktype', {
//     method: 'GET',
//     data: data || {}
//   });
// }

/**
 * 任务-创建任务-获取第一步详情
 * @author CXL
 */
export function taskGetStepOneDetail(data) {
  return request('/task/get-step-one-detail', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 任务-发布设置-第三步新增修改
 * @author CXL
 */

export function taskSaveStepThreeDetail(data) {
  return request('/task/save-step-three-detail', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 任务-发布设置-第三步获取详情
 * @author CXL
 */
export function taskGetStepThreeDetail(data) {
  return request('/task/get-step-three-detail', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 任务-发布设置-第三步获取详情(改写)
 * @author CXL
 */
export function taskGetThreePer(data) {
  return request('/task/get-task-per', {
    method: 'GET',
    data: data || {}
  });
}

/**
 * 任务-发布设置-获取任务未进行投保人员列
 * @author CXL
 */
export function getTaskGetTaskUnInsPerInfoList(data) {
  return request('/task/get-task-un-ins-per-info-list', {
    method: 'POST',
    data: data || {}
  });
}

/**
 * 任务-发布设置-获取任务冲突投保人员列
 * @author CXL
 */
export function taskGetTaskConflictPerInfoList(data) {
  return request('/task/get-task-conflict-per-info-list', {
    method: 'POST',
    data: data || {}
  });
}
//获取历史任务成员列表
export function getTaskPerRecord(data) {
  return request('/task/get-task-per-record', {
    method: 'POST',
    data: data || {}
  });
}
//延长任务
export function extentTask(data) {
  return request('/task/extent-task', {
    method: 'POST',
    data: data || {}
  });
}
//终止任务
export function endTask(data) {
  return request('/task/end-task', {
    method: 'POST',
    data: data || {}
  });
}
//保安人员驻勤点信息分页查询
export function pagePerTaskInfo(data) {
  return request('/system/per-base-info/page-per-task-info', {
    method: 'POST',
    data: data || {}
  });
}
//获取未排班班次列表
export function getNoSchedulShiftList(data) {
  return request('/task/shift/get-no-schedul-shift-list', {
    method: 'GET',
    data: data || {}
  });
}
//删除驻勤班次关联
export function deleteTaskShift(data) {
  return request('/task/shift/delete-task-shift', {
    method: 'POST',
    data: data || {}
  });
}