/**
 * 华为云会议的接口
 */
import { request } from "../utils/request";

//获取企业华为云会议映射(获取有没有会议权限)
export function getComHuaweiMeet(data) {
  return request("/system/com-huawei-meet-match/get-com-huawei-meet", {
    method: "POST",
    data: data || {}
  });
}
//登录鉴权
export function getHuaweiAccesstoken(data) {
  return request("/system/per-huawei-meet-match/get-huawei-accesstoken", {
    method: "POST",
    data: data || {}
  });
}
//添加用户
export function addUser(data) {
  return request("/system/per-huawei-meet-match/add-user", {
    method: "POST",
    data: data || {}
  });
}
//获取企业华为云会议管理资源
export function getHuaweiManageResource(data) {
  return request("/system/com-huawei-meet-match/get-huawei-manage-resource", {
    method: "POST",
    data: data || {}
  });
}
//设置监管机构负责人
export function setRegulatorMeetCharge(data) {
  return request("/system/per-huawei-meet-match/set-regulator-meet-charge", {
    method: "POST",
    data: data || {}
  });
}
//取消监管机构负责人
export function cancelRegulatorMeetCharge(data) {
  return request("/system/per-huawei-meet-match/cancel-regulator-meet-charge", {
    method: "POST",
    data: data || {}
  });
}
//华为云会议人员列表信息查询
export function pageForHuaweiMeetPerInfo(data) {
  return request("/system/per-base-info/page-for-huawei-meet-per-info", {
    method: "POST",
    data: data || {}
  });
}
//批量删除用户
export function batchDeleteUser(data) {
  return request("/system/per-huawei-meet-match/batch-delete-user", {
    method: "POST",
    data: data || {}
  });
}

/**获取华为会议选人公共部门树的人员列表*/
export function getHuaweiDepartPersonList(data) {
  return request('/system/com-depart/get-huawei-depart-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**公共选人的华为会议选人的接口(关键字查询)*/
export function getHuaweiPerListByKeyword(data) {
  return request('/system/com-depart/get-huawei-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}
/**创建会议时，发送短信*/
export function sendHuaweiMeetSms(data) {
  return request('/system/per-huawei-meet-match/send-huawei-meet-sms', {
    method: 'POST',
    data: data || {}
  });
}
/**创建会议*/
export function buildHuaweiMeet(data) {
  return request('/system/com-huawei-meet-match/build-huawei-meet', {
    method: 'POST',
    data: data || {}
  });
}
/**用户查询自己的信息*/
export function getHuaweiUserDetail(data) {
  return request('/system/com-huawei-meet-match/get-huawei-user-detail', {
    method: 'POST',
    data: data || {}
  });
}
/**获取购买产品列表*/
export function getProductList(data) {
  return request('/transaction/product/get-product-list', {
    method: 'POST',
    data: data || {}
  });
}
/**优惠卷校验*/
export function checkProductCoupon(data) {
  return request('/transaction/product/coupon/check-product-coupon', {
    method: 'POST',
    data: data || {}
  });
}
/**提交订单*/
export function saveOrder(data) {
  return request('/transaction/order/com-order/save-order', {
    method: 'POST',
    data: data || {}
  });
}
/**发送支付验证码*/
export function sendPayVerifycode(data) {
  return request('/task/com/wallet-payment/send-pay-verifycode', {
    method: 'POST',
    data: data || {}
  });
}
/**支付校验*/
export function checkOrder(data) {
  return request('/transaction/order/com-order/check-order', {
    method: 'POST',
    data: data || {}
  });
}
/**获取订单列表*/
export function getOrderList(data) {
  return request('/transaction/order/com-order/get-order-list', {
    method: 'POST',
    data: data || {}
  });
}
/**获取支付手机号*/
export function getPayPhone(data) {
  return request('/task/com/wallet-payment/get-pay-phone', {
    method: 'POST',
    data: data || {}
  });
}
/**获取录屏会议列表*/
export function getTranscribeFileList(data) {
  return request('/system/per-huawei-meet-match/get-transcribe-file-list', {
    method: 'POST',
    data: data || {}
  });
}
/**删除录屏会议数据*/
export function batchDeleteTranscribeFile(data) {
  return request('/system/per-huawei-meet-match/batch-delete-transcribe-file', {
    method: 'POST',
    data: data || {}
  });
}
/**获取企业华为专用云会议室列表*/
export function getHuaweiCloudMeetRoomList(data) {
  return request('/system/com-huawei-meet-match/get-huawei-cloud-meet-room-list', {
    method: 'POST',
    data: data || {}
  });
}
/**修改用户云会议室*/
export function updateHuaweiCloudMemberVmr(data) {
  return request('/system/com-huawei-meet-match/update-huawei-cloud-member-vmr', {
    method: 'POST',
    data: data || {}
  });
}
/**分配专用云会议室*/
export function assignToMember(data) {
  return request('/system/com-huawei-meet-match/assign-to-member', {
    method: 'POST',
    data: data || {}
  });
}
/**回收专用云会议室*/
export function recycleFromMember(data) {
  return request('/system/com-huawei-meet-match/recycle-from-member', {
    method: 'POST',
    data: data || {}
  });
}
/**分页查询用户云会议室（个人的）*/
export function getHuaweiCloudMemberVmrList(data) {
  return request('/system/com-huawei-meet-match/get-huawei-cloud-member-vmr-list', {
    method: 'POST',
    data: data || {}
  });
}
/**查询会议列表*/
export function getHuaweiMeetList(data) {
  return request('/system/per-huawei-meet-match/get-huawei-meet-list', {
    method: 'POST',
    data: data || {}
  });
}
/**查询会议详情*/
export function getHuaweiMeetDetail(data) {
  return request('/system/per-huawei-meet-match/get-huawei-meet-detail', {
    method: 'POST',
    data: data || {}
  });
}