import { request, noLoginRequest } from '../utils/request';

/**********************************************企业初始化******************************************/

/**
 * 查看报表详情
 * @author Xyz
 */
export function systemComInitprocessList(data) {
  return request('/system/com-initprocess/list', {
    method: 'POST',
    data
  });
}
/**
 * 获取区域菜单按钮权限
 * @author Lyq
 */
export function getRegionMenuButton(data) {
  return request('/public/common/get-region-menu-button', {
    method: 'POST',
    data
  });
}
/**
 * 初始化密码修改  --- 修改密码
 * @author Xyz
 */
export function systemPerAccountInfoUpdatePassword(data) {
  return noLoginRequest('/system/per-account-info/update-password', {
    method: 'POST',
    data
  });
}

/**
 * 初始化密码修改(需要access_token)  --- 修改密码
 * @author Xyz
 */
export function systemPerAccountInfoUpdatePasswordRequest(data) {
  return request('/system/per-account-info/update-password', {
    method: 'POST',
    data
  });
}

/**
 * 初始化密码修改(需要access_token)  --- 修改密码，保存提交，因广西需求，使用此接口
 * @author Xyz
 */
export function systemPerAccountInfoUpdatePasswordRequest2(data) {
  return request('/system/per-account-info/update-password2', {
    method: 'POST',
    data
  });
}

/**
 * 初始化获取验证码，使用/system/plat-news/send-verification-code2,因广西需求，使用此接口获取手机验证码
 * @author Orm
 */
export function systemPlatNewsSendVerificationCode2(data) {
  return request('/system/plat-news/send-verification-code2', {
    method: 'POST',
    data
  });
}

/**
 *  部门新增功能
 * @author Xyz
 */
export function systemComDepartSave(data) {
  return request('/system/com-depart/save', {
    method: 'POST',
    data
  });
}

/**
 *  部门新增功能
 * @author Xyz
 */
export function systemComDepartBatchInsertDepart(data) {
  return request('/system/com-depart/batch-insert-depart', {
    method: 'POST',
    data
  });
}

/**
 *  获得行业信息配置字段
 * @author Xyz
 */
export function systemComDepartDelete(data) {
  return request('/system/com-depart/delete', {
    method: 'GET',
    data
  });
}

/**
 *  批量导入组织架构
 * @author Xyz
 */
export function systemComDepartImportDepart(data) {
  return request('/system/com-depart/import-depart', {
    method: 'POST',
    data
  });
}

/**
 *  批量操作角色组
 * @author Xyz
 */
export function systemComRoleRroupBatchInsertRoleGroup(data) {
  return request('/system/com-role-group/batch-insert-role-group', {
    method: 'POST',
    data
  });
}

/**
 *  批量操作角色组
 * @author Xyz
 */
export function systemComRoleBatchInsertRole(data) {
  return request('/system/com-role/batch-insert-role', {
    method: 'POST',
    data
  });
}

/**
 *  批量操作角色组
 * @author Xyz
 */
export function systemSysMenuAllMenuTree(data) {
  return request('/system/sys-menu/all-menu-tree', {
    method: 'GET',
    data
  });
}

/**
 *  批量操作角色组
 * @author Xyz
 */
export function systemComRoleAllotSave(data) {
  return request('/system/com-role-allot/save', {
    method: 'POST',
    data
  });
}

/**
 *  批量操作角色组
 * @author Xyz
 */
export function systemComRoleAllotGetChildMenuByRoleId(data) {
  return request('/system/com-role-allot/getChildMenuByRoleId', {
    method: 'GET',
    data
  });
}

/**
 *  获取角色数据权限
 * @author Xyz
 */
export function systemComRoleAllotGetDataAuthority(data) {
  return request('/system/com-role-allot/get-data-authority', {
    method: 'GET',
    data
  });
}

/**
 *  新增角色数据权限
 * @author Xyz
 */
export function systemComRoleAllotSaveDataAuthority(data) {
  return request('/system/com-role-allot/save-data-authority', {
    method: 'POST',
    data
  });
}

/**
 * 保险信息，直接下一步，设置完善保险已初始化步骤，直接完成此步骤
 * @author Xyz
 */
export function enterpriseCompanyComAuthInfoUpdateComplete(data) {
  return request('/enterprise/company/com-auth-info/update-complete', {
    method: 'POST',
    data
  });
}

/**
 * 完善企业保险（线下）
 * @author Xyz
 */
export function enterpriseInsComInsUpdateProcessType(data) {
  return request('/enterprise/ins/com-ins/update-process-type', {
    method: 'POST',
    data
  });
}

/**
 * 校验企业管理员手机号是否存在
 * @author zhx
 */
export function systemPerBaseInfoCheckAdmin(data) {
  return request('/system/per-base-info/check-admin', {
    method: 'GET',
    data
  });
}

/**
 * 校验用户手机号是否存在
 * @author zhx
 */
export function systemPerBaseInfoCheckPer(data) {
  return noLoginRequest('/system/per-base-info/check-per', {
    method: 'GET',
    data
  });
}
/**
 * 查询手机号码是否存在用户账号---忘记密码-发送验证码前调用
 * @author zhx
 */
export function systemPerAccountInfoCheckUserAccountExist(data) {
  return noLoginRequest('/system/per-account-info/check-user-account-exist', {
    method: 'GET',
    data
  });
}
/**
 * 个人修改密码
 * @author zhx
 */
export function systemPerBaseInfoUpdatePassWord(data) {
  return noLoginRequest('/system/per-base-info/update-pass-word', {
    method: 'POST',
    data
  });
}

/**
 *  批量操作角色组
 * @author Xyz
 */
export function systemComRoleAppOperationGetRoleAppOperation(data) {
  return request('/system/com-role-app-operation/get-role-app-operation', {
    method: 'GET',
    data
  });
}
