/**
 * 防空指挥
 */
import { request } from "../utils/request";
//防控指挥获取驻勤点列表
export function getComTaskList(data) {
  return request('/task/get-com-task-list', {
    method: 'POST',
    data: data || {}
  });
}
//防控指挥获取临保任务列表
export function getComTempTaskList(data) {
  return request('/task/tempTask/get-com-temp-task-list', {
    method: 'POST',
    data: data || {}
  });
}
//防控指挥获取任务人员位置
export function getComTaskPerLocation(data) {
  return request('/task/get-com-task-per-location', {
    method: 'POST',
    data: data || {}
  });
}
//防控指挥获取临保任务人员位置
export function getComTempTaskPerLocation(data) {
  return request('/task/tempTask/get-com-temp-task-per-location', {
    method: 'POST',
    data: data || {}
  });
}
//获取该公司对应有的驻勤点类型
export function getComTaskStationType(data) {
  return request('/task/get-com-task-station-type', {
    method: 'POST',
    data: data || {}
  });
}
//获取公司临保任务驻勤点类型
export function getComTempTaskStationType(data) {
  return request('/task/tempTask/get-com-temp-task-station-type', {
    method: 'POST',
    data: data || {}
  });
}
//分页查询调度记录
export function findComVideoRoomPage(data) {
  return request("/system/per-account-info/find-com-video-room-page", {
    method: "POST",
    data: data || {},
  });
}

//调度记录详情
export function getVideoRoomDetail(data) {
  return request("/system/per-account-info/get-video-room-detail", {
    method: "POST",
    data: data || {},
  });
}

//设置房间结束时间
export function updateRoomEndTime(data) {
  return request("/system/per-account-info/update-room-end-time", {
    method: "POST",
    data: data || {},
  });
}

/*********************以下是公安的接口（融合调度指挥平台）****************************/
//公安获取保安行业公司
export function policeGetComList(data) {
  return request("/enterprise/company/com-base-info/police-get-com-list", {
    method: "POST",
    data: data || {},
  });
}

//公安通过条件查询人员位置列表
export function policeGetPerLocationByKeyword(data) {
  return request("/system/prevent-command/police-get-per-location-by-keyword", {
    method: "POST",
    data: data || {},
  });
}

//公安获取任务驻勤点类型
export function policeGetTaskStationType(data) {
  return request("/task/police-get-task-station-type", {
    method: "POST",
    data: data || {},
  });
}

//公安防控指挥获取驻勤点列表
export function policeGetTaskList(data) {
  return request("/task/police-get-task-list", {
    method: "POST",
    data: data || {},
  });
}

//公安防控指挥获取驻勤点列表
export function policeGetPerLocationPageList(data) {
  return request("/system/prevent-command/police-get-per-location-page-list", {
    method: "POST",
    data: data || {},
  });
}

//获取人员信息列表（目前用于公安融合调度）
export function getPerInfoList(data) {
  return request("/enterprise/per-base-info/get-per-info-list", {
    method: "POST",
    data: data || {},
  });
}

//公安防控指挥获取任务位置列表
export function policeGetTaskLocationList(data) {
  return request("/task/police-get-task-location-list", {
    method: "POST",
    data: data || {},
  });
}

//公安防控指挥获取任务信息
export function policeGetTaskById(data) {
  return request("/task/police-get-task-by-id", {
    method: "POST",
    data: data || {},
  });
}