import { request } from '../utils/request';

/**********************************************审批管理相关******************************************/

/**
 * 审批-获取审批类型
 * @author Wfh
 */
export function getApprovalTypeList(data) {
  return request("/approve/web/approve-temp/get-approve-temp-list", {
    method: "POST",
    data
  });
}

/**
 * 审批-修改审批模板状态
 * @author Wfh
 */
export function changeApprovalTempStatus(data) {
  return request("/approve/web/approve-temp/update-approve-temp-action-by-approve-temp-Id", {
    method: "POST",
    data
  });
}

/**
 * 审批-获取审批列表
 * @author CYQ
 */
export function getApprovalList(data) {
  return request("/approve/web/approve-apply/get-approve-apply-list", {
    // return request("/approve/web/approve-temp/get-approve-temp-list", {
    method: "POST",
    data
  });
}

/**
 * 审批-查看考勤请假详情
 * @author CYQ
 */
export function getApproveAttendLeaveApply(data) {
  return request("/approve/web/approve-attend-leave-apply/get-approve-attend-leave-apply-by-id", {
    method: "POST",
    data
  });
}

/**
 * 审批-查看加班申请详情
 * @author CYQ
 */
export function getApproveAttendOvertimeApply(data) {
  return request("/approve/web/approve-attend-overtime-apply/get-approve-attend-overtime-apply-by-id", {
    method: "POST",
    data
  });
}
/**
 * 审批-查看任务代班详情
 * @author LYQ
 */
export function getTaskAdjustDetail(data) {
  return request("/approve/web/approve-task-adjust-apply/get-task-adjust-detail", {
    method: "POST",
    data
  });
}

/**
 * 审批-查看考勤补卡详情
 * @author CYQ
 */
export function getApproveAttendRemedyApply(data) {
  return request("/approve/web/approve-attend-remedy-apply/get-approve-attend-remedy-apply-by-id", {
    method: "POST",
    data
  });
}

/**
 * 审批-查看任务请假详情
 * @author CYQ
 */
export function getApproveTaskLeaveApply(data) {
  return request("/approve/web/approve-task-leave-apply/get-approve-task-leave-apply-by-id", {
    method: "POST",
    data
  });
}

/**
 * 审批-查看任务补卡详情
 * @author CYQ
 */
export function getApproveTaskRemedyApply(data) {
  return request("/approve/web/approve-task-remedy-apply/get-approve-task-remedy-apply-by-id", {
    method: "POST",
    data
  });
}