import { request, saasDownloadBlob } from "../utils/request";

// 获取企业未开通联名卡人员列表
export function getNoOpenJointlyPerList(data) {
  return request("/task/per-jointly-card/get-no-open-jointly-per-list", {
    method: "GET",
    data: data || {}
  });
}

// 获取企业已开通联名卡人员列表
export function getOpenJointlyPerList(data) {
  return request("/task/per-jointly-card/get-open-jointly-per-list", {
    method: "GET",
    data: data || {}
  });
}

// 获取企业人员开通联名卡情况----获取tab栏的数量
export function getPerOpenJointlyInfo(data) {
  return request("/task/per-jointly-card/get-per-open-jointly-info", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 任务列表-创建任务第一个步骤
 * @author lyq
 */

export function taskPerJointlyCardBatchNotice(data) {
  return request("/task/per-jointly-card/batch-notice", {
    method: "POST",
    data: data || {}
  });
}



/* 薪酬管理--对接渤海银行 */


/**
 * 创建企业渤海薪资代发单
 * @author lyq
 */

export function taskComBhGrantSaveComBhGrantInfo(data) {
  return request("/task/com/bh/grant/save-com-bh-grant-info", {
    method: "POST",
    data: data || {}
  });
}

/**
 * 获取企业渤海薪资代发单列表
 * @author lyq
 */

export function taskComBhGrantPageComBhGrantInfoList(data) {
  return request("/task/com/bh/grant/page-com-bh-grant-info-list", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 删除企业渤海薪资代发单
 * @author lyq
 */

export function taskComBhGrantDeleteComBhGrantInfo(data) {
  return request("/task/com/bh/grant/delete-com-bh-grant-info", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 根据id获取企业渤海薪资代发
 * @author lyq
 */
export function taskComBhGrantGetComBhGrantInfoById(data) {
  return request("/task/com/bh/grant/get-com-bh-grant-info-by-id", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 同步渤海发放结果
 * @author cyq
 */
export function taskComBhGrantSyncBhGrantResul(data) {
  return request("/task/com/bh/grant/sync-bh-grant-result", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 获取渤海银行回单文件URL
 * @author cyq
 */
export function taskComBhGrantGetBhBankReceiptFileUrl(data) {
  return request("/task/com/bh/grant/get-bh-bank-receipt-file-url", {
    method: "POST",
    data: data || {}
  });
}

/**
 * 导出薪资代发模板
 * @author lyq
 */
export function taskComBhGrantExportOfflineGrantTemp(data = {}) {
  return saasDownloadBlob('/task/com/bh/grant/export-offline-grant-temp', data);
}
/**
 * 导出渤海薪资银行卡代发模板
 * @author cyq
 */
export function taskComBhGrantExportBankGrantTemp(data = {}) {
  return saasDownloadBlob('/task/com/bh/grant/export-offline-bank-grant-temp', data);
}
/**
 * 导入薪资代发模板
 * @author lyq
 */
export function taskComBhGrantImportOfflineGrantTemp(data, loading = true) {
  return request("/task/com/bh/grant/import-offline-grant-temp", {
    method: "POST",
    data: data || {}
  }, null, false, loading);
}

/**
 * 导入渤海薪资银行卡代发模板
 * @author cyq
 */
export function taskComBhGrantImportOfflineBankGrantTemp(data, loading = true) {
  return request("/task/com/bh/grant/import-offline-bank-grant-temp", {
    method: "POST",
    data: data || {}
  }, null, false, loading);
}


/**
 * 获取企业渤海薪资发放明细
 * @author lyq
 */
export function taskComBhGrantPageComBhGrantDetailList(data) {
  return request("/task/com/bh/grant/page-com-bh-grant-detail-list", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 删除企业渤海薪资代明细
 * @author lyq
 */
export function taskComBhGrantDeleteComBhGrantDetailById(data) {
  return request("/task/com/bh/grant/delete-com-bh-grant-detail-by-id", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 查询企业渤海发放操作记录列表
 * @author lyq
 */
export function taskComBhGrantGetBhGrantOperRecordList(data) {
  return request("/task/com/bh/grant/get-bh-grant-oper-record-list", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 提交发放申请
 * @author lyq
 */
export function taskComBhGrantCommitGrantApply(data) {
  return request("/task/com/bh/grant/commit-grant-apply", {
    method: "POST",
    data: data || {}
  });
};

/**
 * 获取企业渤海账户信息
 * @author lyq
 */
export function taskComBhAccountGetComBhAccount(data) {
  return request("/task/com/bh/account/get-com-bh-account", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 获取企业渤海账户信息
 * @author lyq
 */
export function taskComBhAccountSendOpenAccountVerifyCode(data) {
  return request("/task/com/bh/account/send-open-account-verify-code", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 获取渤海账户余额
 * @author lyq
 */
export function taskComBhAccountGetComBhAccountAmount(data) {
  return request("/task/com/bh/account/get-com-bh-account-amount", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 渤海银行开户
 * @author lyq
 */
export function taskComBhAccountSaveComBhAccount(data) {
  return request("/task/com/bh/account/save-com-bh-account", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 修改企业渤海账户
 * @author cyq
 */
export function taskComBhAccountUpdateComBhAccount(data) {
  return request("/task/com/bh/account/update-com-bh-account", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 渤海银行账户提现
 * @author cyq
 */
export function taskComBhAccountWithdrawa(data) {
  return request("/task/com/bh/account/bh-account-withdrawa", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 渤海银行发送验证码
 * @author cyq
 */
export function BhAccountSendVerifyCode(data) {
  return request("/task/com/bh/account/send-verify-code", {
    method: "POST",
    data: data || {}
  });
};
/**
 * 渤海银行修改手机
 * @author cyq
 */
export function BhAccountUpdateMobilephone(data) {
  return request("/task/com/bh/account/update-mobilephone", {
    method: "POST",
    data: data || {}
  },null,true);
};
/**
 * 获取账户历史明细列表
 * @author cyq
 */
export function getAccountHistoryDetailList(data) {
  return request("/task/com/bh/account/get-account-history-detail-list", {
    method: "POST",
    data: data || {}
  });
};
