import { request, noLoginRequest } from '../utils/request';

/**********************************************薪酬管理相关******************************************/

/**
 * 核算薪资
 * @author ORM
 */
export function taskComSalaryCalSalary(data) {
  return request('/task/com/salary/cal-salary', {
    method: 'POST',
    data
  });
}

/**
 * 人员月度工资分页查询
 * @author ORM
 */
export function taskComSalaryPageForPersalary(data) {
  return request('/task/com/salary/page-for-per-salary', {
    method: 'GET',
    data
  });
}

/**
 * 企业薪酬模板列表分页查询
 * @author ORM
 */
export function taskSalaryTempPageComSalaryTemp(data) {
  return request('/task/salary/temp/page-com-salary-temp', {
    method: 'GET',
    data
  });
}

/**
 * 获取薪酬项目配置
 * @author ORM
 */
export function taskSalaryTempGetConfigSalaryType(data) {
  return noLoginRequest('/task/salary/temp/get-config-salary-type', {
    method: 'GET',
    data
  });
}

/**
 * 保存企业薪酬模板
 * @author ORM
 */
export function taskSalaryTempSaveComSalaryTemp(data) {
  return request('/task/salary/temp/save-com-salary-temp', {
    method: 'POST',
    data
  });
}

/**
 * 复制企业薪酬模板
 * @author ORM
 */
export function taskSalaryTempCopyComSalaryTemp(data) {
  return request('/task/salary/temp/copy-com-salary-temp', {
    method: 'POST',
    data
  });
}

/**
 * 删除企业薪酬模板
 * @author ORM
 */
export function taskSalaryTempDelComSalaryTemp(data) {
  return request('/task/salary/temp/del-com-salary-temp', {
    method: 'POST',
    data
  });
}

/**
 * 查询企业薪酬模板详情
 * @author ORM
 */
export function taskSalaryTempGetComSalaryTempInfo(data) {
  return request('/task/salary/temp/get-com-salary-temp-info', {
    method: 'GET',
    data
  });
}

/**
 * 批量核算工资条
 * @author ORM
 */
export function taskComSalaryBatchAccountSalary(data) {
  return request('/task/com/salary/batch-account-salary', {
    method: 'POST',
    data
  });
}

/**
 * 查看工资条详情
 * @author ORM
 */
export function taskComSalarySalaryDetail(data) {
  return request('/task/com/salary/salary-detail', {
    method: 'POST',
    data
  });
}

/**
 * 修改工资条详情
 * @author ORM
 */
export function taskComSalaryUpdateSalary(data) {
  return request('/task/com/salary/update-salary', {
    method: 'POST',
    data
  });
}

/**
 * 校验薪资模板人员
 * @author ORM
 */
export function taskSalaryTempCheckSalaryTempPer(data) {
  return request('/task/salary/temp/check-salary-temp-per', {
    method: 'POST',
    data
  });
}

/**
 * 查看当前月是否核算
 * @author ORM
 */
export function taskComSalaryCheckIsAccount(data) {
  return request('/task/com/salary/check-is-account', {
    method: 'GET',
    data
  });
}
/**
 * 删除薪酬明细项
 * @author ORM
 */
export function taskComSalaryDeleteSalaryGrant(data) {
  return request('/task/com/salary/delete-salary-grant', {
    method: 'POST',
    data
  });
}
/**
 * 校验企业是否完成了薪酬同步初始化
 * @author Lyq
 */
export function comSalarySyncInitCheckIsInit(data) {
  return request('/enterprise/company/com-salary-sync-init/check-is-init', {
    method: 'POST',
    data
  });
}
/**
 * 校验企业是否完成了薪酬同步初始化
 * @author Lyq
 */
export function saveComSalarySyncInit(data) {
  return request('/enterprise/company/com-salary-sync-init/save-com-salary-sync-init', {
    method: 'POST',
    data
  });
}
/**
 * 校验等级证新增报名里的合同校验【等级证】
 * @author 
 */
export function contractsCheck(data) {
  return request('/enterprise/com-contract/contractsCheck', {
    method: 'POST',
    data
  },null,true);
}