import { request } from "../utils/request";

/***************************人事招聘**************************************************** */
/**
 * 人事招聘-获取收到的简历
 * @author Orm
 */
export function enterprisePerResumePage(data) {
  return request("/enterprise/per-resume/page", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-收到简历备注
 * @author Orm
 */
export function enterprisePerSendResumeRemark(data) {
  return request("/enterprise/per-send-resume/remark", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 人事招聘-收到简历备注
 * @author Orm
 */
export function enterprisePerSendGetRemark(data) {
  return request("/enterprise/per-send-resume/get", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-收藏简历备注
 * @author Orm
 */
export function enterpriseResumeCollectChangeRemark(data) {
  return request("/enterprise/resume-collect/change-remark", {
    method: "POST",
    data: data || {}
  });
}

/**
 * 人事招聘-获取收藏简历备注
 * @author Wxz
 */
export function enterpriseResumeCollectGetRemark(data) {
  return request("/enterprise/resume-collect/get", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-收藏简历删除
 * @author Orm
 */
export function enterpriseResumeCollectDelete(data) {
  return request("/enterprise/resume-collect/delete", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-获取收藏的简历
 * @author jcw
 */
export function enterpriseResumeCollectPage(data) {
  return request("/enterprise/resume-collect/page", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-收到简历详情
 * @author Orm
 */
export function enterprisePerResumeResumeDetails(data) {
  return request("/enterprise/per-resume/resume-details", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-收藏简历详情
 * @author Orm
 */
export function enterpriseResumeCollectResumeDetails(data) {
  return request("/enterprise/resume-collect/resume-details", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-获取人才搜索分页
 * @author zjh
 */
export function enterprisePerResumeForSearchPage(data) {
  return request("/enterprise/per-resume/page-for-search", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 人事招聘-收藏简历
 * @author zjh
 */
export function enterpriseSaveResumeFromSearchPage(data) {
  return request("/enterprise/resume-collect/save", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 人事招聘-招聘分页
 * @author zjh
 */
export function enterpriseComJobPage(data) {
  return request("/enterprise/com-job/page", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人事招聘-招聘批量删除
 * @author zjh
 */
export function enterpriseDeleteComJob(data) {
  return request("/enterprise/com-job/delete", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 人事招聘-招聘批量状态开关
 * @author zjh
 */
export function enterpriseUpdateReleaseStatusComJob(data) {
  return request("/enterprise/com-job/update/releasestatus-by-ids", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 人事招聘-招聘批量刷新发布时间
 * @author zjh
 */
export function enterpriseUpdateReleaseTimeComJob(data) {
  return request("/enterprise/com-job/update/releasetime-by-ids", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 人事招聘-招聘职位修改
 * @author zjh
 */
export function enterpriseUpdateComJob(data) {
  return request("/enterprise/com-job/update", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 人事招聘-招聘职位新增
 * @author zjh
 */
export function enterpriseSaveComJob(data) {
  return request("/enterprise/com-job/save", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 人事招聘-招聘职位获取信息
 * @author zjh
 */
export function enterpriseGetComJob(data) {
  return request("/enterprise/com-job/get", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 人事招聘-获取职位类型树
 * @author wxz
 */
export function enterpriseGetPositionType(data) {
  return request("/enterprise/config-position-type/get-positiontype-tree", {
    method: "GET",
    data: data || {}
  });
}

