import { stringify } from 'qs';
import * as apiTask from './apiTask'; //任务管理
import * as apiPersonnelRecruitment from './apiPersonnelRecruitment'; //人事招聘
import * as apiBusinessAddressBook from './apiBusinessAddressBook'; //企业通讯录
import {
  request,
  saasDownloadBlob,
  // loginRequest,
  noLoginRequest,
  getHostByPath
} from '../utils/request';
import * as api_kaoQinGuanLi from './api_kaoQinGuanLi'; //内勤管理
import * as api_taskbuild from './api_taskbuild'; //驻勤管理
import * as api_brachCompany from './api_brachCompany'; //总/子/分公司管理
import * as apiLoginRegister from './api_loginRegister'; //登录注册
import * as apiApproval from './api_approval'; //审批管理
import * as apiSalaryManage from './apiSalaryManage'; //薪酬管理相关
import * as apiMeeting from './api_meeting';//华为云会议
import * as apiTempTask from './api_tempTask';//临保
import * as apiCommand from './api_command';//防空指挥
// import config from '../utils/config';
// import * as requestUtil from "../utils/request.js";

// 保安员证联名卡
export * from './apiSmartCard';
//内勤管理
export const { 
  attendanceGetShiftPage,
  attendanceDeleteShiftById,
  taskAttendanceComAttendGroupAddAttendGroup,
  taskAttendanceComAttendGroupFindAttendGroupById,
  taskAttendanceComAttendGroupUpdateAttendGroup,
  taskAttendanceComAttendGroupFindAttendGroupByPerId,
  taskAttendanceComAttendGroupPageForGroup,
  taskAttendanceComAttendGroupDelete,
  taskComShiftPage,
  taskAttendanceComAttendGroupFindAttendGroupByPerIdStr,
  taskAttendanceComattendgroupfixedSave,
  taskAttendanceComattendgroupfixedGetAddTemp,
  taskAttendanceComattendgroupfixedUpdate,
  taskAttendanceComattendgroupfixedGetDetail,
  taskAttendanceComAttendGroupListAttendGroupAddress,
  taskAttendanceComAttendGroupUpdateAttendGroupAddress,
  taskAttendanceComAttendGroupAddAttendGroupAddress,
  taskComShiftDelete,
  taskComShiftGet,
  taskComShiftInsert,
  taskComShiftUpdate,
  taskAttendanceComAttendGroupInFirstStepAttendGroup,
  taskAttendanceComAttendGroupSaveFirstStepAttendGroup,
  taskAttendanceComAttendGroupInSecondStepAttendGroup,
  taskAttendanceComAttendGroupSaveSecondStepAttendGroup,
  taskAttendanceComAttendGroupInThirdStepAttendGroup,
  taskAttendanceComAttendGroupSaveThirdStepAttendGroup,
  taskAttendanceComAttendGroupCheckAttendPer,
  getdayStatisticsData,
  getmonthStatisticsData,
  getDepartmentData,
  getAttendRecordDetail,
  changeRecordDetail
} = api_kaoQinGuanLi;

//任务管理
export const {
  taskBaseInfo,
  taskManagementAddTaskStepOne,
  taskComTaskPerShiftListShift,
  taskComTaskPerShiftListPerShift,
  taskComTaskPerShiftValidateSinglePerShift,
  taskComTaskPerShiftSetSinglePerShift,
  taskComTaskPerShiftResetSinglePerShift,
  taskAttendanceAndTrackAttendanceRecord,
  taskAttendanceAndTrackTaskLog,
  taskComTaskImplAttendanceStatus,
  taskComTaskImplQueryTrack,
  taskComTaskPerShiftPagePerShift,
  taskTrackListImplement,
  taskTrackSelectTaskTrack,
  getdayStatisticsDataTask,
  getmonthStatisticsDataTask,
  getAttendRecordDetailTask,
  changeRecordDetailTask,
  relateContract,
  taskShiftAddTaskShift,
  taskShiftGetNoSetShiftList
} = apiTask;

//人事招聘
export const {
  enterprisePerResumePage,
  enterprisePerResumeResumeDetails,
  enterpriseResumeCollectPage,
  enterprisePerResumeForSearchPage,
  enterpriseSaveResumeFromSearchPage,
  enterpriseComJobPage,
  enterpriseDeleteComJob,
  enterpriseUpdateReleaseStatusComJob,
  enterpriseUpdateReleaseTimeComJob,
  enterpriseUpdateComJob,
  enterpriseSaveComJob,
  enterpriseGetComJob,
  enterprisePerSendResumeRemark,
  enterprisePerSendGetRemark,
  enterpriseResumeCollectChangeRemark,
  enterpriseResumeCollectGetRemark,
  enterpriseResumeCollectResumeDetails,
  enterpriseResumeCollectDelete,
  enterpriseGetPositionType
} = apiPersonnelRecruitment;

//企业通讯录
export const {
  enterpriseRoleUpdate,
  enterpriseRoleSave,
  enterpriseRoleGet,
  enterpriseRoleDeleteById,
  searchRoleGroup,
  systemComRoleInsertPerRole,
  searchRoleAndRoleGroupList,
  searchPerSonByRoleId,
  enterpriseRoleGroupSave,
  enterpriseRoleGroupDelete,
  searchRoleListBykeyword,
  batchesDelete,
  systemComDepartList,
  systemPerCerBaseInfoFindAll,
  systemConfigPerCerInfoFindListByPercertype,
  systemPerCerBaseInfoSave,
  systemComDepartPage,
  systemComDepartPageTreeType,
  systemComDepartUpdate,
  systemComDepartGet,
  systemPerCerBaseInfoDelete,
  systemPerCerBaseInfoFind,
  systemPerCerBaseInfoUpdate,
  // systemPerBaseInfoGetInfoByPhone,
  systemPlatNewsSendActivationMessage,
  systemComDepartUpdateLeaveDate,
  enterpriseLeaveList,
  systemPerCerBaseInfoGet,
  searchOnlyGroup,
  systemComDepartAdjustDepart,
  systemPerBaseInfoUpdateBaseInfo,
  systemPerBaseInfoSaveBaseInfo,
  systemPerBaseInfoGetPerBaseInfo,
  systemConfigPerIndustryFindListByComId,
  systemPerBaseInfoUpdateDetailedInfo,
  systemComDepartExportDepart,
  systemComDepartGetTreeDepart,
  systemComRoleFindAllRole,
  enterpriseRoleGroupUpdate,
  systemPerBaseInfoUpdateMobile,
  deletePerColorPhotoUrl,
  updatePerColorPhotoUrl
} = apiBusinessAddressBook;

const host = getHostByPath();
export { host };

//下载blob
export function enterpriseInsComInsExportErrInsPer(data = {}) {
  return saasDownloadBlob('/enterprise/ins/com-ins/export-err-ins-per', data);
}

export async function queryProjectNotice() {
  return request('/api/project/notice');
}

export async function queryActivities() {
  return request('/api/activities');
}

export async function queryRule(params) {
  return request(`/api/rule?${stringify(params)}`);
}

export async function removeRule(params) {
  return request('/api/rule', {
    method: 'POST',
    body: {
      ...params,
      method: 'delete'
    }
  });
}

export async function addRule(params) {
  return request('/api/rule', {
    method: 'POST',
    body: {
      ...params,
      method: 'post'
    }
  });
}

export async function fakeSubmitForm(params) {
  return request('/api/forms', {
    method: 'POST',
    body: params
  });
}

export async function fakeChartData() {
  return request('/api/fake_chart_data');
}

export function fakeChartData1() {
  return request('/api/fake_chart_data');
}

export async function queryTags() {
  return request('/api/tags');
}

export async function queryBasicProfile() {
  return request('/api/profile/basic');
}

export async function queryAdvancedProfile() {
  return request('/api/profile/advanced');
}

export async function queryFakeList(params) {
  return request(`/api/fake_list?${stringify(params)}`);
}

export async function fakeAccountLogin(params) {
  return request('/api/login/account', {
    method: 'POST',
    body: params
  });
}

export async function fakeMobileLogin(params) {
  return request('/api/login/mobile', {
    method: 'POST',
    body: params
  });
}

export async function fakeRegister(params) {
  return request('/api/register', {
    method: 'POST',
    body: params
  });
}

export async function queryNotices() {
  return request('/public/message/unread-message-list', {
    method: 'POST',
    data: {}
  });
}

// 获取用户登陆菜单
export function systemOauthGetUserMenus(data) {
  return request('/system/oauth/get-user-menus', {
    method: 'GET',
    data
  });
}

// 修改企业基本信息
export function updateComBaseInfoById(data) {
  return request('/enterprise/company/com-base-info/update-com-base-info', {
    method: 'POST',
    data
  });
}
// 修改企业s手机号
export function updateComLegalRepPhone(data) {
  return request('/enterprise/company/com-auth-info/update-com-legal-rep-phone', {
    method: 'POST',
    data
  });
}

//获取人员类别
export function getPerType(data) {
  return request('/public/common/dict/get-industry-dict-by-code-types', {
    method: 'POST',
    data
  });
}
//查询分公司备案配置
export function getConfigComBranch(data) {
  return request('/public/common/get-config-com-branch', {
    method: 'GET',
    data
  });
}

// 得到保障项目信息
export function getInsProjects(data) {
  return noLoginRequest('/public/common/dict/get-ins-projects', {
    method: 'POST',
    data
  });
}

// 获取企业详情
export function systemComVaseInfoGet(data) {
  return request('/system/com-base-info/get', {
    method: 'GET',
    data
  });
}

// 企业信息-认证申请查询
export function getCertificationData(data) {
  return request('/enterprise/company/com-auth-info/get-com-auth-info-by-id', {
    method: 'POST',
    data
  });
}
/**
 * 任务模块获得合同列表
 * @author Lyq
 */
export function getContractListByTask(data) {
  return request("/enterprise/com-contract/get-contract-list-by-task", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 获取任务人员列表
 * @author Lyq
 */
export function taskGetTaskPer(data) {
  return request("/task/get-task-per", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 获取任务负责人
 * @author Lyq
 */
export function getTaskChargePer(data) {
  return request("/task/get-task-charge-per", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 移除任务人员
 * @author Lyq
 */
export function removeTaskPer(data) {
  return request("/task/remove-task-per", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 新增任务人员
 * @author Lyq
 */
export function addTaskPer(data) {
  return request("/task/add-task-per", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 修改任务负责人
 * @author Lyq
 */
export function updateTaskChargePer(data) {
  return request("/task/update-task-charge-per", {
    method: "POST",
    data: data || {}
  });
}
// 企业信息-认证申请-行业资质查询
export function enterpriseCompanyGetComIndustryinfo(data) {
  return request(
    '/enterprise/company/com-auth-info/get-com-industry-info-by-comid',
    {
      method: 'POST',
      data
    }
  );
}

//分公司、子公司通过ID获得企业行业信息
export function enterpriseCompanyComIndustryGetComBranchIndustryInfoByComId(
  data
) {
  return request(
    '/enterprise/company/com-industry/get-com-branch-industry-info-by-comid',
    {
      method: 'GET',
      data
    }
  );
}

//省市区
export function getDistrictData() {
  return noLoginRequest('/public/common/region/get-regions', {
    method: 'POST',
    data: {}
  });
}

//省市区的代码换算中文
export function getDistrictChineseData(data) {
  return noLoginRequest('/public/common/region/get-region-by-id', {
    method: 'POST',
    data
  });
}

//修改企业认证信息
export function enterpriseCompanyUpdateComAuthInfo(data) {
  return request('/enterprise/company/com-auth-info/update-com-auth-info', {
    method: 'POST',
    data
  });
}

export function modifyComInformation(data) {
  return request('/enterprise/company/update-com-auth-info', {
    method: 'POST',
    data
  });
}

//手机验证===发送法人手机验证码
export function enterpriseCompanySendLegalAuthCode(data) {
  return request('/enterprise/company/com-auth-info/send-legal-auth-code', {
    method: 'POST',
    data
  });
}

// 获得企业报表列表
export function enterpriseSalaryComReportCompanyReportList(data) {
  return request('/enterprise/salary/com-report/company-report-list', {
    method: 'POST',
    data
  });
}

//手机验证===验证验证码，检查手机验证码和企业ID是否匹配，10分钟后验证码过期
export function enterpriseComAuthInfoCheckLegalAuthCode(data) {
  return request('/enterprise/company/com-auth-info/check-legal-auth-code', {
    method: 'POST',
    data
  });
}

//企业信息-认证申请-获得企业机构特殊信息
export function enterpriseCompanyComIndustryGetIndustryConfigByComId(data) {
  return request(
    '/enterprise/company/com-industry/get-industryconfig-by-comId',
    {
      method: 'GET',
      data
    }
  );
}

//根据企业ID获得企业发票信息
export function getCompanyVnvoiceInfo(data) {
  return request('/enterprise/company/com-invoice/get-company-invoice-info', {
    method: 'POST',
    data
  });
}

//保存企业发票信息
export function saveCompanyInvoiceInfo(data) {
  return request('/enterprise/company/com-invoice/save-company-invoice-info', {
    method: 'POST',
    data
  });
}

//修改企业发票信息
export function updateCompanyInvoiceInfo(data) {
  return request(
    '/enterprise/company/com-invoice/update-company-invoice-info',
    {
      method: 'POST',
      data
    }
  );
}

//文件上传服务
export const uploadUrl =
  getHostByPath('/public') + '/public/common/file/upload-file';

// 文件上传服务
export function publicCommonFileUploadFile(data, loading = true) {
  return request('/public/common/file/upload-file', {
    method: 'POST',
    data,
    headers: {
      "Content-Type": "multipart/form-data"
    }
  }, null, false, loading);
}
//批量导入在保人员减员
export function enterpriseInsComInsMinusBatchUploadInsPer(data, loading = true) {
  return request('/enterprise/ins/com-ins/minus-batch-upload-ins-per', {
    method: 'POST',
    data,
    headers: {
      "Content-Type": "multipart/form-data"
    }
  }, null, false, loading);
}

// 查询数据字典接口
export function insComInsSaveAuthFile(data) {
  return noLoginRequest('/enterprise/ins/com-ins/save-auth-file', {
    method: 'POST',
    data
  });
}
//文件读取服务
export function publicCommonFileGetResource(data) {
  return noLoginRequest('/public/common/file/get-resource', {
    method: 'GET',
    data
  });
}

//文件预览转换
export function publicCommonFileFilePreview(data) {
  return noLoginRequest('/public/common/file/filePreview', {
    method: 'POST',
    data
  });
}

// 查询数据字典接口
export function publicCommonDictGetDictByCodeTypes(data) {
  return noLoginRequest('/public/common/dict/get-dict-by-code-types', {
    method: 'POST',
    data
  });
}

// 根据行业类型获取机构
export function publicCommonDictGetInstitutionTypeByIndustryType(data) {
  return noLoginRequest(
    '/public/common/dict/get-institution-type-by-industry-type',
    {
      method: 'POST',
      data
    }
  );
}

// 删除报表
export function enterpriseSalaryComReportDeleteCompanyReport(data) {
  return request('/enterprise/salary/com-report/delete-company-report', {
    method: 'POST',
    data
  });
}

// 获取报表表头字段集合
export function enterpriseSalaryComReportReportFieldList(data) {
  return request('/enterprise/salary/com-report/report-field-list', {
    method: 'POST',
    data
  });
}

// 新建企业自定义报表
export function enterpriseSalaryComReportAddCompanyReport(data) {
  return request('/enterprise/salary/com-report/add-company-report', {
    method: 'POST',
    data
  });
}

//医社保记录统计
export function statHisRecList(data) {
  return request('/enterprise/ins/medical-social-rec/stat-his-rec-list', {
    method: 'POST',
    data
  });
}

//提示用户去完成方案的设置
export function promptUserToSetScheme(data) {
  return request(
    '/enterprise/ins/medical-social-rec/prompt-user-to-set-scheme',
    {
      method: 'GET',
      data
    }
  );
}

//医社保记录，导出excel
export function exportHisRecList(data) {
  return request('/enterprise/ins/medical-social-rec/export-his-rec-list', {
    method: 'GET',
    data
  });
}

//医社保记录，查询人员缴交情况分页
export function getHisRecListPage(data) {
  return request('/enterprise/ins/medical-social-rec/get-his-rec-list-page', {
    method: 'POST',
    data
  });
}

//缴交设置列表，查询人员缴交情况分页
export function getPaymentSettingListPage(data) {
  return request(
    '/enterprise/ins/payment-setting-list/get-payment-setting-list-page',
    {
      method: 'POST',
      data
    }
  );
}

//删除缴交方案
export function delPaymentSetting(data) {
  return request('/enterprise/ins/payment-setting-list/del-payment-setting', {
    method: 'POST',
    data
  });
}

//缴交方案详情查询，通过缴交方案ID
export function getPaymentSettingById(data) {
  return request('/enterprise/ins/payment-setting/get-payment-setting-by-id', {
    method: 'POST',
    data
  });
}

//缴交方案的已选人员列表
export function getSelectedPersonPage(data) {
  return request('/enterprise/ins/payment-setting/get-selected-person-page', {
    method: 'POST',
    data
  });
}

//移除人员，删除关系数据
export function paymentSettingDelPerson(data) {
  return request('/enterprise/ins/payment-setting/del-person', {
    method: 'POST',
    data
  });
}

//添加人员，增加关系数据
export function paymentSettingAddPerson(data) {
  return request('/enterprise/ins/payment-setting/add-person', {
    method: 'POST',
    data
  });
}

//缴交方案新增或修改
export function paymentSettingSavePaymentSetting(data) {
  return request('/enterprise/ins/payment-setting/save-payment-setting', {
    method: 'POST',
    data
  });
}

//分页消息列表（收件人方）
export function messageReceiveList(data) {
  return request('/public/message/page-message-list', {
    method: 'POST',
    data
  });
}

//分页查询升级消息列表
export function getConfigUpdateMsgList(data) {
  return request('/enterprise/company/upgrade/get-config-update-msg-list', {
    method: 'POST',
    data
  });
}

//当前用户-批量删除消息(发送记录)
export function messageDeleteSendMessage(data) {
  return request('/public/message/send/batch-delete', {
    method: 'POST',
    data
  });
}

//根据消息关联id删除消息
export function messageDeleteMessageById(data) {
  return request('/public/message/batch-delete', {
    method: 'POST',
    data
  });
}

//当前用户-批量修改消息-设置为已读
export function updateSelectMessageRead(data) {
  return request('/public/message/batch-set-read', {
    method: 'POST',
    data
  });
}

//根据消息关联id查询具体消息详情
export function messagegetmessagebyid(data) {
  return request('/public/message/message-detail', {
    method: 'POST',
    data
  });
}

//保存消息-企业消息------改成罗鹏的接口
export function messageSaveMessageCommon(data) {
  return request('/public/message/save-message', {
    method: 'POST',
    data
  });
}

//当前用户获取消息记录列表
export function messageRecordList(data) {
  return request('/public/message/page-send-message-list', {
    method: 'POST',
    data
  });
}

//企业保险查询分页
export function comInsGetComInsPage(data) {
  return request('/enterprise/ins/com-ins/get-com-ins-page', {
    method: 'POST',
    data
  });
}
//线下保单添加备注
export function comInsUpdateComInsRemark(data) {
  return request('/enterprise/ins/com-ins/update-com-ins-remark', {
    method: 'POST',
    data
  });
}
//企业保险查询分页
export function getOnlineInsBlbReportPageLink(data) {
  return request('/enterprise/ins/com-ins/get-online-ins-blb-report-page-link', {
    method: 'POST',
    data
  });
}

//方案书分页查询
export function enterpriseInsComInsGetInsBootPage(data) {
  return request('/enterprise/ins/com-ins/get-ins-boot-page', {
    method: 'POST',
    data
  });
}

//保全链接生成
export async function enterpriseInsComInsGetOnlineInsBlbPreservationLink(data) {
  return request(
    '/enterprise/ins/com-ins/get-online-ins-blb-preservation-link',
    {
      method: 'POST',
      async: false,
      data
    }
  );
}


//获取在线保险链接
export function getOnlineInsBlbLink(data) {
  return request('/enterprise/ins/com-ins/get-online-ins-blb-link', {
    method: 'POST',
    data
  });
}
//获得百联保保险产品列表链接生成带cacheId
export function getCompnayAndPersonPutCacheLink(data) {
  return request('/enterprise/ins/com-ins/get-compnay-and-person-put-cache-link', {
    method: 'POST',
    data
  });
}

//获取在线保险链接
export function getOnlineInsBlbDetailLink(data) {
  return request('/enterprise/ins/com-ins/get-online-ins-blb-detail-link', {
    method: 'POST',
    data
  });
}
//查询线下或线上保险列表
export function findOfflineOrOnlinePolicy(data) {
  return request('/enterprise/ins/com-ins/find-offline-or-online-policy', {
    method: 'POST',
    data
  });
}
//关联线上保险
export function addPreservationService(data) {
  return request('/enterprise/ins/com-ins/save-ins-blb-add-preservation-service', {
    method: 'POST',
    data
  });
}
//批量模板上传人员线上做增员
export function tempBatchInsPerToAddPreservationService(data) {
  return request('/enterprise/ins/com-ins/temp-batch-ins-per-to-add-preservation-service', {
    method: 'POST',
    data
  });
}
//批量模板上传人员关联线下保单
export function tempBatchInsPerToRelevance(data) {
  return request('/enterprise/ins/com-ins/temp-batch-ins-per-to-relevance', {
    method: 'POST',
    data
  });
}
//获得百联保保险产品列表链接生成带cacheId（批量模板上传人员）
export function getCompnayAndTempBatchInsPerPutCache(data) {
  return request('/enterprise/ins/com-ins/get-compnay-and-temp-batch-ins-per-put-cache', {
    method: 'POST',
    data
  });
}
//关联线下保险
export function addBatchRelevancePer(data) {
  return request('/enterprise/ins/com-ins/add-batch-relevance-per', {
    method: 'POST',
    data
  });
}
//根据条件查询已投保未录入的人员信息
export function findNotIncludedInsurancePerList(data) {
  return request('/enterprise/ins/com-ins/find-not-included-insurance-per-list', {
    method: 'POST',
    data
  });
}
//选择在保未录入列表人员做减员保全
export function saveInsBlbMinusPreservationByNotIncluded(data) {
  return request('/enterprise/ins/com-ins/save-ins-blb-minus-preservation-by-not-included', {
    method: 'POST',
    data
  });
}
//查询保单已关联在保人员数量
export function findUnderWarrantyPerListCount(data) {
  return request('/enterprise/ins/com-ins/find-under-warranty-per-list-count', {
    method: 'POST',
    data
  },false, true);
}
//选择订单和人员信息推送到百联保做减员保全
export function saveInsBlbMinusPreservationService(data) {
  return request('/enterprise/ins/com-ins/save-ins-blb-minus-preservation-service', {
    method: 'POST',
    data
  });
}
//查询在保人员离职人数
export function findYIncumbencyPerCount(data = {}) {
  return request('/enterprise/ins/com-ins/find-y-incumbency-per-count', {
    method: 'POST',
    data
  });
}
//人员批量减员线下保单
export function minusBatchRelevancePer(data) {
  return request('/enterprise/ins/com-ins/minus-batch-relevance-per', {
    method: 'POST',
    data
  });
}
//根据条件查询已投保的人员信息
export function findUnderWarrantyPerList(data) {
  return request('/enterprise/ins/com-ins/find-under-warranty-per-list', {
    method: 'POST',
    data
  });
}

//删除企业保险
export function comInsDeleteComInsUnderline(data) {
  return request('/enterprise/ins/com-ins/delete-com-ins-underline', {
    method: 'POST',
    data
  });
}


//企业保险详情
export function comInsGetComInsDetail(data) {
  return request('/enterprise/ins/com-ins/get-com-ins-detail', {
    method: 'POST',
    data
  });
}

//新增企业保险
export function comInsInsertComInsUnderline(data) {
  return request('/enterprise/ins/com-ins/insert-com-ins-underline', {
    method: 'POST',
    data
  });
}

//获取线上人员参保列表
export function enterpriseInsComInsGetOnlineInsPerList(data) {
  return request('/enterprise/ins/com-ins/get-online-ins-per-list', {
    method: 'POST',
    data
  });
}
//订单列表页面链接生成
export function getOnlineInsBlbOrderPageLink(data = {}) {
  return request('/enterprise/ins/com-ins/get-online-ins-blb-order-page-link', {
    method: 'POST',
    data
  });
}
//分页查询保险负责人列表
export function selectPrincipalByComId(data) {
  return request('/enterprise/ins/com-ins/select-principal-by-comId', {
    method: 'POST',
    data
  });
}
//批量插入保险负责人   添加负责人
export function insertBatchPrincipal(data) {
  return request('/enterprise/ins/com-ins/insert-batch-principal', {
    method: 'POST',
    data
  });
}
//批量删除保险负责人   删除负责人
export function delBatchPrincipal(data) {
  return request('/enterprise/ins/com-ins/del-batch-principal', {
    method: 'POST',
    data
  });
}

// ----------------------------------股东----------------------------------
// 获取公司所有股东
export function getCompanyShareHolder(data) {
  return request('/enterprise/stock/com-stock/holder-list', {
    method: 'POST',
    data
  });
}

//获得公司所有股东（基本信息）
export function comStockBasicHolderList(data) {
  return request('/enterprise/stock/com-stock/basic-holder-list', {
    method: 'POST',
    data
  });
}

//获取公司有股权的股东
export function getCompanyValidShare(data) {
  return request('/enterprise/stock/com-stock/list-validshare', {
    method: 'POST',
    data
  });
}

//删除股东
export function deleteShareholder(data) {
  return request('/enterprise/stock/com-stock/delete-shareholder', {
    method: 'POST',
    data
  });
}

//新增机构股东
export function saveOrgShareholder(data) {
  return request('/enterprise/stock/com-stock/add-org-shareholder', {
    method: 'POST',
    data
  });
}

//新增自然人股东
export function savePerShareholder(data) {
  return request('/enterprise/stock/com-stock/add-per-shareholder', {
    method: 'POST',
    data
  });
}

//获得股东变更事件列表
export function getHolderChangeList(data) {
  return request('/enterprise/stock/com-stock/change-list', {
    method: 'POST',
    data
  });
}

//获取单个股东信息
export function comStockGetShareholderById(data) {
  return request('/enterprise/stock/com-stock/get-shareholder-by-id', {
    method: 'POST',
    data
  });
}

//获得股东事件变更记录
export function getChangeDetail(data) {
  return request('/enterprise/stock/com-stock/change-detail', {
    method: 'POST',
    data
  });
}

//校验是否存在有效的保安员资格证
export function checkIsExistsEffectBayzgz(data) {
  return request('/system/per-cer-baseinfo/check-is-exists-effect-bayzgz', {
    method: 'POST',
    data
  });
}

export function getConfigUpdateMsgInfo(data) {
  return request('/enterprise/company/upgrade/get-config-update-msg-info', {
    method: 'POST',
    data
  });
}

//股权变更（预览校验）
export function comStockChangeSharePreview(data) {
  return request('/enterprise/stock/com-stock/change-share-preview', {
    method: 'POST',
    data
  });
}

//股权变更（保存）
export function saveComStockChangeShare(data) {
  return request('/enterprise/stock/com-stock/change-share', {
    method: 'POST',
    data
  });
}

//股权初始化
export function comStockInitShare(data) {
  return request('/enterprise/stock/com-stock/init-share', {
    method: 'POST',
    data
  });
}

//获得公司所有股权信息
export function comStockListValidsharebasic(data) {
  return request('/enterprise/stock/com-stock/list-validsharebasic', {
    method: 'POST',
    data
  });
}

//获取当前登陆用户账号信息
export function systemPerAccountInfoGetUserAccount(data) {
  return request('/system/per-account-info/get-user-account', {
    method: 'GET',
    data
  });
}

//------------------------股东end------------------ 获取跨区经营列表
export function comStockCrossManageList(data) {
  return request('/enterprise/stock/submit/com-stock/cross-manage-list', {
    method: 'POST',
    data
  });
}

//根据ID删除跨区经营信息
export function comStockDeleteCrossManageById(data) {
  return request(
    '/enterprise/stock/submit/com-stock/delete-cross-manage-by-id',
    {
      method: 'POST',
      data
    }
  );
}

//根据ID获取跨区经营信息
export function comStockGetCrossManageById(data) {
  return request('/enterprise/stock/submit/com-stock/get-cross-manage-by-id', {
    method: 'POST',
    data
  });
}

//保存-修改跨区经营
export function comStockSaveCrossManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-cross-manage', {
    method: 'POST',
    data
  });
}

//获取海外经营列表
export function comStockComOverseaManageList(data) {
  return request('/enterprise/stock/submit/com-stock/com-oversea-manage-list', {
    method: 'POST',
    data
  });
}

//根据ID删除海外经营信息
export function comStockDeleteOverseaManageById(data) {
  return request(
    '/enterprise/stock/submit/com-stock/delete-oversea-manage-by-id',
    {
      method: 'POST',
      data
    }
  );
}

//获取海外经营信息
export function comStockGetOverseaManageById(data) {
  return request(
    '/enterprise/stock/submit/com-stock/get-oversea-manage-by-id',
    {
      method: 'POST',
      data
    }
  );
}

//保存-修改海外经营
export function stockSubmitComStockSaveOverseaManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-oversea-manage', {
    method: 'POST',
    data
  });
}

//保存-修改管理层
export function submitComStockSaveComManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-com-manage', {
    method: 'POST',
    data
  });
}

//获取管理员列表-liyongqiang
export function comStockManageList(data) {
  return request('/enterprise/stock/submit/com-stock/com-manage-list', {
    method: 'POST',
    data
  });
}

//根据id删除管理员信息-liyongqiang
export function comStockDeleteManageById(data) {
  return request('/enterprise/stock/submit/com-stock/delete-com-manage-by-id', {
    method: 'POST',
    data
  });
}

//获取管理员信息-liyongqinag
export function comStockGetManageById(data) {
  return request('/enterprise/stock/submit/com-stock/get-com-manage-by-id', {
    method: 'POST',
    data
  });
}

//获取管理层变更信息列表-liyongqiang
export function comStockChangeManageList(data) {
  return request('/enterprise/stock/submit/com-stock/change-manage-list', {
    method: 'POST',
    data
  });
}

//获取在职管理员的列表（人员选择下拉列表）
export function comStockComManageListByStatus(data) {
  return request(
    '/enterprise/stock/submit/com-stock/com-manage-list-by-status',
    {
      method: 'POST',
      data
    }
  );
}

//替换-新管理员代替旧管理员
export function comStockSaveReplaceComManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-replace-com-manage', {
    method: 'POST',
    data
  });
}

//获取管理员信息
export function comStockGetComManageById(data) {
  return request('/enterprise/stock/submit/com-stock/get-com-manage-by-id', {
    method: 'POST',
    data
  });
}

//获取主管理员信息
export function selectComAdmin(data) {
  return request('/system/per-account-info/select-com-admin', {
    method: 'POST',
    data
  });
}

//更改主管理员
export function changeComAdmin(data) {
  return request('/system/com-admin-change-event/update', {
    method: 'POST',
    data
  });
}


/**********************************************企业设备******************************************/

/**
 * 设备列表-获取企业设备列
 * @author CXL
 */
export function enterpriseEquipComEquipListComEquip(data) {
  return request('/enterprise/equip/com-equip/list-com-equip', {
    method: 'POST',
    data
  });
}

/**
 * 设备列表-获取企业设备详情
 * @author CXL
 */
export function enterpriseEquipComEquipGetComEquipById(data) {
  return request('/enterprise/equip/com-equip/get-com-equip-by-id', {
    method: 'GET',
    data
  });
}

/**
 * 设备列表-新增企业设备
 * @author CXL
 */
export function enterpriseEquipComEquipAddComEquip(data) {
  return request('/enterprise/equip/com-equip/add-com-equip', {
    method: 'POST',
    data
  });
}

/**
 * 设备列表-查询是否已经存在企业设备编号
 * @author CXL
 */
export function countComEquipNo(data) {
  return request('/enterprise/equip/com-equip/count-com-equipNo', {
    method: 'GET',
    data
  });
}

/**
 * 设备列表-根据Id删除企业设备
 * @author CXL
 */
export function enterpriseEquipComEquipDeleteComEquipById(data) {
  return request('/enterprise/equip/com-equip/delete-com-equip-by-id', {
    method: 'GET',
    data
  });
}

/**
 * 设备列表-修改企业设备
 * @author CXL
 */
export function enterpriseEquipComEquipUpdateComEquip(data) {
  return request('/enterprise/equip/com-equip/update-com-equip', {
    method: 'POST',
    data
  });
}

/**********************************************企业设备出入库******************************************/

/**
 * 设备出入库-获取企业设备出入库记录列表
 * @author CXL
 */
export function enterpriseEquipComEquipInOutListComEquipInOut(data) {
  return request('/enterprise/equip/com-equip-in-out/list-com-equip-in-out', {
    method: 'POST',
    data
  });
}

export function EnterpriseEquipComEquipInOutGetComEquipInOutById(data) {
  return request(
    '/enterprise/equip/com-equip-in-out/get-com-equip-in-out-by-id',
    {
      method: 'GET',
      data
    }
  );
}

//新增企业设备出入库记录
export function comEquipInOutAddComEquipInOut(data) {
  return request('/enterprise/equip/com-equip-in-out/add-com-equip-in-out', {
    method: 'POST',
    data
  });
}

/**********************************************合同******************************************/

/**
 * 合同管理-获取合同列表
 * @author CXL
 */
export function checkRelateTaskByContractId(data) {
  return request('/task/check-relate-task-by-contract-id', {
    method: 'POST',
    data
  });
}
/**
 * 合同管理-导出合同列表
 * @author CXL
 */
export function exportContractList(data) {
  return request('/enterprise/com-contract/export-contract-list', {
    method: 'GET',
    data
  });
}
export function enterpriseComContractComContractList(data) {
  return request('/enterprise/com-contract/com-contract-list', {
    method: 'POST',
    data
  });
}
// 获取即将到期的合同数量
export function getExpireContractCount(data) {
  return request('/enterprise/com-contract/get-expire-contract-count', {
    method: 'GET',
    data
  });
}

/**
 * 合同管理-删除合同
 * @author CXL
 */
export function enterpriseComContractDeleteComContract(data) {
  return request('/enterprise/com-contract/delete-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-终止合同
 * @author CXL
 */
export function enterpriseComContractTerminationComContract(data) {
  return request('/enterprise/com-contract/termination-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-通过ID获得合同信息
 * @author CXL
 */
export function enterpriseComContractGetComContractById(data) {
  return request('/enterprise/com-contract/get-com-contract-by-id', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-合同初始化
 * @author CXL
 */
export function enterpriseComContractInitComContract(data) {
  return request('/enterprise/com-contract/init-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-新增合同
 * @author CXL
 */
export function enterpriseComContractInsertComContract(data, notip = false) {
  return request('/enterprise/com-contract/insert-com-contract', {
    method: 'POST',
    data
  }, false, notip);
}

/**
 * 合同管理-修改合同
 * @author CXL
 */
export function enterpriseComContractUpdateComContract(data) {
  return request('/enterprise/com-contract/update-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 保安人员列表查询
 * @author Lyq
 */
export function pageForPerInfo(data) {
  return request('/system/per-base-info/page-for-per-info', {
    method: 'POST',
    data
  });
}
/**
 * 保安证书列表查询
 * @author Lyq
 */
export function pageForPerCerInfo(data) {
  return request('/system/per-cer-baseinfo/page-for-per-cer-info', {
    method: 'POST',
    data
  });
}
//获取人员认证记录
export function getPerAuthRecord(data) {
  return request('/system/per-base-info/get-per-auth-record', {
    method: 'POST',
    data
  });
}
//未签订合同人员分页查询
export function pageNoSignContractPer(data) {
  return request('/enterprise/com-contract/page-no-sign-contract-per', {
    method: 'POST',
    data
  });
}
//通过合同ID查找驻勤点列表
export function getTaskListByContractId(data) {
  return request('/task/get-task-list-by-contractId', {
    method: 'POST',
    data
  });
}

/**********************************************好人好事******************************************/

/**
 * 好人好事-获取好人好事列表
 * @author ZJH
 */
export function listPerGoodDeeds(data) {
  return request(
    '/enterprise/awardPenalty/per-good-deeds/list-per-good-deeds',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 好人好事-删除好人好事
 * @author ZJH
 */
export function deletePerGoodDeedsById(data) {
  return request(
    '/enterprise/awardPenalty/per-good-deeds/delete-per-good-deeds-by-id',
    {
      method: 'GET',
      data
    }
  );
}

/**
 * 好人好事-好人好事详情
 * @author ZJH
 */
export function getPerGoodDeedsById(data) {
  return request(
    '/enterprise/awardPenalty/per-good-deeds/get-per-good-deeds-by-id',
    {
      method: 'GET',
      data
    }
  );
}

/**
 * 好人好事-更新好人好事
 * @author ZJH
 */
export function updatePerGoodDeeds(data) {
  return request(
    '/enterprise/awardPenalty/per-good-deeds/update-per-good-deeds',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 好人好事-新增好人好事
 * @author ZJH
 */
export function addPerGoodDeeds(data) {
  return request('/enterprise/awardPenalty/per-good-deeds/add-per-good-deeds', {
    method: 'POST',
    data
  });
}

/**
 * 好人好事-查询人员身份证
 * @author ZJH
 */
export function selectPerIdCardNum(data) {
  return request(
    '/enterprise/awardPenalty/per-good-deeds/select-per-id-card-num',
    {
      method: 'GET',
      data
    }
  );
}

/**********************************************奖励列表******************************************/
/**
 * 奖励列表-列表
 * @author ZJH
 */
export function listComSecurityAward(data) {
  return request(
    '/enterprise/awardPenalty/per-security-award/list-com-security-award',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 奖励列表-新增保安人员奖励信息
 * @author ZJH
 */
export function addComSecurityAward(data) {
  return request(
    '/enterprise/awardPenalty/per-security-award/add-com-security-award',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 奖励列表-保安人员奖励信息详情
 * @author ZJH
 */
export function getComSecurityAwardById(data) {
  return request(
    '/enterprise/awardPenalty/per-security-award/get-com-security-award-by-id',
    {
      method: 'GET',
      data
    }
  );
}

/**
 * 奖励列表-修改保安人员奖励信息
 * @author ZJH
 */
export function updateComSecurityAward(data) {
  return request(
    '/enterprise/awardPenalty/per-security-award/update-com-security-award',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 奖励列表-删除保安人员奖励信息
 * @author ZJH
 */
export function deleteComSecurityAwardById(data) {
  return request(
    '/enterprise/awardPenalty/per-security-award/delete-com-security-award-by-id',
    {
      method: 'GET',
      data
    }
  );
}

/**********************************************处罚列表******************************************/

/**
 * 处罚列表-列表
 * @author ZJH
 */
export function listComSecurityPenalty(data) {
  return request(
    '/enterprise/awardPenalty/per-security-penalty/list-com-security-penalty',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 处罚列表-新增保安处罚信息
 * @author ZJH
 */
export function addComSecurityPenalty(data) {
  return request(
    '/enterprise/awardPenalty/per-security-penalty/add-com-security-penalty',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 处罚列表-修改保安处罚信息
 * @author ZJH
 */
export function updateComSecurityPpenalty(data) {
  return request(
    '/enterprise/awardPenalty/per-security-penalty/update-com-security-penalty',
    {
      method: 'POST',
      data
    }
  );
}

/**
 * 处罚列表-修改保安处罚信息
 * @author ZJH
 */
export function getComSecurityPenaltyById(data) {
  return request(
    '/enterprise/awardPenalty/per-security-penalty/get-com-security-penalty-by-id',
    {
      method: 'GET',
      data
    }
  );
}

/**
 * 处罚列表-删除保安处罚信息
 * @author ZJH
 */
export function deleteComSecurityPenaltyById(data) {
  return request(
    '/enterprise/awardPenalty/per-security-penalty/delete-com-security-penalty-by-id',
    {
      method: 'GET',
      data
    }
  );
}

/**********************************************企业注册******************************************/

/**
 * 企业注册-验证手机是否是其他公司的主管理员注册过
 * @author Orm
 */
export function systemRoleIsCharge(data) {
  return noLoginRequest('/system/com-role/ischarge', {
    method: 'GET',
    data
  });
}

/**
 * 企业注册-企业注册
 * @author Orm
 */
export function systemComBaseInfoSave(data) {
  return noLoginRequest('/system/com-base-info/save', {
    method: 'POST',
    data
  });
}

/**
 * 选择人员
 * @author hjj
 */
export function getTreeperBydepart(data) {
  return request('/system/com-depart/get-treeper-bydepart', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 选择人员
 * @author Lyq
 */
export function getPerBaseInfoListByPerids(data) {
  return request('/system/per-base-info/get-per-base-info-list-by-perids', {
    method: 'POST',
    data: data || {}
  });
}
/** 企业人员信息列表 */
export function getTreeperBydepartMap(data) {
  return request('/system/com-depart/get-treeper-bydepart-map', {
    method: 'POST',
    data: data || {}
  });
}

/**
 * 2019-06-22  Lyq
 * 金融钱包模块 
 * */
/** 获取企业钱包服务开通情况*/
export function getComWalletServiceOpenInfo(data) {
  return request('/task/com/wallet/get-com-wallet-service-open-info', {
    method: 'GET',
    data: data || {}
  });
}
/** 获取指定企业钱包服务开通情况*/
export function getComWalletServiceOpenInfoFormOne(data) {
  return request('/task/com/wallet/get-com-wallet-service-open-info', {
    method: 'GET',
    data: data || {}
  },false,false,true,true);
}
/** 保存钱包银行卡信息变更*/
export function saveBankCardChangeEvent(data) {
  return request('/task/com/wallet-change/save-bank-card-change-event', {
    method: 'POST',
    data: data || {}
  });
}
/** 获取企业钱包服务当前开通步骤*/
export function getComWalletCurrentProcess(data) {
  return request('/task/com/wallet/get-com-wallet-current-process', {
    method: 'GET',
    data: data || {}
  });
}
/** 获取企业未开通钱包服务人员列表*/
export function getNoOpenWalletServicePerList(data) {
  return request('/task/per/wallet/get-no-open-wallet-service-per-list', {
    method: 'GET',
    data: data || {}
  });
}
/** 获取企业已开通钱包服务人员列表*/
export function getOpenWalletServicePerList(data) {
  return request('/task/per/wallet/get-open-wallet-service-per-list', {
    method: 'GET',
    data: data || {}
  });
}
/** 获取企业人员开通钱包服务情况  已开通和未开通的人数*/
export function getPerOpenWalletServiceInfo(data) {
  return request('/task/per/wallet/get-per-open-wallet-service-info', {
    method: 'GET',
    data: data || {}
  });
}
/** 【薪资代发】薪资待发单开通账号提醒*/
export function grantInfoBatchNotice(data) {
  return request('/task/com/grant/grant-info-batch-notice', {
    method: 'POST',
    data: data || {}
  });
}
/** 批量提醒开通*/
export function batchNotice(data) {
  return request('/task/per/wallet/batch-notice', {
    method: 'POST',
    data: data || {}
  });
}
/** 获取银行配置*/
export function getConfigBankList(data) {
  return request('/public/common/get-config-bank-list', {
    method: 'GET',
    data: data || {}
  });
}
/** 企业业务发送验证码*/
export function sendVerifyCode(data) {
  return request('/task/com/wallet/send_verify_code', {
    method: 'POST',
    data: data || {}
  });
}
/** 企业保存开户资料第一步*/
export function saveCccountInfoStepOne(data) {
  return request('/task/com/wallet/save-account-info-step-one', {
    method: 'POST',
    data: data || {}
  });
}
/** 企业保存开户资料第二步*/
export function saveCccountInfoStepTwo(data) {
  return request('/task/com/wallet/save-account-info-step-two', {
    method: 'POST',
    data: data || {}
  });
}

/** 企业保存开户资料(原来的两步变成一步完成)*/
export function saveCccountInfo(data) {
  return request('/task/com/wallet/save-account-info', {
    method: 'POST',
    data: data || {}
  });
}
/** 获取企业钱包账户资料*/
export function getComWalletAccount(data) {
  return request('/task/com/wallet/get-com-wallet-account', {
    method: 'GET',
    data: data || {}
  }, null, false, true);
}
/** 获取企业钱包账户金额*/
export function getComWalletAccountAmount(data) {
  return request('/task/com/wallet/get-com-wallet-account-amount', {
    method: 'GET',
    data: data || {}
  });
}
/** 获取企业钱包账户交易明细*/
export function getComWalletAccountTradeDetail(data) {
  return request('/task/com/wallet/get-com-wallet-account-trade-detail', {
    method: 'GET',
    data: data || {}
  });
}
/** 获取企业钱包账户对账数据*/
export function getComWalletReconciliation(data) {
  return request('/task/com/wallet/get-com-wallet-reconciliation', {
    method: 'POST',
    data: data || {}
  });
}
/** 企业钱包账户提现*/
export function comWalletAccountExtract(data) {
  return request('/task/com/wallet/com-wallet-account-extract', {
    method: 'POST',
    data: data || {}
  });
}
/** 获取企业钱包充值token*/
export function getWalletRechargeToken(data) {
  return request('/task/com/wallet/get-wallet-recharge-token', {
    method: 'POST',
    data: data || {}
  });
}
/** 获取企业充值交易状态*/
export function getWalletTradeInfo(data) {
  return request('/task/com/wallet/get-wallet-trade-info', {
    method: 'POST',
    data: data || {}
  });
}
/** 获取企业获取薪资代发记录列表*/
export function pageComGrantInfoList(data) {
  return request('/task/com/grant/page-com-grant-info-list', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】创建企业薪资代发信息*/
export function saveComGrantInfo(data) {
  return request('/task/com/grant/save-com-grant-info', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】删除待发记录*/
export function deleteComGrantInfo(data) {
  return request('/task/com/grant/delete-com-grant-info', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取待发总额*/
export function getComToGrantDetailTotal(data) {
  return request('/task/com/grant/get-com-to-grant-detail-total', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取薪资代发记录汇总*/
export function selectGrantDetailTotalMap(data) {
  return request('/task/com/grant/select-grant-detail-total-map', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取企业获取薪资待发记录列表*/
export function pageComToGrantDetailList(data) {
  return request('/task/com/grant/page-com-to-grant-detail-list', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取企业获取失败薪资代发记录列表*/
export function pageFailComGrantDetailList(data) {
  return request('/task/com/grant/page-fail-com-grant-detail-list', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取企业获取成功薪资代发记录列表*/
export function pageSuccessComGrantDetailList(data) {
  return request('/task/com/grant/page-success-com-grant-detail-list', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取第三方已锁定工资单列表*/
export function getPayrollList(data) {
  return request('/task/com/grant/get-payroll-list', {
    method: 'POST',
    data: data || {}
  });
}
/**【薪资代发】生成第三方待发放数据*/
export function createThirdToGrantData(data) {
  return request('/task/com/grant/create-third-to-grant-data', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】根据id获取薪资代发记录*/
export function getComGrantInfoById(data) {
  return request('/task/com/grant/get-com-grant-info-by-id', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取在线薪酬数据来源列表，年月*/
export function getOnlineSalaryDataSource(data) {
  return request('/task/com/grant/get-online-salary-data-source', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】生成线上待发放数据*/
export function createOnlineToGrantData(data) {
  return request('/task/com/grant/create-online-to-grant-data', {
    method: 'POST',
    data: data || {}
  });
}
/** 获得待发单的操作记录*/
export function getComOperRecordList(data) {
  return request('/task/com/grant/get-com-oper-record-list', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】薪资发放前统计多少人可以发放，多少人不可发放*/
export function readySalaryGrantTotal(data) {
  return request('/task/com/grant/ready-salary-grant-total', {
    method: 'POST',
    data: data || {}
  });
}
/** 【薪资代发】获取是否可以发放工资*/
export function getCanGrant(data) {
  return request('/task/com/grant/get-can-grant', {
    method: 'POST',
    data: data || {}
  });
}
/**【薪资代发】薪资发放*/
export function salaryGrant(data) {
  return request('/task/com/grant/salary-grant', {
    method: 'POST',
    data: data || {}
  });
}
/**【薪资代发】薪资发放*/
export function reSalaryGrant(data) {
  return request('/task/com/grant/re-salary-grant', {
    method: 'POST',
    data: data || {}
  });
}
/**【薪资代发】获取企业发放记录列表*/
export function pageComGrantRecordList(data) {
  return request('/task/com/grant-record/page-com-grant-record-list', {
    method: 'POST',
    data: data || {}
  });
}
/**【薪资代发】保存企业线下发放记录*/
export function saveOffLineGrantRecord(data) {
  return request('/task/com/grant-record/save-off-line-grant-record', {
    method: 'POST',
    data: data || {}
  });
}
/**【薪资代发】删除企业线下发放记录*/
export function deleteOffLineGrantRecord(data) {
  return request('/task/com/grant-record/delete-off-line-grant-record', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】查询待发放补贴*/
export function getDffSubsidyList(data) {
  return request('/task/com/wallet/get-dff-subsidy-list', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】发放保安员资格证补贴*/
export function grantBayzgzSubsidy(data) {
  return request('/task/com/wallet/grant-bayzgz-subsidy', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】发放职业技能培训补贴*/
export function grantZyjnpxSubsidy(data) {
  return request('/task/com/wallet/grant-zyjnpx-subsidy', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】查询已发放补贴*/
export function getYffSubsidyList(data) {
  return request('/task/com/wallet/get-yff-subsidy-list', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】查询已发放补贴信息*/
export function getYffSubsidyInfo(data) {
  return request('/task/com/wallet/get-yff-subsidy-info', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】发送补贴验证码*/
export function sendSubsidyVerificationCode(data) {
  return request('/task/com/wallet/send-subsidy-verification-code', {
    method: 'POST',
    data: data || {}
  });
}
/**【补贴发放管理】获取百保盾补贴详情页面url地址*/
export function getBbdSubsidyPageUrl(data) {
  return request('/task/com/wallet/get-bbd-subsidy-page-url', {
    method: 'POST',
    data: data || {}
  });
}
/**电子回单下载任务列表*/
export function voucherPageVoucherEvent(data) {
  return request('/task/wallet/voucher/page-voucher-event', {
    method: 'GET',
    data: data || {}
  });
}
/**创建电子回单下载任务*/
export function createVoucherEvent(data) {
  return request('/task/wallet/voucher/create-voucher-event', {
    method: 'POST',
    data: data || {}
  });
}
// /**企业电子回单*/
// export function comAccountTradeVoucher(data) {
//   return request('/task/com/wallet/com-account-trade-voucher', {
//     method: 'GET',
//     data: data || {}
//   });
// }
// /**企业电子回单*/
// export function comAccountPayVoucher(data) {
//   return request('/task/com/wallet/com-account-pay-voucher', {
//     method: 'GET',
//     data: data || {}
//   });
// }


/**获取公司的组织架构数（含数据权限）新*/
export function systemComDepartGetDepartTree(data) {
  return request('/system/com-depart/get-depart-tree', {
    method: 'POST',
    data: data || {}
  });
}
/**获取组织机构右边的人员列表（新）*/
export function systemComDepartGetOrgPersonList(data) {
  return request('/system/com-depart/get-org-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**获取部门app通讯录权限设置信息*/
export function getDepartAppAuthInfo(data) {
  return request('/system/com-depart/get-depart-app-auth-info', {
    method: 'POST',
    data: data || {}
  });
}
/**保存部门app通讯录权限设置信息*/
export function saveDepartAppAuthInfo(data) {
  return request('/system/com-depart/save-depart-app-auth-info', {
    method: 'POST',
    data: data || {}
  });
}
/**web通过姓名/手机号码/身份证搜索人员信息*/
export function systemComDepartGetWebPerListByKeyword(data) {
  return request('/system/com-depart/get-web-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}

/**导出人员证书模板*/
export function perCerBaseinfoExportPerCerTemp(data) {
  return request('/system/per-cer-baseinfo/export-per-cer-temp', {
    method: 'POST',
    data: data || {}
  });
}
/**导入人员证书*/
export function perCerBaseinfoImportExcelPerCer(data) {
  return request('/system/per-cer-baseinfo/import-excel-per-cer', {
    method: 'POST',
    data: data || {}
  });
}
/*************保安员资格证申报****************/
/**查询未提交申报信息列表*/
export function getNoCommitBayzgzSbList(data) {
  return request('/public/bayzgz-sb/get-no-commit-bayzgz-sb-list', {
    method: 'POST',
    data: data || {}
  });
}
export function getNoApplyBayzgzList(data) {
  return request('/public/bayzgz-sb/get-no-apply-bayzgz-list', {
    method: 'POST',
    data: data || {}
  });
}
// 获取未持保安员资格证人员列表
export function pageNoBayzgzPerList(data) {
  return request('/system/per-cer-baseinfo/page-no-bayzgz-per-list', {
    method: 'POST',
    data: data || {}
  });
}
/**查询提交已百保盾申报信息列表*/
export function getCommitBayzgzSbList(data) {
  return request('/public/bayzgz-sb/get-committed-bayzgz-sb-list', {
    method: 'POST',
    data: data || {}
  });
}
/**获取人员的基础信息*/
export function getBayBaseInfo(data) {
  return request('/system/html/per-info/get-bay-base-info', {
    method: 'POST',
    data: data || {}
  });
}
/**获取人员合同列表2019*/
export function getComContractListByPerId(data) {
  return request('/enterprise/com-contract/get-com-contract-list-by-perId', {
    method: 'POST',
    data: data || {}
  });
}
/**校验企业是否配置了监管机构*/
export function checkIsSetRegulator(data) {
  return request('/enterprise/company/com-regulator-set/check-is-set-regulator', {
    method: 'POST',
    data: data || {}
  });
}
/**获取各省份保安员配置*/
export function getConfigBayzgzSb(data) {
  return request('/public/bayzgz-sb/get-config-bayzgz-sb', {
    method: 'POST',
    data: data || {}
  });
}
/**删除暂存的资格证申报记录*/
export function publicBayzgzSbDeleteBayzgzTemp(data) {
  return request('/public/bayzgz-sb/delete-bayzgz-temp', {
    method: 'POST',
    data: data || {}
  });
}
/**保安员资格证申报暂存*/
export function bayzgzTempSave(data) {
  return request('/public/bayzgz-sb/bayzgz-temp-save', {
    method: 'POST',
    data: data || {}
  });
}
/**保安员资格证申报保存并推送*/
export function bayzgzSave(data) {
  return request('/public/bayzgz-sb/bayzgz-save', {
    method: 'POST',
    data: data || {}
  });
}
/**获取保安员资格证申报详情*/
export function getBayzgzSbInfoById(data) {
  return request('/public/bayzgz-sb/get-bayzgz-sb-info-by-id', {
    method: 'POST',
    data: data || {}
  });
}
/**撤销保安员资格证申报申请2019*/
export function revokeBayzgzSbApply(data) {
  return request('/public/bayzgz-sb/revoke-bayzgz-sb-apply', {
    method: 'POST',
    data: data || {}
  }, false, true);
}
/**公共选人的接口(关键字查询)*/
export function getPerListByKeyword(data) {
  return request('/system/com-depart/get-common-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}

/*************保安员等级证申报****************/
/**获取保安员等级证申报的基础信息*/
export function getBayGwsyxBaseInfo(data) {
  return request('/system/html/per-info/get-bay-gwsyx-base-info', {
    method: 'POST',
    data: data || {}
  });
}
/*************保安员岗前申报****************/
export function getBayDjzBaseInfo(data) {
  return request('/system/html/per-info/get-bay-djz-base-info', {
    method: 'POST',
    data: data || {}
  });
}

/*****************************企业信息--企业监管****** */
/**获取公司所在省份公安机构列表*/
export function getSysPoliceList(data) {
  return request('/enterprise/company/com-regulator-set/get-sys-police-list', {
    method: 'POST',
    data: data || {}
  });
}
/**保存企业监管设置信息*/
export function saveComRegulatorSet(data) {
  return request('/enterprise/company/com-regulator-set/save-com-regulator-set', {
    method: 'POST',
    data: data || {}
  });
}
/**获取企业监管设置信息*/
export function getComRegulatorSet(data) {
  return request('/enterprise/company/com-regulator-set/get-com-regulator-set', {
    method: 'POST',
    data: data || {}
  });
}
/**保安员资格证重复提交校验*/
export function bayzgzCheckResubmit(data) {
  return request('/public/bayzgz-sb/bayzgz-check-resubmit', {
    method: 'POST',
    data: data || {}
  });
}
// 获取身份认证结果信息
export function getPerAuthRecordbyId(data = {}) {
  return request('/system/per-base-info/get-per-auth-record-by-id', {
    method: 'POST',
    data: data || {}
  });
}
/*********************************************开票****************************************/
/**获得企业开票列表*/
export function companyBizInvoiceList(data) {
  return request('/enterprise/company/com-biz-invoice/company-biz-invoice-list', {
    method: 'POST',
    data: data || {}
  });
}
/**通过ID获得企业业务发票信息*/
export function getBizInvoiceInfo(data) {
  return request('/enterprise/company/com-biz-invoice/get-biz-invoice-info', {
    method: 'POST',
    data: data || {}
  });
}
/**确认开票信息*/
export function confirmBizInvoiceInfo(data) {
  return request('/enterprise/company/com-biz-invoice/confirm-biz-invoice-info', {
    method: 'POST',
    data: data || {}
  });
}
/**通过ID获得企业业务发票具体开票信息*/
export function getBizInvoiceMakeInfo(data) {
  return request('/enterprise/company/com-biz-invoice/get-biz-invoice-make-info', {
    method: 'POST',
    data: data || {}
  });
}
/**上传保存发票*/
export function uploadBizInvoice(data) {
  return request('/enterprise/company/com-biz-invoice/upload-biz-invoice', {
    method: 'POST',
    data: data || {}
  });
}
/**在线开电子票*/
export function applyEinvoice(data) {
  return request('/enterprise/company/com-biz-invoice/apply-einvoice', {
    method: 'POST',
    data: data || {}
  });
}
export function bktGetInvoiceTotal(data) {
  return request('/enterprise/company/com-biz-invoice/bkt/get-invoice-total', {
    method: 'POST',
    data: data || {}
  });
}
/**获得开票明细的业务数据分页*/
export function bktPageInvoiceLine(data) {
  return request('/enterprise/company/com-biz-invoice/bkt/page-invoice-line', {
    method: 'POST',
    data: data || {}
  });
}
/**设置公司发票税率*/
export function setCompanyInvoiceTaxrate(data) {
  return request('/enterprise/company/com-invoice/set-company-invoice-taxrate', {
    method: 'POST',
    data: data || {}
  },null, true);
}
/**重新计算税额*/
export function updateBizInvoiceTax(data) {
  return request('/enterprise/company/com-biz-invoice/update-biz-invoice-tax', {
    method: 'POST',
    data: data || {}
  }, null, true);
}
/**********************************************公共接口******************************************/
/**获取选人公共部门树的人员列表*/
export function getDepartPersonList(data) {
  return request('/system/com-depart/get-depart-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**通过部门id获取助勤人员人员列表*/
export function getTaskDepartPersonList(data) {
  return request('/system/com-depart/get-task-depart-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**关键字查询助勤人员人员列表*/
export function getTaskPerListByKeyword(data) {
  return request('/system/com-depart/get-task-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}


/**********************************************劳务薪酬******************************************/
import * as api_laoWuXinChou from './api_laoWuXinChou';

export const {
  enterpriseSalaryComReportReportInfo,
  enterpriseSalaryComReportReportDetail,
  enterpriseSalaryComReportSumActualWage,
  enterpriseSalaryComReportUpdateCompanyReport,
  enterpriseSalaryComReportReport,
  enterpriseSalaryComReportUpdateReportInfo
} = api_laoWuXinChou;
/**********************************************企业初始化******************************************/
import * as api_enterpriseInit from './api_enterpriseInit';

export const {
  systemComInitprocessList,
  systemPerAccountInfoUpdatePassword,
  systemPerAccountInfoUpdatePasswordRequest,
  systemPerAccountInfoUpdatePasswordRequest2,
  systemPlatNewsSendVerificationCode2,
  systemComDepartSave,
  systemComDepartBatchInsertDepart,
  systemComDepartDelete,
  systemComDepartImportDepart,
  systemComRoleRroupBatchInsertRoleGroup,
  systemComRoleBatchInsertRole,
  systemSysMenuAllMenuTree,
  systemComRoleAppOperationGetRoleAppOperation,
  systemComRoleAllotSave,
  systemComRoleAllotGetChildMenuByRoleId,
  enterpriseInsComInsUpdateProcessType,
  systemPerBaseInfoCheckAdmin,
  systemPerBaseInfoCheckPer,
  systemPerAccountInfoCheckUserAccountExist,
  systemPerBaseInfoUpdatePassWord,
  enterpriseCompanyComAuthInfoUpdateComplete,
  systemComRoleAllotGetDataAuthority,
  systemComRoleAllotSaveDataAuthority,
  getRegionMenuButton
} = api_enterpriseInit;

/**********************************************任务管理******************************************/

export const {
  taskGetStepTwoDetail,
  // taskGetServerTypeList,
  taskGetIndustriesList,
  // taskDeleteTaskById,
  taskDeleteTask,
  // taskDoneTask,
  // taskCancelTask,
  taskManagementList,
  taskGetStepOneDetail,
  // taskTreeTaskType,
  taskSaveStepOneDetail,
  taskSaveStepTwoDetail,
  taskSaveStepThreeDetail,
  taskGetStepThreeDetail,
  taskGetThreePer,
  taskDeleteAddress,
  taskDeleteSchedulCycle,
  taskGetTaskById,
  getTaskGetTaskUnInsPerInfoList,
  taskGetTaskConflictPerInfoList,
  taskComTaskPerShiftValidateScheduleCycle,
  getTaskPerRecord,
  extentTask,
  endTask,
  pagePerTaskInfo,
  getNoSchedulShiftList,
  deleteTaskShift
} = api_taskbuild;

/**********************************************分公司管理******************************************/

export const {
  enterpriseComManagerListBranchComManager,
  enterpriseComManagerGetComBaseInfoById,
  enterpriseComManagerListBranchRecord,
  enterpriseCompanyComBaseInfoGetBranchCom,
  enterpriseCompanyComBaseInfoGetBranch,
  enterpriseCompanyComBaseInfoGetComBaseInfoById,
  systemComBaseInfoSaveBranch
} = api_brachCompany;

/**
 * 是否需要保险提示
 * @author zjp
 */
export function enterpriseInsComInsPromptInitEnterpriseIns(data) {
  return request('/enterprise/ins/com-ins/prompt-init-enterprise-ins', {
    method: 'POST',
    data: data || {}
  });
}

//获取保全缴费记录
export function enterpriseInsComInsGetOnlineInsBlbPreservationPageLink(data) {
  return request(
    '/enterprise/ins/com-ins/get-online-ins-blb-preservation-page-link',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
//获取保全缴费记录
export function findUninsuredPerList(data) {
  return request(
    '/enterprise/ins/com-ins/find-uninsured-per-list',
    {
      method: 'POST',
      data: data || {}
    }
  );
}

//保存方案书
export function enterpriseInsComInsSaveBookScheme(data) {
  return request('/enterprise/ins/com-ins/save-book-scheme', {
    method: 'POST',
    data: data || {}
  });
}

//获取产品列表
export function enterpriseInsComInsGetBlbProList(data) {
  return request('/enterprise/ins/com-ins/get-blb-pro-list', {
    method: 'POST',
    data: data || {}
  });
}

//方案书pdf下载
export function enterpriseInsComInsGetBootSchemePdfLink(data) {
  return request('/enterprise/ins/com-ins/get-boot-scheme-pdf-link', {
    method: 'POST',
    data: data || {}
  });
}

/*************************防控指挥*************************** */
//创建群组
export function createGroup(data) {
  return request('/system/per-account-info/create-group', {
    method: 'POST',
    data: data || {}
  });
}
//推送音视频房间号给指定人员
export function sendVideoRoomMsg(data) {
  return request('/system/per-account-info/send-video-room-msg', {
    method: 'POST',
    data: data || {}
  });
}
//解散音视频房间
export function trtcVideoRoom(data) {
  return request('/system/per-account-info/trtc-video-room', {
    method: 'POST',
    data: data || {}
  });
}
//web端获取腾讯音视频sig接口
export function getTencentYspSig(data) {
  return request('/system/per-account-info/get-tencent-ysp-sig', {
    method: 'GET',
    data: data || {}
  });
}
//获取企业人员位置分页列表
export function getComPerLocationPageList(data) {
  return request('/system/prevent-command/get-com-per-location-page-list', {
    method: 'POST',
    data: data || {}
  });
}
//通过条件查询企业人员位置列表
export function getComPerLocationByKeyword(data) {
  return request('/system/prevent-command/get-com-per-location-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}
//blob文件上传服务
export function uploadBlobFile(data) {
  return request('/public/common/file/upload-blob-file', {
    method: 'POST',
    data: data || {}
  });
}
/**********************考培**************************/
// 分页查询培训负责人列表
export function comTrainSelectPrincipalByComId(data) {
  return request('/enterprise/train/com-train/select-principal-by-comId', {
    method: 'POST',
    data: data || {}
  });
}
// 批量删除培训负责人
export function comTrainDelBatchPrincipal(data) {
  return request('/enterprise/train/com-train/del-batch-principal', {
    method: 'POST',
    data: data || {}
  });
}
// 批量插入培训负责人
export function trainComTrainInsertBatchPrincipal(data) {
  return request('/enterprise/train/com-train/insert-batch-principal', {
    method: 'POST',
    data: data || {}
  });
}
// 问题人员弹窗
export function getComProblemPerNum(data) {
  return request('/enterprise/company/com-base-info/get-com-problem-per-num', {
    method: 'POST',
    data: data || {}
  }, false, true, false);
}
//【等级证】保安员就职记录显示
export function getPerWorkInfo(data) {
  return request('/system/per-base-info/get-per-work-info', {
    method: 'POST',
    data
  });
}
/**********************************************登录注册相关******************************************/

export const {
  systemPerAccountInfoVerificationPhone,
  systemPlatNewsSendVerificationCode,
  systemPlatNewsVerificationCode,
  systemPerAccountInfoSave,
  accesstoken,
  getPublicKey,
  getTencentImSig
} = apiLoginRegister;

/**********************************************审批相关******************************************/

export const {
  getApprovalTypeList,
  getApprovalList,
  getApproveAttendLeaveApply,
  getApproveAttendOvertimeApply,
  getTaskAdjustDetail,
  getApproveAttendRemedyApply,
  getApproveTaskLeaveApply,
  getApproveTaskRemedyApply,
  changeApprovalTempStatus
} = apiApproval;

/**********************************************薪酬管理******************************************/

export const {
  taskComSalaryCalSalary,
  taskComSalaryPageForPersalary,
  taskSalaryTempPageComSalaryTemp,
  taskSalaryTempGetConfigSalaryType,
  taskSalaryTempSaveComSalaryTemp,
  taskSalaryTempCopyComSalaryTemp,
  taskSalaryTempDelComSalaryTemp,
  taskSalaryTempGetComSalaryTempInfo,
  taskComSalaryBatchAccountSalary,
  taskComSalarySalaryDetail,
  taskComSalaryUpdateSalary,
  taskSalaryTempCheckSalaryTempPer,
  taskComSalaryCheckIsAccount,
  taskComSalaryDeleteSalaryGrant,
  comSalarySyncInitCheckIsInit,
  saveComSalarySyncInit,
  contractsCheck
} = apiSalaryManage;

/**********************************************华为会议******************************************/

export const {
  getComHuaweiMeet,
  getHuaweiAccesstoken,
  addUser,
  getHuaweiManageResource,
  setRegulatorMeetCharge,
  cancelRegulatorMeetCharge,
  pageForHuaweiMeetPerInfo,
  batchDeleteUser,
  getHuaweiPerListByKeyword,
  getHuaweiDepartPersonList,
  sendHuaweiMeetSms,
  buildHuaweiMeet,
  getHuaweiUserDetail,
  getProductList,
  checkProductCoupon,
  saveOrder,
  sendPayVerifycode,
  checkOrder,
  getOrderList,
  getPayPhone,
  getTranscribeFileList,
  batchDeleteTranscribeFile,
  getHuaweiCloudMeetRoomList,
  updateHuaweiCloudMemberVmr,
  assignToMember,
  recycleFromMember,
  getHuaweiCloudMemberVmrList,
  getHuaweiMeetList,
  getHuaweiMeetDetail
} = apiMeeting

/**********************************************临保******************************************/
export const {
  getComListByProvince,
  saveTempTask,
  getReleaseTempTaskList,
  getTempTaskDetailt,
  getTempTaskDetail,
  getTaskPerList,
  getChargePerInfo,
  saveChargePer,
  addTempTaskPer,
  removeTempTaskPer,
  getTempTaskComList,
  getAttendAddressList,
  deleteAttendAddress,
  saveAttendAddress,
  getActivityList,
  getShareTempTaskList,
  cancelTempTask,
  endTempTask,
  syncTempTask
}= apiTempTask

export const {
  getComTaskList,
  getComTempTaskList,
  getComTaskPerLocation,
  getComTempTaskPerLocation,
  getComTaskStationType,
  getComTempTaskStationType,
  findComVideoRoomPage,
  getVideoRoomDetail,
  updateRoomEndTime,
  policeGetComList,
  policeGetPerLocationByKeyword,
  policeGetTaskStationType,
  policeGetTaskList,
  policeGetPerLocationPageList,
  getPerInfoList,
  policeGetTaskLocationList,
  policeGetTaskById
} = apiCommand