import React, { Component } from 'react';
import {
  Modal,
  Button,
  Alert
} from "antd";
import ExcelButtonOline from '../../../../../components/ExcelButtonOline';
import PTable from '../../../../../components/Pro/PTable';
import SearchForm from './SearchForm';
import styles from './person.less';
import SelectPersonnelPop from '../../../../../components/SelectPersonnelPop';
import {
  getChargePerInfo,
  getTreeperBydepart,
  removeTempTaskPer,
  saveChargePer,
  removeTaskPer,
  addTempTaskPer
} from '../../../../../services/api';
import columnsFun from './columns';
import { checkMember } from '../../../../../utils/utils';
export default class PersonMan extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: { //任务列表请求参数
        pageSize: 10,
        pageNumber: 1,
        comTempTaskId: this.props.comTempTaskId
      },

      paramsInit: false, //参数是否准备好

      treeData: [], //部门树
      updateVisibleuser: false, //修改负责人弹窗
      addVisibleuser: false, //添加人员弹窗

      taskPersonVisible: false, //驻勤人员弹窗
      taskPerArray: [],  //驻勤人员
      chargeInfo: null,  //任务负责人详情

      selectedRowKeys: [],
      selectedRows: [],
      treePerIds: []
    }
  }
  componentDidMount() {
    getTreeperBydepart().then(
      response => {
        const responseData = checkMember(response.data);
        this.setState({ treeData: responseData });
      }
    );
    this._getChargePerInfo()
  }
  //查询任务负责人信息
  _getChargePerInfo() {
    getChargePerInfo({ comTempTaskId: this.props.comTempTaskId }).then(res => {
      console.log(res)
      if (res.retType === '0') {
        this.setState({
          chargeInfo: res.data
        })
      }
    })
  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      paramsInit: true
    });
  }
  //刷新列表
  updateTable() {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      })
    })
  }
  //移除人员
  _removeTempTaskPer(selectedRow) {
    this.setState({
      selectedRows: [],
      selectedRowKeys: []
    })
    let data = []
    if (selectedRow.length > 0) {
      selectedRow.forEach(item => {
        data.push(item.perId)
      })
    }
    const _this = this
    removeTempTaskPer({ comTempTaskId: this.props.comTempTaskId, perIds: data.join(",") }).then(res => {
      if (res.retType === '0') {
        this.updateTable()
        _this.props._updateTable()
      }
    })
  }
  render() {
    const columns = columnsFun.call(this);
    const { chargeInfo } = this.state
    return (
      <div>
        <Alert
          message={<div>
            <span>任务负责人：只支持承保保安公司的人员；</span><br />
            <span>任务成员：企业只能添加/移除自己企业下的人员。</span><br />
          </div>}
          type="warning"
          showIcon
        />
        <div className={styles.main_info}>
          <i>*</i>
          <span>驻勤负责人:</span>
          {chargeInfo && <span>{chargeInfo.name} ({`${chargeInfo.idCardNo} | ${chargeInfo.mobilePhone}`})</span>}
          <Button type="primary" onClick={() => { this.setState({ updateVisibleuser: true }); }} disabled={this.props.readOnly||this.props.noUpdate}>修改</Button>
        </div>
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
          comTempTaskId={this.props.comTempTaskId}
        />
        <div className={styles.btns}>
          <Button type="primary" onClick={() => { this.setState({ addVisibleuser: true, treePerIds: [] }); }} disabled={this.props.readOnly}>添加</Button>
          <Button type="danger"
            disabled={this.props.readOnly}
            onClick={() => {
              const { selectedRows } = this.state;
              if (selectedRows.length == 0) {
                return Modal.warning({
                  title: '温馨提示',
                  content: '请先选择人员'
                });
              } else {
                Modal.confirm({
                  title: '即将移除人员',
                  content: '是否继续？',
                  okText: '继续',
                  okType: 'danger',
                  cancelText: '取消',
                  onOk: () => {
                    this._removeTempTaskPer(this.state.selectedRows)
                  }
                });
              }
            }}
          >移除</Button>
          <ExcelButtonOline
            params={this.state.pageParm}
            apiurl={'/task/tempTask/per/export-task-per'}
            downloadname={'任务人员管理表格'}
          >
            导出
            </ExcelButtonOline>
          {
            this.state.paramsInit && <PTable
              style={{ marginTop: 10 }}
              columns={columns}
              url="getTaskPerList"
              pageParm={this.state.pageParm}
              forceUpdate={this.state.forceUpdate}
              rowSelection={{
                onChange: (selectedRowKeys, selectedRows) => {
                  this.setState({
                    selectedRows,
                    selectedRowKeys
                  });
                },
                selectedRowKeys: this.state.selectedRowKeys,
                getCheckboxProps: record => ({
                  disabled: record.isCanDelete === '0', // Column configuration not to be checked
                  // name: record.name,
                }),
              }}
              pagination={{ showTotal: total => `总共 ${total} 条` }}
            />
          }

        </div>
        {
          this.state.updateVisibleuser && <SelectPersonnelPop
            onCheck={(checkedkeys, arrayObj) => {
              this.setState({ updateVisibleuser: false });
              saveChargePer({ comTempTaskId: this.props.comTempTaskId, chargePerId: checkedkeys }).then(res => {
                if (res.retType === '0') {
                  this._getChargePerInfo()
                }
              });
            }}
            visible={this.state.updateVisibleuser}
            type={'radio'}
            handleCancel={() => { this.setState({ updateVisibleuser: false }); }}
          />
        }

        {
          this.state.addVisibleuser && <SelectPersonnelPop
            onCheck={(checkedkeys, arrayObj) => {
              this.setState({ addVisibleuser: false });
              const _this = this
              addTempTaskPer({ comTempTaskId: this.props.comTempTaskId, perIds: checkedkeys.join(",") }).then(res => {
                if (res.retType === '0') {
                  this.updateTable()
                  _this.props._updateTable()
                }
              });
            }}
            visible={this.state.addVisibleuser}
            type={'checkbox'}
            handleCancel={() => { this.setState({ addVisibleuser: false }); }}
          />
        }
      </div>
    );
  }
}
