/**
 * 添加共保企业
 */
import React, { Component } from "react";
import {
  Alert,
  Button,
  Form,
  Modal,
  message,
  Badge,
  Tabs,
  Popover,
  notification,
  Input,
  Table
} from "antd";
import st from "styled-components";
import { getComListByProvince } from '../../../../services/api';
@Form.create()
export default class AddShareTask extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      dataList: [],
      keyWord: '',
      paramsInit: false, //参数是否准备好
      selectedRows: null,
    };
    this.setParentState = this.props.setParentState;
  }

  componentDidMount() {
  }
  _getComListByProvince(keyWord) {
    getComListByProvince({ keyWord }).then(res => {
      if (res.retType === '0') {
        this.setState({
          dataList: res.data
        })
      }
    })
  }
  //必选框的标致
  mustLabel() {
    return (
      <span style={{ color: 'red' }}>*</span>
    )
  }
  render() {
    const columns = [{
      title: "企业名称",
      dataIndex: "comName",
      key: "comName"
    }, {
      title: "统一社会信用代码",
      dataIndex: "comCerNo",
      key: "comCerNo",
    }]
    return (
      <Modal
        width="800px"
        title="添加共保企业"
        visible={this.props.visible}
        okText="确定"
        cancelText="取消"
        onOk={() => {
          this.props.changeSelectValue(this.state.selectedRows)
        }}
        onCancel={() => {
          this.setParentState({
            // comContractList: selectedRows,
            shareTaskVisble: false
          });
          // this.props.onChangeStatus(false)
        }}
      >
        <label style={{ display: 'inline-block', marginRight: '16px' }}>
          {this.mustLabel()}关键词：
            <Input
            style={{
              width: '214px',
              marginLeft: '16px',
              marginBottom: '16px'
            }}
            placeholder="请输入企业名称或统一社会信用代码"
            onChange={(e) => {
              this.setState({
                keyWord: e.target.value.trim()
              });
            }}
            maxLength={30}
          />
        </label>

        <Button
          id="btnSearch"
          type="primary"
          onClick={() => {
            if (this.state.keyWord) {
              this._getComListByProvince(this.state.keyWord)
            } else {
              message.warning("请先输入搜索字段")
            }
          }}
          style={{ marginBottom: '16px', marginLeft: 20 }}
        >
          搜索
        </Button>
        <Table
          columns={columns}
          dataSource={this.state.dataList}
          rowSelection={{
            onChange: (selectedRowKeys, selectedRows) => {
              this.setState({
                selectedRows,
                selectedRowKeys
              });
            },
            selectedRowKeys: this.state.selectedRowKeys
          }}
        ></Table>

      </Modal>
    );
  }
}

const Btns = st.div`
  margin: 10px;
  >button{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
